/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.texture_handlers;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.ETFApi;
import traben.entity_texture_features.config.ETFConfig;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.features.ETFRenderContext;
import traben.entity_texture_features.features.property_reading.PropertiesRandomProvider;
import traben.entity_texture_features.features.texture_handlers.ETFDirectory;
import traben.entity_texture_features.features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFEntity;
import traben.entity_texture_features.utils.ETFUtils2;
import traben.entity_texture_features.utils.EntityIntLRU;

public abstract class ETFTextureVariator {
    @NotNull
    public static ETFTextureVariator of(@NotNull class_2960 vanillaIdentifier) {
        ETFApi.ETFVariantSuffixProvider variantProvider = ETFApi.ETFVariantSuffixProvider.getVariantProviderOrNull(ETFUtils2.replaceIdentifier(vanillaIdentifier, ".png", ".properties"), vanillaIdentifier, "skins", "textures");
        if (variantProvider != null) {
            return new ETFTextureMultiple(vanillaIdentifier, variantProvider);
        }
        return new ETFTextureSingleton(vanillaIdentifier);
    }

    /*
     * Unable to fully structure code
     */
    public ETFTexture getVariantOf(@NotNull ETFEntity entity) {
        block2: {
            if (ETFManager.getInstance().ENTITY_DEBUG == null || !ETFManager.getInstance().ENTITY_DEBUG.equals(entity.etf$getUuid())) break block2;
            inChat = ETF.config().getConfig().debugLoggingMode == ETFConfig.DebugLogMode.Chat;
            output = this.getVariantOfInternal(entity);
            v0 = ETFManager.getInstance().getGeneralPrintout();
            v1 = entity.etf$getType() != null ? entity.etf$getType().method_5882() : null;
            var5_4 = this;
            if (!(var5_4 instanceof ETFTextureMultiple)) ** GOTO lbl-1000
            multi = (ETFTextureMultiple)var5_4;
            if (multi.suffixProvider.entityCanUpdate(entity.etf$getUuid())) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            ETFUtils2.logMessage("\n\u00a7e-----------ETF Debug Printout-------------\u00a7r\n" + v0 + "\n\u00a7eEntity:\u00a7r\n\u00a76 - type:\u00a7r " + v1 + "\n\u00a76 - texture:\u00a7r " + output + "\n\u00a76 - can_update_variant:\u00a7r " + v2 + "\n" + this.getVanillaVariantDetails() + "\n" + this.getPrintout() + "\n\u00a7e----------------------------------------\u00a7r", inChat);
            ETFManager.getInstance().ENTITY_DEBUG = null;
            return output;
        }
        return this.getVariantOfInternal(entity);
    }

    private String getVanillaVariantDetails() {
        class_2960 vanilla = this.getVanillaIdentifier();
        if (vanilla == null) {
            return "\u00a7aProperty locations: NULL\u00a7r";
        }
        class_2960 property = ETFUtils2.replaceIdentifier(vanilla, ".png", ".properties");
        if (property == null) {
            return "\u00a7aProperty locations: NULL\u00a7r";
        }
        class_2960 optifine = ETFDirectory.getIdentifierAsDirectory(property, ETFDirectory.OPTIFINE);
        class_2960 optifineOld = ETFDirectory.getIdentifierAsDirectory(property, ETFDirectory.OLD_OPTIFINE);
        class_2960 etf = ETFDirectory.getIdentifierAsDirectory(property, ETFDirectory.ETF);
        return "\u00a7aProperty locations:\u00a7r\n\u00a72 - regular:\u00a7r " + property + "\n\u00a72 - etf:\u00a7r " + etf + "\n\u00a72 - optifine:\u00a7r " + optifine + "\n\u00a72 - optifine_old:\u00a7r " + optifineOld;
    }

    public abstract String getPrintout();

    @NotNull
    protected abstract ETFTexture getVariantOfInternal(@NotNull ETFEntity var1);

    protected abstract class_2960 getVanillaIdentifier();

    private static class ETFTextureMultiple
    extends ETFTextureVariator {
        @NotNull
        public final EntityIntLRU entitySuffixMap = new EntityIntLRU(500);
        @NotNull
        final ETFApi.ETFVariantSuffixProvider suffixProvider;
        @NotNull
        private final Int2ObjectArrayMap<ETFTexture> variantMap = new Int2ObjectArrayMap();
        @NotNull
        private final class_2960 vanillaId;

        ETFTextureMultiple(@NotNull class_2960 vanillaId, @NotNull ETFApi.ETFVariantSuffixProvider suffixProvider) {
            this.vanillaId = vanillaId;
            this.entitySuffixMap.defaultReturnValue(-1);
            this.suffixProvider = suffixProvider;
            if (suffixProvider instanceof PropertiesRandomProvider) {
                ((PropertiesRandomProvider)suffixProvider).setOnMeetsRuleHook((entity, rule) -> {
                    if (rule == null) {
                        ETFManager.getInstance().LAST_RULE_INDEX_OF_ENTITY.removeInt(entity.etf$getUuid());
                    } else {
                        ETFManager.getInstance().LAST_RULE_INDEX_OF_ENTITY.put(entity.etf$getUuid(), rule.RULE_NUMBER);
                    }
                });
            }
            class_2960 directorized = ETFDirectory.getDirectoryVersionOf(vanillaId);
            ETFTexture vanilla = ETFManager.getInstance().getETFTextureNoVariation(directorized == null ? vanillaId : directorized);
            this.variantMap.put(1, (Object)vanilla);
            this.variantMap.defaultReturnValue((Object)vanilla);
            boolean logging = ETF.config().getConfig().logTextureDataInitialization;
            if (logging) {
                ETFUtils2.logMessage("Initializing texture for the first time: " + vanillaId);
            }
            IntOpenHashSet suffixes = suffixProvider.getAllSuffixes();
            suffixes.remove(0);
            suffixes.remove(1);
            IntIterator intIterator = suffixes.iterator();
            while (intIterator.hasNext()) {
                int suffix = (Integer)intIterator.next();
                class_2960 variant = ETFDirectory.getDirectoryVersionOf(ETFUtils2.addVariantNumberSuffix(vanillaId, suffix));
                if (logging) {
                    ETFUtils2.logMessage(" - looked for variant: " + variant);
                }
                if (variant != null) {
                    this.variantMap.put(suffix, (Object)ETFManager.getInstance().getETFTextureNoVariation(variant));
                    continue;
                }
                if (logging) {
                    ETFUtils2.logMessage("   - failed to find variant: " + suffix);
                }
                this.variantMap.put(suffix, (Object)vanilla);
            }
            if (logging) {
                ETFUtils2.logMessage("Final variant map for: " + vanillaId);
                this.variantMap.forEach((k, v) -> ETFUtils2.logMessage(" - " + k + " = " + v));
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ETFTextureMultiple that = (ETFTextureMultiple)o;
            return this.vanillaId.equals((Object)that.vanillaId);
        }

        public int hashCode() {
            return Objects.hash(this.vanillaId);
        }

        @Override
        public String getPrintout() {
            return "\u00a7bTexture: \u00a7r\n\u00a73 - base texture:\u00a7r " + this.vanillaId + "\n\u00a73 - variates:\u00a7r yes\n\u00a73 - set by properties:\u00a7r " + (this.suffixProvider instanceof PropertiesRandomProvider) + "\n\u00a73 - variant count:\u00a7r " + this.variantMap.size() + "\n\u00a73 - all suffixes:\u00a7r " + this.variantMap.keySet();
        }

        public void checkIfShouldExpireEntity(UUID id) {
            if (this.suffixProvider.entityCanUpdate(id)) {
                switch (ETF.config().getConfig().textureUpdateFrequency_V2) {
                    case Never: {
                        break;
                    }
                    case Instant: {
                        this.entitySuffixMap.removeInt(id);
                        break;
                    }
                    default: {
                        int delay = ETF.config().getConfig().textureUpdateFrequency_V2.getDelay();
                        assert (ETFRenderContext.getCurrentEntity() != null);
                        int time = (int)(ETFRenderContext.getCurrentEntity().etf$getWorld().method_8510() % (long)delay);
                        if (time != Math.abs(id.hashCode()) % delay) break;
                        this.entitySuffixMap.removeInt(id);
                    }
                }
            }
        }

        @Override
        @NotNull
        protected ETFTexture getVariantOfInternal(@NotNull ETFEntity entity) {
            int newSuffix;
            ETFManager.TextureSource source = ETFRenderContext.isRenderingFeatures() ? ETFManager.TextureSource.ENTITY_FEATURE : (entity.etf$isBlockEntity() ? ETFManager.TextureSource.BLOCK_ENTITY : ETFManager.TextureSource.ENTITY);
            UUID id = entity.etf$getUuid();
            int knownSuffix = this.entitySuffixMap.getInt(id);
            if (knownSuffix != -1) {
                if (source != ETFManager.TextureSource.BLOCK_ENTITY) {
                    this.checkIfShouldExpireEntity(id);
                }
                return (ETFTexture)this.variantMap.get(knownSuffix);
            }
            if (source == ETFManager.TextureSource.ENTITY_FEATURE) {
                if (this.suffixProvider instanceof PropertiesRandomProvider) {
                    newSuffix = this.suffixProvider.getSuffixForETFEntity(entity);
                } else {
                    int baseEntitySuffix;
                    int n = baseEntitySuffix = ETFRenderContext.getCurrentEntity() == null ? -1 : ETFManager.getInstance().LAST_SUFFIX_OF_ENTITY.getInt(ETFRenderContext.getCurrentEntity().etf$getUuid());
                    newSuffix = baseEntitySuffix != -1 && this.variantMap.containsKey(baseEntitySuffix) ? baseEntitySuffix : this.suffixProvider.getSuffixForETFEntity(entity);
                }
            } else {
                newSuffix = this.suffixProvider.getSuffixForETFEntity(entity);
                ETFManager.getInstance().LAST_SUFFIX_OF_ENTITY.put(id, newSuffix);
            }
            this.entitySuffixMap.put(id, newSuffix);
            return (ETFTexture)this.variantMap.get(newSuffix);
        }

        @Override
        protected class_2960 getVanillaIdentifier() {
            return this.vanillaId;
        }
    }

    public static class ETFTextureSingleton
    extends ETFTextureVariator {
        private final ETFTexture self;
        private final class_2960 vanilla;

        public ETFTextureSingleton(class_2960 singletonId) {
            this.vanilla = singletonId;
            this.self = ETFManager.getInstance().getETFTextureNoVariation(singletonId);
            if (ETF.config().getConfig().logTextureDataInitialization) {
                ETFUtils2.logMessage("Initializing texture for the first time: " + singletonId);
                ETFUtils2.logMessage(" - no variants for: " + this.self);
            }
        }

        @Override
        @NotNull
        protected ETFTexture getVariantOfInternal(@NotNull ETFEntity entity) {
            return this.self;
        }

        @Override
        protected class_2960 getVanillaIdentifier() {
            return this.vanilla;
        }

        @Override
        public String getPrintout() {
            return "\u00a7bTexture: \u00a7r\n\u00a73 - base texture:\u00a7r " + this.self.toString() + "\n\u00a73 - variates:\u00a7r no";
        }
    }
}

