/*
 * Decompiled with CFR 0.152.
 */
package com.sudolev.interiors.fabric;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.sudolev.interiors.CreateInteriors;
import io.github.fabricators_of_create.porting_lib.data.ExistingFileHelper;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;

public class CIDatagen
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator gen) {
        CreateInteriors.LOGGER.info("Initializing data generator");
        Path resources = Paths.get(System.getProperty("porting_lib.datagen.existing_resources"), new String[0]);
        ExistingFileHelper helper = new ExistingFileHelper(Set.of(resources), Set.of("create"), false, null, null);
        CreateInteriors.REGISTRATE.setupDatagen(gen.createPack(), helper);
        CIDatagen.provideDefaultLang("tooltips");
    }

    private static void provideDefaultLang(String fileName) {
        String path = "assets/interiors/lang/default/" + fileName + ".json";
        JsonObject jsonObject = ((JsonElement)Preconditions.checkNotNull((Object)FilesHelper.loadJsonResource((String)path), (String)"Could not find default lang file: %s", (Object)path)).getAsJsonObject();
        jsonObject.entrySet().forEach(entry -> CreateInteriors.REGISTRATE.addRawLang((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString()));
    }
}

