/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.fabric;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.railwayteam.railways.util.RegistrationListening;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class RegistrationListeningImpl {
    private static final Map<class_2378<?>, Callback<?>> callbacks = new HashMap();

    public static <T> void addListener(RegistrationListening.Listener<T> listener) {
        callbacks.computeIfAbsent(listener.registry(), Callback::new).addListener(listener);
    }

    private static class Callback<T>
    implements RegistryEntryAddedCallback<T> {
        private final Multimap<class_2960, RegistrationListening.Listener<T>> listeners = HashMultimap.create();
        private final class_2378<T> registry;
        private final Set<class_2960> beforeListeningStart;

        public Callback(class_2378<T> registry) {
            this.registry = registry;
            RegistryEntryAddedCallback.event(registry).register((Object)this);
            this.beforeListeningStart = registry.method_10235();
        }

        protected void addListener(RegistrationListening.Listener<T> listener) {
            class_2960 id = listener.id();
            if (this.beforeListeningStart.contains(id)) {
                listener.onRegister(this.registry.method_10223(id));
            } else {
                this.listeners.put((Object)id, listener);
            }
        }

        public void onEntryAdded(int rawId, class_2960 id, T object) {
            this.listeners.get((Object)id).forEach(listener -> listener.onRegister(object));
        }
    }
}

