/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation;

import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1451;
import net.minecraft.class_1453;
import net.minecraft.class_1493;
import net.minecraft.class_1676;
import net.minecraft.class_1690;
import net.minecraft.class_1695;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4019;
import net.minecraft.class_5354;
import net.minecraft.class_7134;
import net.minecraft.class_7689;
import net.minecraft.class_922;
import traben.entity_model_features.EMF;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.mixin.accessor.EntityRenderDispatcherAccessor;
import traben.entity_model_features.mixin.accessor.MinecraftClientAccessor;
import traben.entity_model_features.models.EMFModelPartRoot;
import traben.entity_model_features.utils.EMFEntity;
import traben.entity_model_features.utils.EMFManager;
import traben.entity_model_features.utils.EMFOptiFinePartNameMappings;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_model_features.utils.OptifineMobNameForFileAndEMFMapId;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.config.ETFConfig;

public class EMFAnimationEntityContext {
    private static final Object2IntOpenHashMap<UUID> knownHighestAngerTimeByUUID = new Object2IntOpenHashMap<UUID>(){
        {
            this.defaultReturnValue(0);
        }
    };
    private static final Object2IntOpenHashMap<UUID> lodEntityTimers = new Object2IntOpenHashMap();
    public static boolean setInHand = false;
    public static boolean setInItemFrame = false;
    public static boolean setIsOnHead = false;
    public static double lastFOV = 70.0;
    public static boolean is_in_ground_override = false;
    private static EMFEntity emfEntity = null;
    private static float shadowSize = Float.NaN;
    private static float shadowOpacity = Float.NaN;
    private static float leashX = Float.NaN;
    private static float leashY = Float.NaN;
    private static float leashZ = Float.NaN;
    private static float shadowX = Float.NaN;
    private static float shadowZ = Float.NaN;
    private static float limbAngle = Float.NaN;
    private static float limbDistance = Float.NaN;
    private static float headYaw = Float.NaN;
    private static float headPitch = Float.NaN;
    private static float tickDelta = 0.0f;
    private static boolean onShoulder = false;
    private static Function<class_2960, class_1921> layerFactory = null;
    private static Boolean lodFrameSkipping = null;
    private static boolean announceModels = false;
    public static boolean isFirstPersonHand = false;

    private EMFAnimationEntityContext() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isJumping() {
        EMFEntity eMFEntity = emfEntity;
        if (!(eMFEntity instanceof class_1309)) return false;
        class_1309 alive = (class_1309)eMFEntity;
        if (!alive.field_6282) return false;
        return true;
    }

    public static void setEntityVariable(String variable, float value) {
        if (emfEntity != null) {
            emfEntity.emf$getVariableMap().put((Object)variable, value);
        }
    }

    public static float getEntityVariable(String variable, float defaultValue) {
        if (emfEntity == null) {
            return defaultValue;
        }
        return emfEntity.emf$getVariableMap().getOrDefault((Object)variable, defaultValue);
    }

    public static void setLayerFactory(Function<class_2960, class_1921> layerFactory) {
        EMFAnimationEntityContext.layerFactory = layerFactory;
    }

    private static int distanceOfEntityFrom(class_2338 pos) {
        if (emfEntity == null) {
            return 0;
        }
        class_2338 blockPos = emfEntity.etf$getBlockPos();
        float f = blockPos.method_10263() - pos.method_10263();
        float g = blockPos.method_10264() - pos.method_10264();
        float h = blockPos.method_10260() - pos.method_10260();
        return (int)class_3532.method_15355((float)(f * f + g * g + h * h));
    }

    private static int getLODFactorOfEntity() {
        class_1297 entity;
        float entitySize;
        EMFEntity eMFEntity;
        int lodFactor;
        if (((EMFConfig)EMF.config().getConfig()).animationLODDistance == 0) {
            return 0;
        }
        if (class_310.method_1551().field_1724 == null || class_310.method_1551().field_1724.method_31550()) {
            return 0;
        }
        int distance = EMFAnimationEntityContext.distanceOfEntityFrom(class_310.method_1551().field_1724.method_24515());
        if (distance < 1) {
            return 0;
        }
        int factor = distance / ((EMFConfig)EMF.config().getConfig()).animationLODDistance;
        int factorByFOV = (int)((double)factor * lastFOV / 70.0);
        if (((EMFConfig)EMF.config().getConfig()).retainDetailOnLowFps && class_310.method_1551().method_47599() < 59) {
            float fpsPercentageOf60 = (float)class_310.method_1551().method_47599() / 60.0f;
            lodFactor = (int)((float)factorByFOV * fpsPercentageOf60);
        } else {
            lodFactor = factorByFOV;
        }
        if (((EMFConfig)EMF.config().getConfig()).retainDetailOnLargerMobs && (eMFEntity = emfEntity) instanceof class_1297 && (entitySize = Math.max((entity = (class_1297)eMFEntity).method_17681(), entity.method_17682())) > 2.0f) {
            lodFactor = (int)((float)lodFactor / (entitySize / 2.0f));
        }
        return lodFactor;
    }

    public static boolean isLODSkippingThisFrame() {
        if (lodFrameSkipping != null) {
            return lodFrameSkipping;
        }
        if (((EMFConfig)EMF.config().getConfig()).animationLODDistance == 0 || emfEntity == null) {
            return false;
        }
        int lodTimer = lodEntityTimers.getInt((Object)emfEntity.etf$getUuid());
        int lodResult = lodTimer < 1 ? EMFAnimationEntityContext.getLODFactorOfEntity() : lodTimer - 1;
        lodEntityTimers.put((Object)emfEntity.etf$getUuid(), lodResult);
        lodFrameSkipping = lodResult > 0;
        return lodFrameSkipping;
    }

    public static void setCurrentEntityIteration(EMFEntity entityIn) {
        isFirstPersonHand = false;
        ++EMFManager.getInstance().entityRenderCount;
        layerFactory = null;
        tickDelta = class_310.method_1551().method_1493() ? ((MinecraftClientAccessor)class_310.method_1551()).getPausedTickDelta() : class_310.method_1551().method_1488();
        shadowSize = Float.NaN;
        shadowOpacity = Float.NaN;
        leashX = 0.0f;
        leashY = 0.0f;
        leashZ = 0.0f;
        shadowX = 0.0f;
        shadowZ = 0.0f;
        EMFAnimationEntityContext.newEntity(entityIn);
        if (entityIn != null) {
            Set roots = (Set)EMFManager.getInstance().rootPartsPerEntityTypeForVariation.get((Object)entityIn.emf$getTypeString());
            if (roots != null) {
                roots.forEach(Runnable::run);
            }
            if (((EMFConfig)EMF.config().getConfig()).debugOnRightClick && entityIn.etf$getUuid().equals(EMFManager.getInstance().entityForDebugPrint)) {
                announceModels = true;
                EMFManager.getInstance().entityForDebugPrint = null;
            }
        }
        lodFrameSkipping = null;
    }

    public static void anounceModels(EMFEntity assertEntity) {
        StringBuilder model;
        int count;
        String type = assertEntity.emf$getTypeString();
        Set debugRoots = (Set)EMFManager.getInstance().rootPartsPerEntityTypeForDebug.get((Object)type);
        EMFUtils.chat("\u00a7e-----------EMF Debug Printout-------------\u00a7r");
        if (debugRoots == null) {
            EMFUtils.chat("\n\u00a7c\u00a7oThe EMF debug printout did not find any custom models registered to the following entity:\n \u00a73\u00a7l\u00a7u" + type);
        } else {
            String message = "\n\u00a72\u00a7oThe EMF debug printout found the following custom models for the entity:\n \u00a73\u00a7l\u00a7u" + type + "\u00a7r\n\u00a72\u00a7oThis first model is usually the primary model for the entity.";
            EMFUtils.chat(message);
            count = 1;
            for (EMFModelPartRoot debugRoot : debugRoots) {
                model = new StringBuilder();
                model.append("\u00a7eModel #").append(count).append("\u00a7r").append(EMFAnimationEntityContext.entryAndValue("name", debugRoot.modelName.getfileName() + ".jem"));
                if (debugRoot.variantDirectoryApplier != null) {
                    model.append(EMFAnimationEntityContext.entryAndValue("directory", debugRoot.variantDirectoryApplier.getThisDirectoryOfFilename(debugRoot.modelName.getNamespace(), debugRoot.modelName.getfileName())));
                }
                if (debugRoot.textureOverride != null) {
                    model.append(EMFAnimationEntityContext.entryAndValue("texture_override", debugRoot.textureOverride.toString()));
                }
                if (debugRoot.variantTester != null) {
                    IntArraySet set = new IntArraySet(debugRoot.allKnownStateVariants.keySet());
                    set.remove(0);
                    model.append(EMFAnimationEntityContext.entryAndValue("model_variants", set.toString())).append(EMFAnimationEntityContext.entryAndValue("current_variant", String.valueOf(debugRoot.currentModelVariant)));
                }
                EMFUtils.chat(model + "\n\u00a76 - parts:\u00a7r printed in game log only.");
                EMFUtils.log("\n - parts: " + debugRoot.simplePrintChildren(0));
                ++count;
            }
        }
        EMFUtils.chat("\n\u00a7e----------------------------------------\u00a7r");
        if (!EMFManager.getInstance().modelsAnnounced.isEmpty()) {
            String vanillaMessage = "\n\u00a72\u00a7oThe EMF debug printout found the following non-custom models for the entity:\n \u00a73\u00a7l\u00a7u" + type + "\u00a7r\n\u00a72\u00a7oThis first model is usually the primary model for the entity.";
            EMFUtils.chat(vanillaMessage);
            count = 1;
            for (OptifineMobNameForFileAndEMFMapId data : EMFManager.getInstance().modelsAnnounced) {
                model = new StringBuilder();
                model.append("\n\u00a7Non-Custom Model #").append(count).append("\u00a7r").append(EMFAnimationEntityContext.entryAndValue("possible .jem name", data.getDisplayFileName()));
                Map<String, String> map = EMFOptiFinePartNameMappings.getMapOf(data.getMapId(), null);
                if (!map.isEmpty()) {
                    EMFUtils.chat(model + "\n\u00a76 - part names:\u00a7r printed in game log only.");
                    StringBuilder parts = new StringBuilder();
                    parts.append("\n - part names: ");
                    map.forEach((k, v) -> parts.append("\n   | - [").append((String)k).append(']'));
                    EMFUtils.log(parts.toString());
                    continue;
                }
                EMFUtils.chat(model.toString());
                EMFUtils.log(" - part names: could not be found. use the 'printout unknown models' setting instead.");
            }
            EMFUtils.chat("\n\u00a7e----------------------------------------\u00a7r");
            EMFManager.getInstance().modelsAnnounced.clear();
        }
        announceModels = false;
    }

    public static boolean doAnnounceModels() {
        return announceModels;
    }

    private static String entryAndValue(String entry, String value) {
        return "\n\u00a76 - " + entry + ":\u00a7r " + value;
    }

    public static void setCurrentEntityNoIteration(EMFEntity entityIn) {
        EMFAnimationEntityContext.newEntity(entityIn);
    }

    private static void newEntity(EMFEntity entityIn) {
        emfEntity = entityIn;
        limbAngle = Float.NaN;
        limbDistance = Float.NaN;
        headYaw = Float.NaN;
        headPitch = Float.NaN;
        onShoulder = false;
    }

    public static void reset() {
        isFirstPersonHand = false;
        layerFactory = null;
        emfEntity = null;
        limbAngle = Float.NaN;
        limbDistance = Float.NaN;
        headYaw = Float.NaN;
        headPitch = Float.NaN;
        onShoulder = false;
        tickDelta = 0.0f;
        shadowSize = Float.NaN;
        shadowOpacity = Float.NaN;
        leashX = 0.0f;
        leashY = 0.0f;
        leashZ = 0.0f;
        shadowX = 0.0f;
        shadowZ = 0.0f;
        lodFrameSkipping = null;
    }

    public static class_1921 getLayerFromRecentFactoryOrETFOverrideOrTranslucent(class_2960 identifier) {
        if (layerFactory == null) {
            ETFConfig.RenderLayerOverride layer = ((ETFConfig)ETF.config().getConfig()).getRenderLayerOverride();
            if (layer == null) {
                return class_1921.method_23580((class_2960)identifier);
            }
            return switch (layer) {
                default -> throw new IncompatibleClassChangeError();
                case ETFConfig.RenderLayerOverride.TRANSLUCENT -> class_1921.method_23580((class_2960)identifier);
                case ETFConfig.RenderLayerOverride.TRANSLUCENT_CULL -> class_1921.method_23689((class_2960)identifier);
                case ETFConfig.RenderLayerOverride.END -> class_1921.method_34571();
                case ETFConfig.RenderLayerOverride.OUTLINE -> class_1921.method_23287((class_2960)identifier);
            };
        }
        return layerFactory.apply(identifier);
    }

    public static float getRuleIndex() {
        if (emfEntity == null) {
            return 0.0f;
        }
        return EMFManager.getInstance().lastModelRuleOfEntity.getInt((Object)emfEntity.etf$getUuid());
    }

    public static EMFEntity getEMFEntity() {
        return emfEntity;
    }

    public static float getDimension() {
        if (emfEntity == null || emfEntity.etf$getWorld() == null) {
            return 0.0f;
        }
        class_2960 id = emfEntity.etf$getWorld().method_44013().method_29177();
        if (id.equals((Object)class_7134.field_37671)) {
            return -1.0f;
        }
        if (id.equals((Object)class_7134.field_37672)) {
            return 1.0f;
        }
        return 0.0f;
    }

    public static float getPlayerX() {
        return class_310.method_1551().field_1724 == null ? 0.0f : (float)class_3532.method_16436((double)tickDelta, (double)class_310.method_1551().field_1724.field_6014, (double)class_310.method_1551().field_1724.method_23317());
    }

    public static float getPlayerY() {
        return class_310.method_1551().field_1724 == null ? 0.0f : (float)class_3532.method_16436((double)tickDelta, (double)class_310.method_1551().field_1724.field_6036, (double)class_310.method_1551().field_1724.method_23318());
    }

    public static float getPlayerZ() {
        return class_310.method_1551().field_1724 == null ? 0.0f : (float)class_3532.method_16436((double)tickDelta, (double)class_310.method_1551().field_1724.field_5969, (double)class_310.method_1551().field_1724.method_23321());
    }

    public static float getPlayerRX() {
        return class_310.method_1551().field_1724 == null ? 0.0f : (float)Math.toRadians(class_3532.method_17821((float)tickDelta, (float)class_310.method_1551().field_1724.field_6004, (float)class_310.method_1551().field_1724.method_36455()));
    }

    public static float getPlayerRY() {
        return class_310.method_1551().field_1724 == null ? 0.0f : (float)Math.toRadians(class_3532.method_17821((float)tickDelta, (float)class_310.method_1551().field_1724.field_5982, (float)class_310.method_1551().field_1724.method_36454()));
    }

    public static float getEntityX() {
        return emfEntity == null ? 0.0f : (float)class_3532.method_16436((double)EMFAnimationEntityContext.getTickDelta(), (double)emfEntity.emf$prevX(), (double)emfEntity.emf$getX());
    }

    public static float getEntityY() {
        return emfEntity == null ? 0.0f : (float)class_3532.method_16436((double)EMFAnimationEntityContext.getTickDelta(), (double)emfEntity.emf$prevY(), (double)emfEntity.emf$getY());
    }

    public static float getEntityZ() {
        return emfEntity == null ? 0.0f : (float)class_3532.method_16436((double)EMFAnimationEntityContext.getTickDelta(), (double)emfEntity.emf$prevZ(), (double)emfEntity.emf$getZ());
    }

    public static float getEntityRX() {
        return emfEntity == null ? 0.0f : (float)Math.toRadians(class_3532.method_17821((float)tickDelta, (float)emfEntity.emf$prevPitch(), (float)emfEntity.emf$getPitch()));
    }

    public static float getEntityRY() {
        float f;
        if (emfEntity == null) {
            return 0.0f;
        }
        EMFEntity eMFEntity = emfEntity;
        if (eMFEntity instanceof class_1309) {
            class_1309 alive = (class_1309)eMFEntity;
            f = (float)Math.toRadians(class_3532.method_17821((float)tickDelta, (float)alive.field_6220, (float)alive.method_43078()));
        } else {
            eMFEntity = emfEntity;
            if (eMFEntity instanceof class_1297) {
                class_1297 entity = (class_1297)eMFEntity;
                f = (float)Math.toRadians(class_3532.method_17821((float)tickDelta, (float)entity.field_5982, (float)entity.method_36454()));
            } else {
                f = 0.0f;
            }
        }
        return f;
    }

    public static float getTime() {
        if (emfEntity == null || emfEntity.etf$getWorld() == null) {
            return 0.0f + tickDelta;
        }
        long upTimeInTicks = emfEntity.etf$getWorld().method_8510();
        return EMFAnimationEntityContext.constrainedFloat(upTimeInTicks, 720720) + tickDelta;
    }

    public static float getDayTime() {
        if (emfEntity == null || emfEntity.etf$getWorld() == null) {
            return 0.0f + tickDelta;
        }
        return EMFAnimationEntityContext.constrainedFloat(emfEntity.etf$getWorld().method_8532(), 24000) + tickDelta;
    }

    public static float getDayCount() {
        if (emfEntity == null || emfEntity.etf$getWorld() == null) {
            return 0.0f + tickDelta;
        }
        return (float)(emfEntity.etf$getWorld().method_8532() / 24000L) + tickDelta;
    }

    public static float getHealth() {
        float f;
        if (emfEntity == null) {
            return 0.0f;
        }
        EMFEntity eMFEntity = emfEntity;
        if (eMFEntity instanceof class_1309) {
            class_1309 alive = (class_1309)eMFEntity;
            f = alive.method_6032();
        } else {
            f = 1.0f;
        }
        return f;
    }

    public static float getDeathTime() {
        float f;
        EMFEntity eMFEntity = emfEntity;
        if (eMFEntity instanceof class_1309) {
            class_1309 alive = (class_1309)eMFEntity;
            f = alive.field_6213;
        } else {
            f = 0.0f;
        }
        return f;
    }

    public static float getAngerTime() {
        if (!(emfEntity instanceof class_5354)) {
            return 0.0f;
        }
        float currentKnownHighest = knownHighestAngerTimeByUUID.getInt((Object)emfEntity.etf$getUuid());
        int angerTime = ((class_5354)emfEntity).method_29507();
        if (angerTime <= 0) {
            knownHighestAngerTimeByUUID.put((Object)emfEntity.etf$getUuid(), 0);
            return 0.0f;
        }
        if ((float)angerTime > currentKnownHighest) {
            knownHighestAngerTimeByUUID.put((Object)emfEntity.etf$getUuid(), angerTime);
        }
        return (float)angerTime - tickDelta;
    }

    public static float getAngerTimeStart() {
        return emfEntity instanceof class_5354 ? (float)knownHighestAngerTimeByUUID.getInt((Object)emfEntity.etf$getUuid()) : 0.0f;
    }

    public static float getMaxHealth() {
        float f;
        EMFEntity eMFEntity = emfEntity;
        if (eMFEntity instanceof class_1309) {
            class_1309 alive = (class_1309)eMFEntity;
            f = alive.method_6063();
        } else {
            f = 1.0f;
        }
        return f;
    }

    public static float getId() {
        return emfEntity == null ? 0.0f : (float)emfEntity.etf$getUuid().hashCode();
    }

    public static float getHurtTime() {
        float f;
        EMFEntity eMFEntity = emfEntity;
        if (eMFEntity instanceof class_1309) {
            class_1309 alive = (class_1309)eMFEntity;
            f = alive.field_6235 > 0 ? (float)alive.field_6235 - tickDelta : 0.0f;
        } else {
            f = 0.0f;
        }
        return f;
    }

    public static float getHeightAboveGround() {
        if (emfEntity == null) {
            return 0.0f;
        }
        float y = EMFAnimationEntityContext.getEntityY();
        class_2338 pos = emfEntity.etf$getBlockPos();
        int worldBottom = emfEntity.etf$getWorld().method_31607();
        while (!EMFAnimationEntityContext.emfEntity.etf$getWorld().method_8320((class_2338)pos).method_26204().field_23159 && pos.method_10264() > worldBottom) {
            pos = pos.method_10074();
        }
        return y - (float)pos.method_10264();
    }

    public static float getFluidDepthDown() {
        if (emfEntity == null || emfEntity.etf$getWorld().method_8316(emfEntity.etf$getBlockPos()).method_15769()) {
            return 0.0f;
        }
        class_2338 pos = emfEntity.etf$getBlockPos();
        int worldBottom = emfEntity.etf$getWorld().method_31607();
        while (!emfEntity.etf$getWorld().method_8316(pos).method_15769() && pos.method_10264() > worldBottom) {
            pos = pos.method_10074();
        }
        return emfEntity.etf$getBlockPos().method_10264() - pos.method_10264();
    }

    public static float getFluidDepthUp() {
        if (emfEntity == null || emfEntity.etf$getWorld().method_8316(emfEntity.etf$getBlockPos()).method_15769()) {
            return 0.0f;
        }
        class_2338 pos = emfEntity.etf$getBlockPos();
        int worldTop = emfEntity.etf$getWorld().method_31600();
        while (!emfEntity.etf$getWorld().method_8316(pos).method_15769() && pos.method_10264() < worldTop) {
            pos = pos.method_10084();
        }
        return pos.method_10264() - emfEntity.etf$getBlockPos().method_10264();
    }

    public static float getFluidDepth() {
        if (emfEntity == null || emfEntity.etf$getWorld().method_8316(emfEntity.etf$getBlockPos()).method_15769()) {
            return 0.0f;
        }
        return EMFAnimationEntityContext.getFluidDepthDown() + EMFAnimationEntityContext.getFluidDepthUp() - 1.0f;
    }

    public static boolean isInWater() {
        return emfEntity != null && emfEntity.emf$isTouchingWater();
    }

    public static boolean isBurning() {
        return emfEntity != null && emfEntity.emf$isOnFire();
    }

    public static boolean isRiding() {
        return emfEntity != null && emfEntity.emf$hasVehicle();
    }

    public static boolean isChild() {
        class_1309 alive;
        EMFEntity eMFEntity = emfEntity;
        return eMFEntity instanceof class_1309 && (alive = (class_1309)eMFEntity).method_6109();
    }

    public static boolean isOnGround() {
        return emfEntity != null && emfEntity.emf$isOnGround();
    }

    public static boolean isClimbing() {
        class_1309 alive;
        EMFEntity eMFEntity = emfEntity;
        return eMFEntity instanceof class_1309 && (alive = (class_1309)eMFEntity).method_6101();
    }

    public static boolean isAlive() {
        if (emfEntity == null) {
            return false;
        }
        return emfEntity.emf$isAlive();
    }

    public static boolean isUsingHand(boolean right) {
        if (emfEntity == null) {
            return false;
        }
        EMFEntity eMFEntity = emfEntity;
        if (eMFEntity instanceof class_1309) {
            boolean usingMainHand;
            class_1309 entity = (class_1309)eMFEntity;
            if (!entity.method_6115()) {
                return false;
            }
            boolean isRightHanded = entity.method_6068() == class_1306.field_6183;
            boolean bl = usingMainHand = entity.method_6058() == class_1268.field_5808;
            if (right) {
                return isRightHanded == usingMainHand;
            }
            return isRightHanded != usingMainHand;
        }
        return false;
    }

    public static boolean isAggressive() {
        class_1308 mob;
        EMFEntity eMFEntity = emfEntity;
        return eMFEntity instanceof class_1308 && (mob = (class_1308)eMFEntity).method_6510();
    }

    public static boolean isGlowing() {
        return emfEntity != null && emfEntity.emf$isGlowing();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isHurt() {
        EMFEntity eMFEntity = emfEntity;
        if (!(eMFEntity instanceof class_1309)) return false;
        class_1309 alive = (class_1309)eMFEntity;
        if (alive.field_6235 <= 0) return false;
        return true;
    }

    public static boolean isInHand() {
        return setInHand;
    }

    public static boolean isInItemFrame() {
        return setInItemFrame;
    }

    public static boolean isInGround() {
        class_1676 proj;
        EMFEntity eMFEntity;
        return is_in_ground_override || (eMFEntity = emfEntity) instanceof class_1676 && (proj = (class_1676)eMFEntity).method_5757();
    }

    public static boolean isInGui() {
        return class_310.method_1551().field_1755 != null && !((EntityRenderDispatcherAccessor)class_310.method_1551().method_1561()).isRenderShadows();
    }

    public static boolean isInLava() {
        return emfEntity != null && emfEntity.emf$isInLava();
    }

    public static boolean isInvisible() {
        return emfEntity != null && emfEntity.emf$isInvisible();
    }

    public static boolean isOnHead() {
        return setIsOnHead;
    }

    public static boolean isOnShoulder() {
        return onShoulder;
    }

    public static void setCurrentEntityOnShoulder() {
        onShoulder = true;
    }

    public static boolean isRidden() {
        return emfEntity != null && emfEntity.emf$hasPassengers();
    }

    public static boolean isSitting() {
        class_7689 camel;
        class_1493 wolf;
        class_1451 cat;
        class_1453 parrot;
        class_4019 fox;
        class_1321 tame;
        if (emfEntity == null) {
            return false;
        }
        EMFEntity eMFEntity = emfEntity;
        return eMFEntity instanceof class_1321 && (tame = (class_1321)eMFEntity).method_6172() || (eMFEntity = emfEntity) instanceof class_4019 && (fox = (class_4019)eMFEntity).method_18272() || (eMFEntity = emfEntity) instanceof class_1453 && (parrot = (class_1453)eMFEntity).method_6172() || (eMFEntity = emfEntity) instanceof class_1451 && (cat = (class_1451)eMFEntity).method_6172() || (eMFEntity = emfEntity) instanceof class_1493 && (wolf = (class_1493)eMFEntity).method_6172() || (eMFEntity = emfEntity) instanceof class_7689 && (camel = (class_7689)eMFEntity).method_45350();
    }

    public static boolean isSneaking() {
        return emfEntity != null && emfEntity.emf$isSneaking();
    }

    public static boolean isSprinting() {
        return emfEntity != null && emfEntity.emf$isSprinting();
    }

    public static boolean isTamed() {
        class_1321 tame;
        EMFEntity eMFEntity = emfEntity;
        return eMFEntity instanceof class_1321 && (tame = (class_1321)eMFEntity).method_6181();
    }

    public static boolean isWet() {
        return emfEntity != null && emfEntity.emf$isWet();
    }

    public static float getSwingProgress() {
        float f;
        EMFEntity eMFEntity = emfEntity;
        if (eMFEntity instanceof class_1309) {
            class_1309 alive = (class_1309)eMFEntity;
            f = alive.method_6055(tickDelta);
        } else {
            f = 0.0f;
        }
        return f;
    }

    public static float getAge() {
        if (emfEntity == null) {
            return 0.0f + tickDelta;
        }
        return EMFAnimationEntityContext.constrainedFloat(emfEntity.emf$age(), 24000) + tickDelta;
    }

    private static float constrainedFloat(float value, int constraint) {
        return value >= (float)constraint ? value % (float)constraint : value;
    }

    private static float constrainedFloat(float value) {
        return EMFAnimationEntityContext.constrainedFloat(value, 24000);
    }

    private static float constrainedFloat(long value, int constraint) {
        return value >= (long)constraint ? value % (long)constraint : value;
    }

    private static float constrainedFloat(long value) {
        return EMFAnimationEntityContext.constrainedFloat(value, 24000);
    }

    private static float constrainedFloat(int value, int constraint) {
        return value >= constraint ? value % constraint : value;
    }

    private static float constrainedFloat(int value) {
        return EMFAnimationEntityContext.constrainedFloat(value, 24000);
    }

    public static float getFrameTime() {
        return class_310.method_1551().method_1534() / 20.0f;
    }

    public static float getLimbAngle() {
        if (emfEntity == null) {
            return 0.0f;
        }
        if (Float.isNaN(limbAngle)) {
            EMFAnimationEntityContext.doLimbValues();
        }
        return limbAngle;
    }

    public static void setLimbAngle(float limbAngle) {
        EMFAnimationEntityContext.limbAngle = limbAngle;
    }

    public static float getLimbDistance() {
        if (emfEntity == null) {
            return 0.0f;
        }
        if (Float.isNaN(limbDistance)) {
            EMFAnimationEntityContext.doLimbValues();
        }
        return limbDistance == Float.MIN_VALUE ? 0.0f : limbDistance;
    }

    public static void setLimbDistance(float limbDistance) {
        EMFAnimationEntityContext.limbDistance = limbDistance;
    }

    private static void doLimbValues() {
        EMFEntity eMFEntity;
        float o = 0.0f;
        float n = 0.0f;
        if (!emfEntity.emf$hasVehicle() && (eMFEntity = emfEntity) instanceof class_1309) {
            class_1309 alive = (class_1309)eMFEntity;
            o = alive.field_42108.method_48572(tickDelta);
            n = alive.field_42108.method_48570(tickDelta);
            if (alive.method_6109()) {
                o *= 3.0f;
            }
            if (n > 1.0f) {
                n = 1.0f;
            }
        } else if (emfEntity instanceof class_1695) {
            n = 1.0f;
            o = -(EMFAnimationEntityContext.getEntityX() + EMFAnimationEntityContext.getEntityZ());
        } else {
            eMFEntity = emfEntity;
            if (eMFEntity instanceof class_1690) {
                class_1690 boat = (class_1690)eMFEntity;
                n = 1.0f;
                o = Math.max(boat.method_7551(1, tickDelta), boat.method_7551(0, tickDelta));
            }
        }
        limbDistance = n;
        limbAngle = o;
    }

    public static float getHeadYaw() {
        if (emfEntity == null) {
            return 0.0f;
        }
        if (Float.isNaN(headYaw)) {
            EMFAnimationEntityContext.doHeadValues();
        }
        return headYaw;
    }

    public static void setHeadYaw(float headYaw) {
        EMFAnimationEntityContext.headYaw = headYaw;
    }

    public static float getHeadPitch() {
        if (emfEntity == null) {
            return 0.0f;
        }
        if (Float.isNaN(headPitch)) {
            EMFAnimationEntityContext.doHeadValues();
        }
        return headPitch;
    }

    public static void setHeadPitch(float headPitch) {
        EMFAnimationEntityContext.headPitch = headPitch;
    }

    private static void doHeadValues() {
        EMFEntity eMFEntity = emfEntity;
        if (eMFEntity instanceof class_1309) {
            class_1297 class_12972;
            class_1309 livingEntity = (class_1309)eMFEntity;
            float h = class_3532.method_17821((float)tickDelta, (float)livingEntity.field_6220, (float)livingEntity.field_6283);
            float j = class_3532.method_17821((float)tickDelta, (float)livingEntity.field_6259, (float)livingEntity.field_6241);
            float k = j - h;
            if (livingEntity.method_5765() && (class_12972 = livingEntity.method_5854()) instanceof class_1309) {
                class_1309 livingEntity2 = (class_1309)class_12972;
                h = class_3532.method_17821((float)tickDelta, (float)livingEntity2.field_6220, (float)livingEntity2.field_6283);
                k = j - h;
                float l = class_3532.method_15393((float)k);
                if (l < -85.0f) {
                    l = -85.0f;
                }
                if (l >= 85.0f) {
                    l = 85.0f;
                }
                h = j - l;
                if (l * l > 2500.0f) {
                    h += l * 0.2f;
                }
                k = j - h;
            }
            float m = class_3532.method_16439((float)tickDelta, (float)livingEntity.field_6004, (float)livingEntity.method_36455());
            if (class_922.method_38563((class_1309)livingEntity)) {
                m *= -1.0f;
                k *= -1.0f;
            }
            headPitch = m;
            headYaw = k >= 180.0f || k < -180.0f ? class_3532.method_15393((float)k) : k;
        } else {
            headPitch = 0.0f;
            headYaw = 0.0f;
        }
    }

    public static float getTickDelta() {
        return tickDelta;
    }

    public static float getMoveForward() {
        if (emfEntity == null) {
            return 0.0f;
        }
        double lookDir = Math.toRadians(90.0f - emfEntity.emf$getYaw());
        class_243 velocity = emfEntity.emf$getVelocity();
        double x = velocity.field_1352;
        double y = velocity.field_1350;
        double newX = x * Math.cos(lookDir) - y * Math.sin(lookDir);
        return EMFAnimationEntityContext.processMove(newX, x, y);
    }

    public static float getMoveStrafe() {
        if (emfEntity == null) {
            return 0.0f;
        }
        double lookDir = Math.toRadians(90.0f - emfEntity.emf$getYaw());
        class_243 velocity = emfEntity.emf$getVelocity();
        double x = velocity.field_1352;
        double y = velocity.field_1350;
        double newY = x * Math.sin(lookDir) + y * Math.cos(lookDir);
        return EMFAnimationEntityContext.processMove(newY, x, y);
    }

    private static float processMove(double value, double x, double y) {
        double totalMovementVector = Math.sqrt(x * x + y * y);
        if (totalMovementVector == 0.0) {
            return 0.0f;
        }
        return (float)(-(value / totalMovementVector));
    }

    public static float getShadowSize() {
        return shadowSize;
    }

    public static void setShadowSize(float shadowSize) {
        EMFAnimationEntityContext.shadowSize = shadowSize;
    }

    public static float getShadowOpacity() {
        return shadowOpacity;
    }

    public static void setShadowOpacity(float shadowOpacity) {
        EMFAnimationEntityContext.shadowOpacity = shadowOpacity;
    }

    public static float getLeashX() {
        return leashX;
    }

    public static void setLeashX(float leashX) {
        EMFAnimationEntityContext.leashX = leashX;
    }

    public static float getLeashY() {
        return leashY;
    }

    public static void setLeashY(float leashY) {
        EMFAnimationEntityContext.leashY = leashY;
    }

    public static float getLeashZ() {
        return leashZ;
    }

    public static void setLeashZ(float leashZ) {
        EMFAnimationEntityContext.leashZ = leashZ;
    }

    public static float getShadowX() {
        return shadowX;
    }

    public static void setShadowX(float shadowX) {
        EMFAnimationEntityContext.shadowX = shadowX;
    }

    public static float getShadowZ() {
        return shadowZ;
    }

    public static void setShadowZ(float shadowZ) {
        EMFAnimationEntityContext.shadowZ = shadowZ;
    }
}

