/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math.methods;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_3532;
import org.apache.commons.lang3.function.TriFunction;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.math.EMFMathException;
import traben.entity_model_features.models.animation.math.MathMethod;
import traben.entity_model_features.models.animation.math.methods.emf.CatchMethod;
import traben.entity_model_features.models.animation.math.methods.emf.IfBMethod;
import traben.entity_model_features.models.animation.math.methods.emf.KeyframeMethod;
import traben.entity_model_features.models.animation.math.methods.emf.KeyframeloopMethod;
import traben.entity_model_features.models.animation.math.methods.emf.RandomBMethod;
import traben.entity_model_features.models.animation.math.methods.optifine.IfMethod;
import traben.entity_model_features.models.animation.math.methods.optifine.InMethod;
import traben.entity_model_features.models.animation.math.methods.optifine.MaxMethod;
import traben.entity_model_features.models.animation.math.methods.optifine.MinMethod;
import traben.entity_model_features.models.animation.math.methods.optifine.PrintBMethod;
import traben.entity_model_features.models.animation.math.methods.optifine.PrintMethod;
import traben.entity_model_features.models.animation.math.methods.optifine.RandomMethod;
import traben.entity_model_features.models.animation.math.methods.simple.BiFunctionMethods;
import traben.entity_model_features.models.animation.math.methods.simple.FunctionMethods;
import traben.entity_model_features.models.animation.math.methods.simple.MultiFunctionMethods;
import traben.entity_model_features.models.animation.math.methods.simple.TriFunctionMethods;
import traben.entity_model_features.utils.EMFManager;

public final class MethodRegistry {
    private static final MethodRegistry INSTANCE = new MethodRegistry();
    private final Map<String, MethodFactory> methodFactories = new HashMap<String, MethodFactory>();
    private final Map<String, String> methodExplanationTranslationKeys = new HashMap<String, String>();

    private MethodRegistry() {
        this.registerAndWrapMethodFactory("max", MaxMethod::new);
        this.registerAndWrapMethodFactory("min", MinMethod::new);
        this.registerAndWrapMethodFactory("random", RandomMethod::new);
        this.registerSimpleMethodFactory("sin", (Float v) -> Float.valueOf((float)Math.sin(v.floatValue())));
        this.registerSimpleMethodFactory("asin", (Float v) -> Float.valueOf((float)Math.asin(v.floatValue())));
        this.registerSimpleMethodFactory("cos", (Float v) -> Float.valueOf((float)Math.cos(v.floatValue())));
        this.registerSimpleMethodFactory("acos", (Float v) -> Float.valueOf((float)Math.acos(v.floatValue())));
        this.registerSimpleMethodFactory("tan", (Float v) -> Float.valueOf((float)Math.tan(v.floatValue())));
        this.registerSimpleMethodFactory("atan", (Float v) -> Float.valueOf((float)Math.atan(v.floatValue())));
        this.registerSimpleMethodFactory("abs", Math::abs);
        this.registerSimpleMethodFactory("floor", (Float v) -> Float.valueOf((float)Math.floor(v.floatValue())));
        this.registerSimpleMethodFactory("ceil", (Float v) -> Float.valueOf((float)Math.ceil(v.floatValue())));
        this.registerSimpleMethodFactory("round", (Float v) -> Float.valueOf(Math.round(v.floatValue())));
        this.registerSimpleMethodFactory("log", (Float v) -> Float.valueOf(v.floatValue() < 0.0f && EMFManager.getInstance().isAnimationValidationPhase ? 0.0f : (float)Math.log(v.floatValue())));
        this.registerSimpleMethodFactory("exp", (Float v) -> Float.valueOf((float)Math.exp(v.floatValue())));
        this.registerSimpleMethodFactory("torad", (Float v) -> Float.valueOf((float)Math.toRadians(v.floatValue())));
        this.registerSimpleMethodFactory("todeg", (Float v) -> Float.valueOf((float)Math.toDegrees(v.floatValue())));
        this.registerSimpleMethodFactory("frac", class_3532::method_22450);
        this.registerSimpleMethodFactory("signum", Math::signum);
        this.registerSimpleMethodFactory("sqrt", (Float v) -> Float.valueOf(v.floatValue() < 0.0f && EMFManager.getInstance().isAnimationValidationPhase ? 0.0f : (float)Math.sqrt(v.floatValue())));
        this.registerSimpleMethodFactory("fmod", (Float v, Float w) -> Float.valueOf(Math.floorMod((int)v.floatValue(), (int)w.floatValue())));
        this.registerSimpleMethodFactory("pow", (Float v, Float w) -> Float.valueOf((float)Math.pow(v.floatValue(), w.floatValue())));
        this.registerSimpleMethodFactory("atan2", (Float v, Float w) -> Float.valueOf((float)Math.atan2(v.floatValue(), w.floatValue())));
        this.registerSimpleMethodFactory("clamp", (TriFunction<Float, Float, Float, Float>)((TriFunction)class_3532::method_15363));
        this.registerSimpleMethodFactory("lerp", (TriFunction<Float, Float, Float, Float>)((TriFunction)class_3532::method_16439));
        this.registerAndWrapMethodFactory("print", PrintMethod::new);
        this.registerAndWrapMethodFactory("printb", PrintBMethod::new);
        this.registerAndWrapMethodFactory("catch", CatchMethod::new);
        this.registerAndWrapMethodFactory("if", IfMethod::new);
        this.registerAndWrapMethodFactory("ifb", IfBMethod::new);
        this.registerAndWrapMethodFactory("randomb", RandomBMethod::new);
        this.registerAndWrapMethodFactory("in", InMethod::new);
        this.registerSimpleMethodFactory("between", (TriFunction<Float, Float, Float, Float>)((TriFunction)(a, b, c) -> Float.valueOf(a.floatValue() > c.floatValue() ? Float.NEGATIVE_INFINITY : (a.floatValue() < b.floatValue() ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY))));
        this.registerSimpleMethodFactory("equals", (TriFunction<Float, Float, Float, Float>)((TriFunction)(x, y, epsilon) -> Float.valueOf(Math.abs(y.floatValue() - x.floatValue()) <= epsilon.floatValue() ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY)));
        this.registerAndWrapMethodFactory("keyframe", KeyframeMethod::new);
        this.registerAndWrapMethodFactory("keyframeloop", KeyframeloopMethod::new);
        this.registerSimpleMethodFactory("wrapdeg", class_3532::method_15393);
        this.registerSimpleMethodFactory("wraprad", (Float v) -> Float.valueOf((float)Math.toRadians(class_3532.method_15338((double)Math.toDegrees(v.floatValue())))));
        this.registerSimpleMethodFactory("degdiff", class_3532::method_15356);
        this.registerSimpleMethodFactory("raddiff", (Float v, Float w) -> Float.valueOf((float)Math.toRadians(class_3532.method_15356((float)((float)Math.toDegrees(v.floatValue())), (float)((float)Math.toDegrees(w.floatValue()))))));
        this.registerSimpleMethodFactory("easeinout", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeInOutSine));
        this.registerSimpleMethodFactory("easein", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeInSine));
        this.registerSimpleMethodFactory("easeout", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeOutSine));
        this.registerSimpleMethodFactory("cubiceaseinout", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeInOutCubic));
        this.registerSimpleMethodFactory("cubiceasein", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeInCubic));
        this.registerSimpleMethodFactory("cubiceaseout", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeOutCubic));
        this.registerSimpleMultiMethodFactory("catmullrom", args -> Float.valueOf(class_3532.method_41303((float)((Float)args.get(0)).floatValue(), (float)((Float)args.get(1)).floatValue(), (float)((Float)args.get(2)).floatValue(), (float)((Float)args.get(3)).floatValue(), (float)((Float)args.get(4)).floatValue())));
        this.registerSimpleMultiMethodFactory("quadbezier", args -> Float.valueOf(MultiFunctionMethods.quadraticBezier(((Float)args.get(0)).floatValue(), ((Float)args.get(1)).floatValue(), ((Float)args.get(2)).floatValue(), ((Float)args.get(3)).floatValue())));
        this.registerSimpleMultiMethodFactory("cubicbezier", args -> Float.valueOf(MultiFunctionMethods.cubicBezier(((Float)args.get(0)).floatValue(), ((Float)args.get(1)).floatValue(), ((Float)args.get(2)).floatValue(), ((Float)args.get(3)).floatValue(), ((Float)args.get(4)).floatValue())));
        this.registerSimpleMultiMethodFactory("hermite", args -> Float.valueOf(MultiFunctionMethods.hermiteInterpolation(((Float)args.get(0)).floatValue(), ((Float)args.get(1)).floatValue(), ((Float)args.get(2)).floatValue(), ((Float)args.get(3)).floatValue(), ((Float)args.get(4)).floatValue())));
        this.registerSimpleMethodFactory("easeinoutexpo", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeInOutExpo));
        this.registerSimpleMethodFactory("easeinexpo", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeInExpo));
        this.registerSimpleMethodFactory("easeoutexpo", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeOutExpo));
        this.registerSimpleMethodFactory("easeinoutcirc", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeInOutCirc));
        this.registerSimpleMethodFactory("easeincirc", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeInCirc));
        this.registerSimpleMethodFactory("easeoutcirc", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeOutCirc));
        this.registerSimpleMethodFactory("easeinoutelastic", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeInOutElastic));
        this.registerSimpleMethodFactory("easeinelastic", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeInElastic));
        this.registerSimpleMethodFactory("easeoutelastic", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeOutElastic));
        this.registerSimpleMethodFactory("easeinoutback", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeInOutBack));
        this.registerSimpleMethodFactory("easeinback", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeInBack));
        this.registerSimpleMethodFactory("easeoutback", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeOutBack));
        this.registerSimpleMethodFactory("easeinoutbounce", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeInOutBounce));
        this.registerSimpleMethodFactory("easeinbounce", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeInBounce));
        this.registerSimpleMethodFactory("easeoutbounce", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeOutBounce));
        this.registerSimpleMethodFactory("easeinquad", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeInQuad));
        this.registerSimpleMethodFactory("easeoutquad", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeOutQuad));
        this.registerSimpleMethodFactory("easeinoutquad", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeInOutQuad));
        this.registerSimpleMethodFactory("easeincubic", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeInCubic));
        this.registerSimpleMethodFactory("easeoutcubic", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeOutCubic));
        this.registerSimpleMethodFactory("easeinoutcubic", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeInOutCubic));
        this.registerSimpleMethodFactory("easeinquart", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeInQuart));
        this.registerSimpleMethodFactory("easeoutquart", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeOutQuart));
        this.registerSimpleMethodFactory("easeinoutquart", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeInOutQuart));
        this.registerSimpleMethodFactory("easeinquint", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeInQuint));
        this.registerSimpleMethodFactory("easeoutquint", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeOutQuint));
        this.registerSimpleMethodFactory("easeinoutquint", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeInOutQuint));
        this.registerSimpleMethodFactory("easeinsine", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeInSine));
        this.registerSimpleMethodFactory("easeoutsine", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeOutSine));
        this.registerSimpleMethodFactory("easeinoutsine", (TriFunction<Float, Float, Float, Float>)((TriFunction)TriFunctionMethods::easeInOutSine));
    }

    private static String emfTranslationKey(String key) {
        return "entity_model_features.config.function_explanation." + key;
    }

    public static MethodRegistry getInstance() {
        return INSTANCE;
    }

    public Map<String, String> getMethodExplanationTranslationKeys() {
        return this.methodExplanationTranslationKeys;
    }

    private void registerSimpleMethodFactory(String methodName, Function<Float, Float> function) {
        this.registerSimpleMethodFactory(methodName, MethodRegistry.emfTranslationKey(methodName), function);
    }

    public void registerSimpleMethodFactory(String methodName, String explanationTranslationKey, Function<Float, Float> function) {
        this.register(methodName, explanationTranslationKey, FunctionMethods.makeFactory(methodName, function));
    }

    private void registerSimpleMethodFactory(String methodName, BiFunction<Float, Float, Float> function) {
        this.registerSimpleMethodFactory(methodName, MethodRegistry.emfTranslationKey(methodName), function);
    }

    public void registerSimpleMethodFactory(String methodName, String explanationTranslationKey, BiFunction<Float, Float, Float> function) {
        this.register(methodName, explanationTranslationKey, BiFunctionMethods.makeFactory(methodName, function));
    }

    private void registerSimpleMethodFactory(String methodName, TriFunction<Float, Float, Float, Float> function) {
        this.registerSimpleMethodFactory(methodName, MethodRegistry.emfTranslationKey(methodName), function);
    }

    public void registerSimpleMethodFactory(String methodName, String explanationTranslationKey, TriFunction<Float, Float, Float, Float> function) {
        this.register(methodName, explanationTranslationKey, TriFunctionMethods.makeFactory(methodName, function));
    }

    private void registerSimpleMultiMethodFactory(String methodName, Function<List<Float>, Float> function) {
        this.registerSimpleMultiMethodFactory(methodName, MethodRegistry.emfTranslationKey(methodName), function);
    }

    public void registerSimpleMultiMethodFactory(String methodName, String explanationTranslationKey, Function<List<Float>, Float> function) {
        this.register(methodName, explanationTranslationKey, MultiFunctionMethods.makeFactory(methodName, function));
    }

    private void register(String methodName, String explanationTranslationKey, MethodFactory factory) {
        this.methodExplanationTranslationKeys.put(methodName, explanationTranslationKey);
        this.methodFactories.put(methodName, factory);
    }

    private void registerAndWrapMethodFactory(String methodName, MethodFactory factory) {
        this.registerAndWrapMethodFactory(methodName, MethodRegistry.emfTranslationKey(methodName), factory);
    }

    public void registerAndWrapMethodFactory(String methodName, String explanationTranslationKey, MethodFactory factory) {
        this.register(methodName, explanationTranslationKey, (a, b, c) -> {
            try {
                return factory.getMethod(a, b, c);
            }
            catch (Exception e) {
                throw new EMFMathException("Failed to create " + methodName + "() method, because:" + e);
            }
        });
    }

    public boolean containsMethod(String methodName) {
        return this.methodFactories.containsKey(methodName);
    }

    public MethodFactory getMethodFactory(String methodName) {
        return this.methodFactories.get(methodName);
    }

    public static interface MethodFactory {
        public MathMethod getMethod(List<String> var1, boolean var2, EMFAnimation var3) throws EMFMathException;
    }
}

