/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.AbstractTextFieldListListEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class DoubleListListEntry
extends AbstractTextFieldListListEntry<Double, DoubleListCell, DoubleListListEntry> {
    private double minimum = Double.NEGATIVE_INFINITY;
    private double maximum = Double.POSITIVE_INFINITY;

    @Deprecated
    @ApiStatus.Internal
    public DoubleListListEntry(class_2561 fieldName, List<Double> value, boolean defaultExpanded, Supplier<Optional<class_2561[]>> tooltipSupplier, Consumer<List<Double>> saveConsumer, Supplier<List<Double>> defaultValue, class_2561 resetButtonKey) {
        this(fieldName, value, defaultExpanded, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, false);
    }

    @Deprecated
    @ApiStatus.Internal
    public DoubleListListEntry(class_2561 fieldName, List<Double> value, boolean defaultExpanded, Supplier<Optional<class_2561[]>> tooltipSupplier, Consumer<List<Double>> saveConsumer, Supplier<List<Double>> defaultValue, class_2561 resetButtonKey, boolean requiresRestart) {
        this(fieldName, value, defaultExpanded, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, requiresRestart, true, true);
    }

    @Deprecated
    @ApiStatus.Internal
    public DoubleListListEntry(class_2561 fieldName, List<Double> value, boolean defaultExpanded, Supplier<Optional<class_2561[]>> tooltipSupplier, Consumer<List<Double>> saveConsumer, Supplier<List<Double>> defaultValue, class_2561 resetButtonKey, boolean requiresRestart, boolean deleteButtonEnabled, boolean insertInFront) {
        super(fieldName, value, defaultExpanded, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, requiresRestart, deleteButtonEnabled, insertInFront, DoubleListCell::new);
    }

    public DoubleListListEntry setMaximum(Double maximum) {
        this.maximum = maximum;
        return this;
    }

    public DoubleListListEntry setMinimum(Double minimum) {
        this.minimum = minimum;
        return this;
    }

    @Override
    public DoubleListListEntry self() {
        return this;
    }

    public static class DoubleListCell
    extends AbstractTextFieldListListEntry.AbstractTextFieldListCell<Double, DoubleListCell, DoubleListListEntry> {
        public DoubleListCell(Double value, DoubleListListEntry listListEntry) {
            super(value, listListEntry);
        }

        @Override
        @Nullable
        protected Double substituteDefault(@Nullable Double value) {
            if (value == null) {
                return 0.0;
            }
            return value;
        }

        @Override
        protected boolean isValidText(@NotNull String text) {
            return text.chars().allMatch(c -> Character.isDigit(c) || c == 45 || c == 46);
        }

        @Override
        public Double getValue() {
            try {
                return Double.valueOf(this.widget.method_1882());
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }

        @Override
        public Optional<class_2561> getError() {
            try {
                double i = Double.parseDouble(this.widget.method_1882());
                if (i > ((DoubleListListEntry)this.listListEntry).maximum) {
                    return Optional.of(class_2561.method_43469((String)"text.cloth-config.error.too_large", (Object[])new Object[]{((DoubleListListEntry)this.listListEntry).maximum}));
                }
                if (i < ((DoubleListListEntry)this.listListEntry).minimum) {
                    return Optional.of(class_2561.method_43469((String)"text.cloth-config.error.too_small", (Object[])new Object[]{((DoubleListListEntry)this.listListEntry).minimum}));
                }
            }
            catch (NumberFormatException ex) {
                return Optional.of(class_2561.method_43471((String)"text.cloth-config.error.not_valid_number_double"));
            }
            return Optional.empty();
        }
    }
}

