/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.debug;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.platform.Services;
import net.minecraft.class_1735;
import net.minecraft.class_465;
import net.minecraft.class_768;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DebugGhostIngredientHandler<T extends class_465<?>>
implements IGhostIngredientHandler<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IIngredientManager ingredientManager;

    public DebugGhostIngredientHandler(IIngredientManager ingredientManager) {
        this.ingredientManager = ingredientManager;
    }

    @Override
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(T gui, ITypedIngredient<I> typedIngredient, boolean doStart) {
        ArrayList targets = new ArrayList();
        targets.add(new DebugInfoTarget("Got an Ingredient", new class_768(0, 0, 20, 20), this.ingredientManager));
        if (doStart) {
            IIngredientType<I> ingredientType = typedIngredient.getType();
            IIngredientHelper<I> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredientType);
            LOGGER.info("Ghost Ingredient Handling Starting with {}", (Object)ingredientHelper.getErrorInfo(typedIngredient.getIngredient()));
            targets.add(new DebugInfoTarget("Got an Ingredient", new class_768(20, 20, 20, 20), this.ingredientManager));
        }
        typedIngredient.getIngredient(VanillaTypes.ITEM_STACK).ifPresent(itemStack -> {
            boolean even = true;
            IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
            for (class_1735 slot : gui.method_17577().field_7761) {
                if (even) {
                    int guiLeft = screenHelper.getGuiLeft((class_465<?>)gui);
                    int guiTop = screenHelper.getGuiTop((class_465<?>)gui);
                    class_768 area = new class_768(guiLeft + slot.field_7873, guiTop + slot.field_7872, 16, 16);
                    targets.add(new DebugInfoTarget("Got an Ingredient in Gui", area, this.ingredientManager));
                }
                even = !even;
            }
        });
        return targets;
    }

    @Override
    public void onComplete() {
        LOGGER.info("Ghost Ingredient Handling Complete");
    }

    private static class DebugInfoTarget<I>
    implements IGhostIngredientHandler.Target<I> {
        private final String message;
        private final class_768 rectangle;
        private final IIngredientManager ingredientManager;

        public DebugInfoTarget(String message, class_768 rectangle, IIngredientManager ingredientManager) {
            this.message = message;
            this.rectangle = rectangle;
            this.ingredientManager = ingredientManager;
        }

        @Override
        public class_768 getArea() {
            return this.rectangle;
        }

        @Override
        public void accept(I ingredient) {
            IIngredientType<I> ingredientType = this.ingredientManager.getIngredientTypeChecked(ingredient).orElseThrow();
            IIngredientHelper<I> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredientType);
            LOGGER.info("{}: {}", (Object)this.message, (Object)ingredientHelper.getErrorInfo(ingredient));
        }
    }
}

