/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.entity.ai.brain.task.glare;

import com.faboslav.friendsandfoes.entity.GlareEntity;
import com.faboslav.friendsandfoes.entity.ai.brain.GlareBrain;
import com.faboslav.friendsandfoes.entity.ai.brain.task.glare.GlareLocateDarkSpotTask;
import com.faboslav.friendsandfoes.init.FriendsAndFoesMemoryModuleTypes;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4208;
import net.minecraft.class_4215;
import net.minecraft.class_4802;

public final class GlareTravelToDarkSpotTask
extends class_4097<GlareEntity> {
    private static final int MAX_TRAVELLING_TICKS = 300;
    private static final float WITHING_DISTANCE = 1.5f;

    public GlareTravelToDarkSpotTask() {
        super(Map.of(FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_POS.get(), class_4141.field_18456), 300);
    }

    protected boolean shouldRun(class_3218 world, GlareEntity glare) {
        class_4208 darkSpotPos = glare.getDarkSpotPos();
        return GlareTravelToDarkSpotTask.canTravelToDarkSpot(glare) && !darkSpotPos.method_19446().method_19769((class_2374)glare.method_19538(), 1.5);
    }

    protected void run(class_3218 world, GlareEntity glare, long time) {
        this.flyTowardsDarkSpot(glare);
    }

    protected boolean shouldKeepRunning(class_3218 world, GlareEntity glare, long time) {
        class_4208 darkSpotPos = glare.getDarkSpotPos();
        return GlareTravelToDarkSpotTask.canTravelToDarkSpot(glare) && (!darkSpotPos.method_19446().method_19769((class_2374)glare.method_19538(), 1.5) || glare.method_5942().method_23966());
    }

    protected void keepRunning(class_3218 world, GlareEntity glare, long time) {
        if (glare.method_5942().method_23966()) {
            return;
        }
        this.flyTowardsDarkSpot(glare);
    }

    protected void finishRunning(class_3218 world, GlareEntity glare, long time) {
        glare.method_18868().method_18875(class_4140.field_18445);
        class_4208 darkSpotPos = glare.getDarkSpotPos();
        if (!(darkSpotPos == null || darkSpotPos.method_19446().method_19769((class_2374)glare.method_19538(), 1.5) && glare.isDarkSpotDark(darkSpotPos.method_19446()))) {
            glare.method_18868().method_18875(FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_POS.get());
            GlareBrain.setDarkSpotLocatingCooldown(glare, class_4802.method_24505((int)10, (int)20));
        }
    }

    private void flyTowardsDarkSpot(GlareEntity glare) {
        class_4208 darkSpotPos = glare.getDarkSpotPos();
        if (darkSpotPos == null) {
            return;
        }
        class_4215.method_24561((class_1309)glare, (class_2338)new class_2338((class_2382)darkSpotPos.method_19446()), (float)1.0f, (int)0);
    }

    public static boolean canTravelToDarkSpot(GlareEntity glare) {
        if (!GlareLocateDarkSpotTask.canLocateDarkSpot(glare)) {
            return false;
        }
        class_4208 darkSpotPos = glare.getDarkSpotPos();
        return darkSpotPos != null && glare.isDarkSpotDark(darkSpotPos.method_19446());
    }
}

