/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.init;

import com.faboslav.friendsandfoes.client.render.entity.renderer.CopperGolemEntityRenderer;
import com.faboslav.friendsandfoes.client.render.entity.renderer.GlareEntityRenderer;
import com.faboslav.friendsandfoes.client.render.entity.renderer.IceologerEntityRenderer;
import com.faboslav.friendsandfoes.client.render.entity.renderer.IceologerIceChunkRenderer;
import com.faboslav.friendsandfoes.client.render.entity.renderer.MaulerEntityRenderer;
import com.faboslav.friendsandfoes.client.render.entity.renderer.MoobloomEntityRenderer;
import com.faboslav.friendsandfoes.client.render.entity.renderer.PlayerIllusionEntityRenderer;
import com.faboslav.friendsandfoes.client.render.entity.renderer.RascalEntityRenderer;
import com.faboslav.friendsandfoes.client.render.entity.renderer.TuffGolemEntityRenderer;
import com.faboslav.friendsandfoes.client.render.entity.renderer.WildfireEntityRenderer;
import com.faboslav.friendsandfoes.entity.PlayerIllusionEntity;
import com.faboslav.friendsandfoes.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.platform.RegistryHelper;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_5617;
import net.minecraft.class_897;

@Environment(value=EnvType.CLIENT)
public final class FriendAndFoesEntityRenderer {
    private static final Map<String, class_5617<PlayerIllusionEntity>> PLAYER_ILLUSION_RENDERER_FACTORIES = ImmutableMap.of((Object)"default", context -> new PlayerIllusionEntityRenderer(context, false), (Object)"slim", context -> new PlayerIllusionEntityRenderer(context, true));

    public static void postInit() {
        RegistryHelper.registerEntityRenderer(FriendsAndFoesEntityTypes.COPPER_GOLEM, CopperGolemEntityRenderer::new);
        RegistryHelper.registerEntityRenderer(FriendsAndFoesEntityTypes.GLARE, GlareEntityRenderer::new);
        RegistryHelper.registerEntityRenderer(FriendsAndFoesEntityTypes.ICEOLOGER, IceologerEntityRenderer::new);
        RegistryHelper.registerEntityRenderer(FriendsAndFoesEntityTypes.ICE_CHUNK, IceologerIceChunkRenderer::new);
        RegistryHelper.registerEntityRenderer(FriendsAndFoesEntityTypes.MAULER, MaulerEntityRenderer::new);
        RegistryHelper.registerEntityRenderer(FriendsAndFoesEntityTypes.MOOBLOOM, MoobloomEntityRenderer::new);
        RegistryHelper.registerEntityRenderer(FriendsAndFoesEntityTypes.RASCAL, RascalEntityRenderer::new);
        RegistryHelper.registerEntityRenderer(FriendsAndFoesEntityTypes.TUFF_GOLEM, TuffGolemEntityRenderer::new);
        RegistryHelper.registerEntityRenderer(FriendsAndFoesEntityTypes.WILDFIRE, WildfireEntityRenderer::new);
    }

    public static Map<String, class_897<? extends PlayerIllusionEntity>> reloadPlayerIllusionRenderers(class_5617.class_5618 ctx) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        PLAYER_ILLUSION_RENDERER_FACTORIES.forEach((type, factory) -> {
            try {
                builder.put(type, (Object)factory.create(ctx));
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Failed to create player illusion model for " + type, exception);
            }
        });
        return builder.build();
    }

    private FriendAndFoesEntityRenderer() {
    }
}

