/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.platform;

import com.mrcrayfish.configured.Constants;
import com.mrcrayfish.configured.api.IModConfigProvider;
import com.mrcrayfish.configured.platform.services.IConfigHelper;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_5218;

public class FabricConfigHelper
implements IConfigHelper {
    private static final class_2960 BACKGROUND_LOCATION = new class_2960("textures/gui/options_background.png");
    private static final class_5218 SERVER_CONFIG_RESOURCE = new class_5218("serverconfig");

    @Override
    public class_5218 getServerConfigResource() {
        return SERVER_CONFIG_RESOURCE;
    }

    @Override
    public Set<IModConfigProvider> getProviders() {
        HashSet<IModConfigProvider> providers = new HashSet<IModConfigProvider>();
        this.readProviders(obj -> {
            if (obj instanceof IModConfigProvider) {
                IModConfigProvider provider = (IModConfigProvider)obj;
                providers.add(provider);
            }
        });
        return providers;
    }

    private void readProviders(Consumer<Object> function) {
        FabricLoader.getInstance().getAllMods().forEach(container -> {
            CustomValue.CvObject configuredObj;
            CustomValue providersValue;
            CustomValue value = container.getMetadata().getCustomValue("configured");
            if (value != null && value.getType() == CustomValue.CvType.OBJECT && (providersValue = (configuredObj = value.getAsObject()).get("providers")) != null) {
                if (providersValue.getType() == CustomValue.CvType.ARRAY) {
                    CustomValue.CvArray array = providersValue.getAsArray();
                    array.forEach(providerValue -> this.readProvider((CustomValue)providerValue, (ModContainer)container, function));
                } else {
                    this.readProvider(providersValue, (ModContainer)container, function);
                }
            }
        });
    }

    private void readProvider(CustomValue providerValue, ModContainer container, Consumer<Object> function) {
        if (providerValue.getType() != CustomValue.CvType.STRING) {
            throw new RuntimeException("Config provider definition must be a String");
        }
        String providerClass = providerValue.getAsString();
        Object obj = this.createProviderInstance(container, providerClass);
        function.accept(obj);
        Constants.LOG.info("Successfully loaded config provider: {}", (Object)providerClass);
    }

    private Object createProviderInstance(ModContainer container, String classPath) {
        try {
            Class<?> providerClass = Class.forName(classPath);
            Object obj = providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (!(obj instanceof IModConfigProvider)) {
                throw new RuntimeException("Config providers must implement IModConfigProvider");
            }
            return obj;
        }
        catch (Exception e) {
            Constants.LOG.error("Failed to load config provider from mod: {}", (Object)container.getMetadata().getId());
            throw new RuntimeException("Failed to load config provider", e);
        }
    }

    @Override
    public class_2960 getBackgroundTexture(String modId) {
        CustomValue.CvObject configuredObj;
        CustomValue backgroundValue;
        CustomValue value;
        ModContainer container = FabricLoader.getInstance().getModContainer(modId).orElse(null);
        if (container != null && (value = container.getMetadata().getCustomValue("configured")) != null && value.getType() == CustomValue.CvType.OBJECT && (backgroundValue = (configuredObj = value.getAsObject()).get("background")) != null && backgroundValue.getType() == CustomValue.CvType.STRING) {
            try {
                return new class_2960(backgroundValue.getAsString());
            }
            catch (class_151 e) {
                return BACKGROUND_LOCATION;
            }
        }
        return BACKGROUND_LOCATION;
    }
}

