/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitminers.extendedgears.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.toml.TomlParser;
import com.rabbitminers.extendedgears.base.util.Utils;
import com.rabbitminers.extendedgears.config.CommonConfig;
import com.simibubi.create.foundation.config.ConfigBase;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;

public class ExtendedCogwheelsConfig {
    @ApiStatus.Internal
    public static final Map<ModConfig.Type, ConfigBase> CONFIGS = new EnumMap<ModConfig.Type, ConfigBase>(ModConfig.Type.class);
    private static CommonConfig common;
    private static Boolean cachedDisableDatafixer;

    public static CommonConfig common() {
        return common;
    }

    public static ConfigBase byType(ModConfig.Type type) {
        return CONFIGS.get(type);
    }

    private static <T extends ConfigBase> T register(Supplier<T> factory, ModConfig.Type side) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> {
            ConfigBase config = (ConfigBase)factory.get();
            config.registerAll(builder);
            return config;
        });
        ConfigBase config = (ConfigBase)specPair.getLeft();
        config.specification = (ForgeConfigSpec)specPair.getRight();
        CONFIGS.put(side, config);
        return (T)config;
    }

    public static void register() {
        throw new AssertionError();
    }

    @ApiStatus.Internal
    public static void registerCommon() {
        common = ExtendedCogwheelsConfig.register(CommonConfig::new, ModConfig.Type.COMMON);
    }

    public static void onLoad(ModConfig modConfig) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != modConfig.getSpec()) continue;
            config.onLoad();
        }
    }

    public static void onReload(ModConfig modConfig) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != modConfig.getSpec()) continue;
            config.onReload();
        }
    }

    public static boolean getDisableDatafixer() {
        if (common != null) {
            return (Boolean)ExtendedCogwheelsConfig.common.disableDatafixer.get();
        }
        if (cachedDisableDatafixer == null) {
            ExtendedCogwheelsConfig.preloadValues();
        }
        return cachedDisableDatafixer;
    }

    private static void preloadValues() {
        Path configDir = Utils.configDir();
        Path commonConfig = configDir.resolve("extendedgears-common.toml");
        try (FileReader reader = new FileReader(commonConfig.toFile());){
            CommentedConfig config = new TomlParser().parse((Reader)reader);
            cachedDisableDatafixer = (Boolean)config.getRaw("disableDatafixer");
        }
        catch (IOException e) {
            cachedDisableDatafixer = null;
        }
        if (cachedDisableDatafixer == null) {
            cachedDisableDatafixer = false;
        }
    }
}

