/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitminers.extendedgears.mixin;

import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.model.BlockModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.rabbitminers.extendedgears.cogwheels.CogwheelModelKey;
import com.rabbitminers.extendedgears.cogwheels.CogwheelType;
import com.rabbitminers.extendedgears.cogwheels.DynamicCogwheelRenderer;
import com.rabbitminers.extendedgears.cogwheels.HalfShaftCogwheelBlock;
import com.rabbitminers.extendedgears.mixin_interface.CogwheelTypeProvider;
import com.rabbitminers.extendedgears.mixin_interface.IDynamicMaterialBlockEntity;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.base.SingleRotatingInstance;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntityInstance;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.render.CachedBufferer;
import net.minecraft.class_1087;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BracketedKineticBlockEntityInstance.class})
public abstract class MixinBracketedKineticBlockEntityInstance
extends SingleRotatingInstance<BracketedKineticBlockEntity> {
    @Shadow
    protected RotatingData additionalShaft;
    @Nullable
    protected CogwheelModelKey key;
    protected boolean large;

    @Shadow
    protected abstract class_4587 rotateToAxis(class_2350.class_2351 var1);

    public MixinBracketedKineticBlockEntityInstance(MaterialManager materialManager, BracketedKineticBlockEntity blockEntity) {
        super(materialManager, (KineticBlockEntity)blockEntity);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void onInit(MaterialManager materialManager, BracketedKineticBlockEntity blockEntity, CallbackInfo ci) {
        if (blockEntity instanceof IDynamicMaterialBlockEntity) {
            IDynamicMaterialBlockEntity dynamicMaterialBlockEntity = (IDynamicMaterialBlockEntity)blockEntity;
            if (!blockEntity.method_11010().method_27852((class_2248)AllBlocks.SHAFT.get())) {
                this.large = ICogWheel.isLargeCog((class_2680)this.blockState);
                this.key = new CogwheelModelKey(this.large, this.getRenderedBlockState(), dynamicMaterialBlockEntity.getMaterial());
            }
        }
    }

    @Overwrite(remap=false)
    public void init() {
        super.init();
        if (!(this.blockState.method_26204() instanceof CogWheelBlock)) {
            return;
        }
        class_2350.class_2351 axis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)((KineticBlockEntity)this.blockEntity));
        float speed = ((BracketedKineticBlockEntity)this.blockEntity).getSpeed();
        float offset = BracketedKineticBlockEntityRenderer.getShaftAngleOffset((class_2350.class_2351)axis, (class_2338)this.pos);
        boolean isHalfShaft = this.blockState.method_26204() instanceof HalfShaftCogwheelBlock;
        class_2350.class_2352 direction = isHalfShaft ? HalfShaftCogwheelBlock.getAxisDirection(this.blockState) : class_2350.class_2352.field_11056;
        class_2350 facing = class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)direction);
        @Nullable PartialModel shaftModel = this.getShaftModel(this.blockState.method_26204());
        if (shaftModel == null) {
            return;
        }
        Instancer half = this.getRotatingMaterial().getModel(shaftModel, this.blockState, facing, () -> isHalfShaft ? this.rotateToAxis(axis, direction) : this.rotateToAxis(axis));
        this.additionalShaft = this.setup((RotatingData)half.createInstance(), speed);
        this.additionalShaft.setRotationOffset(offset);
    }

    private class_4587 rotateToAxis(class_2350.class_2351 axis, class_2350.class_2352 direction) {
        class_2350 facing = class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)direction);
        class_4587 poseStack = new class_4587();
        ((TransformStack)((TransformStack)TransformStack.cast((class_4587)poseStack).centre()).rotateToFace(facing.method_10153())).unCentre();
        return poseStack;
    }

    @Nullable
    public PartialModel getShaftModel(class_2248 block) {
        if (!(block instanceof CogwheelTypeProvider)) {
            return AllPartialModels.COGWHEEL_SHAFT;
        }
        CogwheelTypeProvider provider = (CogwheelTypeProvider)block;
        return switch (provider.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case CogwheelType.STANDARD -> AllPartialModels.COGWHEEL_SHAFT;
            case CogwheelType.HALF_SHAFT -> AllPartialModels.SHAFT_HALF;
            case CogwheelType.SHAFLTESS -> null;
        };
    }

    public boolean shouldReset() {
        boolean changed = false;
        class_2586 class_25862 = this.blockEntity;
        if (class_25862 instanceof IDynamicMaterialBlockEntity) {
            IDynamicMaterialBlockEntity dynamicMaterialBlockEntity = (IDynamicMaterialBlockEntity)class_25862;
            if (this.key != null) {
                changed = this.key.material() != dynamicMaterialBlockEntity.getMaterial();
            }
        }
        return super.shouldReset() || changed;
    }

    protected Instancer<RotatingData> getModel() {
        if (this.key == null) {
            return super.getModel();
        }
        return this.getRotatingMaterial().model((Object)this.key, () -> {
            class_1087 model = DynamicCogwheelRenderer.generateModel(this.key);
            class_2680 state = this.key.state();
            class_2350.class_2352 axisDirection = state.method_26204() instanceof HalfShaftCogwheelBlock ? HalfShaftCogwheelBlock.getAxisDirection(state) : class_2350.class_2352.field_11056;
            class_2350 dir = class_2350.method_10169((class_2350.class_2351)((class_2350.class_2351)state.method_11654((class_2769)RotatedPillarKineticBlock.AXIS)), (class_2350.class_2352)axisDirection);
            class_4587 transform = (class_4587)CachedBufferer.rotateToFaceVertical((class_2350)dir).get();
            return BlockModel.of((class_1087)model, (class_2680)class_2246.field_10124.method_9564(), (class_4587)transform);
        });
    }
}

