/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.client.AEKeyRendering;
import appeng.api.config.LockCraftingMode;
import appeng.api.stacks.AmountFormat;
import appeng.api.stacks.GenericStack;
import appeng.client.Point;
import appeng.client.gui.ICompositeWidget;
import appeng.client.gui.Icon;
import appeng.client.gui.Tooltip;
import appeng.client.gui.implementations.PatternProviderScreen;
import appeng.core.localization.GuiText;
import appeng.core.localization.InGameTooltip;
import appeng.menu.implementations.PatternProviderMenu;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;

public class PatternProviderLockReason
implements ICompositeWidget {
    protected boolean visible = false;
    protected int x;
    protected int y;
    private final PatternProviderScreen<?> screen;

    public PatternProviderLockReason(PatternProviderScreen<?> screen) {
        this.screen = screen;
    }

    @Override
    public void setPosition(Point position) {
        this.x = position.getX();
        this.y = position.getY();
    }

    @Override
    public void setSize(int width, int height) {
    }

    @Override
    public class_768 getBounds() {
        return new class_768(this.x, this.y, 126, 16);
    }

    @Override
    public final boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public void drawForegroundLayer(class_332 guiGraphics, class_768 bounds, Point mouse) {
        class_5250 lockStatusText;
        Icon icon;
        PatternProviderMenu menu = (PatternProviderMenu)this.screen.method_17577();
        if (menu.getCraftingLockedReason() == LockCraftingMode.NONE) {
            icon = Icon.UNLOCKED;
            lockStatusText = GuiText.CraftingLockIsUnlocked.text().method_27692(class_124.field_1077);
        } else {
            icon = Icon.LOCKED;
            lockStatusText = GuiText.CraftingLockIsLocked.text().method_27692(class_124.field_1079);
        }
        icon.getBlitter().dest(this.x, this.y).blit(guiGraphics);
        guiGraphics.method_51439(class_310.method_1551().field_1772, (class_2561)lockStatusText, this.x + 15, this.y + 5, -1, false);
    }

    @Override
    @Nullable
    public Tooltip getTooltip(int mouseX, int mouseY) {
        PatternProviderMenu menu = (PatternProviderMenu)this.screen.method_17577();
        class_5250 tooltip = switch (menu.getCraftingLockedReason()) {
            default -> throw new IncompatibleClassChangeError();
            case LockCraftingMode.NONE -> null;
            case LockCraftingMode.LOCK_UNTIL_PULSE -> InGameTooltip.CraftingLockedUntilPulse.text();
            case LockCraftingMode.LOCK_WHILE_HIGH -> InGameTooltip.CraftingLockedByRedstoneSignal.text();
            case LockCraftingMode.LOCK_WHILE_LOW -> InGameTooltip.CraftingLockedByLackOfRedstoneSignal.text();
            case LockCraftingMode.LOCK_UNTIL_RESULT -> {
                class_5250 stackAmount;
                class_5250 stackName;
                GenericStack stack = menu.getUnlockStack();
                if (stack != null) {
                    stackName = AEKeyRendering.getDisplayName(stack.what());
                    stackAmount = class_2561.method_43470((String)stack.what().formatAmount(stack.amount(), AmountFormat.FULL));
                } else {
                    stackName = class_2561.method_43470((String)"ERROR");
                    stackAmount = class_2561.method_43470((String)"ERROR");
                }
                yield InGameTooltip.CraftingLockedUntilResult.text(stackName, stackAmount);
            }
        };
        return tooltip != null ? new Tooltip(new class_2561[]{tooltip}) : null;
    }
}

