/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.common;

import appeng.client.gui.AESubScreen;
import appeng.client.gui.me.common.MEStorageScreen;
import appeng.client.gui.widgets.AECheckbox;
import appeng.client.gui.widgets.TabButton;
import appeng.core.localization.GuiText;
import appeng.integration.abstraction.JEIFacade;
import appeng.integration.abstraction.REIFacade;
import appeng.menu.SlotSemantics;
import appeng.menu.me.common.MEStorageMenu;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_5250;
import net.minecraft.class_918;

public class TerminalSettingsScreen<C extends MEStorageMenu>
extends AESubScreen<C, MEStorageScreen<C>> {
    private final AECheckbox pinAutoCraftedItemsCheckbox;
    private final AECheckbox notifyForFinishedCraftingJobsCheckbox;
    private final AECheckbox clearGridOnCloseCheckbox;
    private final AECheckbox useInternalSearchRadio;
    private final AECheckbox useExternalSearchRadio;
    private final AECheckbox rememberCheckbox;
    private final AECheckbox autoFocusCheckbox;
    private final AECheckbox syncWithExternalCheckbox;
    private final AECheckbox clearExternalCheckbox;
    private final AECheckbox searchTooltipsCheckbox;

    public TerminalSettingsScreen(MEStorageScreen<C> parent) {
        super(parent, "/screens/terminals/terminal_settings.json");
        boolean hasExternalSearch;
        class_5250 externalSearchMod;
        this.addBackButton();
        if (JEIFacade.instance().isEnabled()) {
            externalSearchMod = class_2561.method_43470((String)"JEI");
            hasExternalSearch = true;
        } else if (REIFacade.instance().isEnabled()) {
            externalSearchMod = class_2561.method_43470((String)"REI");
            hasExternalSearch = true;
        } else {
            externalSearchMod = class_2561.method_43470((String)"JEI/REI");
            hasExternalSearch = false;
        }
        this.pinAutoCraftedItemsCheckbox = this.widgets.addCheckbox("pinAutoCraftedItemsCheckbox", (class_2561)GuiText.TerminalSettingsPinAutoCraftedItems.text(), this::save);
        this.notifyForFinishedCraftingJobsCheckbox = this.widgets.addCheckbox("notifyForFinishedCraftingJobsCheckbox", (class_2561)GuiText.TerminalSettingsNotifyForFinishedJobs.text(), this::save);
        this.clearGridOnCloseCheckbox = this.widgets.addCheckbox("clearGridOnCloseCheckbox", (class_2561)GuiText.TerminalSettingsClearGridOnClose.text(), this::save);
        this.useInternalSearchRadio = this.widgets.addCheckbox("useInternalSearchRadio", (class_2561)GuiText.SearchSettingsUseInternalSearch.text(), this::switchToAeSearch);
        this.useInternalSearchRadio.setRadio(true);
        this.useExternalSearchRadio = this.widgets.addCheckbox("useExternalSearchRadio", (class_2561)GuiText.SearchSettingsUseExternalSearch.text(externalSearchMod), this::switchToExternalSearch);
        this.useExternalSearchRadio.setRadio(true);
        this.useExternalSearchRadio.field_22763 = hasExternalSearch;
        this.searchTooltipsCheckbox = this.widgets.addCheckbox("searchTooltipsCheckbox", (class_2561)GuiText.SearchSettingsSearchTooltips.text(), this::save);
        this.rememberCheckbox = this.widgets.addCheckbox("rememberCheckbox", (class_2561)GuiText.SearchSettingsRememberSearch.text(), this::save);
        this.autoFocusCheckbox = this.widgets.addCheckbox("autoFocusCheckbox", (class_2561)GuiText.SearchSettingsAutoFocus.text(), this::save);
        this.syncWithExternalCheckbox = this.widgets.addCheckbox("syncWithExternalCheckbox", (class_2561)GuiText.SearchSettingsSyncWithExternal.text(externalSearchMod), this::save);
        this.clearExternalCheckbox = this.widgets.addCheckbox("clearExternalCheckbox", (class_2561)GuiText.SearchSettingsClearExternal.text(externalSearchMod), this::save);
        this.updateState();
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.setSlotsHidden(SlotSemantics.TOOLBOX, true);
    }

    private void switchToAeSearch() {
        this.useInternalSearchRadio.setSelected(true);
        this.useExternalSearchRadio.setSelected(false);
        this.save();
    }

    private void switchToExternalSearch() {
        this.useInternalSearchRadio.setSelected(false);
        this.useExternalSearchRadio.setSelected(true);
        this.save();
    }

    private void addBackButton() {
        class_1799 icon = ((MEStorageMenu)this.field_2797).getHost().getMainMenuIcon();
        class_2561 label = icon.method_7964();
        class_918 itemRenderer = class_310.method_1551().method_1480();
        TabButton button = new TabButton(icon, label, btn -> this.returnToParent());
        this.widgets.add("back", (class_339)button);
    }

    private void updateState() {
        this.pinAutoCraftedItemsCheckbox.setSelected(this.config.isPinAutoCraftedItems());
        this.notifyForFinishedCraftingJobsCheckbox.setSelected(this.config.isNotifyForFinishedCraftingJobs());
        this.clearGridOnCloseCheckbox.setSelected(this.config.isClearGridOnClose());
        this.useInternalSearchRadio.setSelected(!this.config.isUseExternalSearch());
        this.useExternalSearchRadio.setSelected(this.config.isUseExternalSearch());
        this.rememberCheckbox.setSelected(this.config.isRememberLastSearch());
        this.autoFocusCheckbox.setSelected(this.config.isAutoFocusSearch());
        this.syncWithExternalCheckbox.setSelected(this.config.isSyncWithExternalSearch());
        this.clearExternalCheckbox.setSelected(this.config.isClearExternalSearchOnOpen());
        this.searchTooltipsCheckbox.setSelected(this.config.isSearchTooltips());
        this.rememberCheckbox.field_22764 = this.useInternalSearchRadio.isSelected();
        this.autoFocusCheckbox.field_22764 = this.useInternalSearchRadio.isSelected();
        this.syncWithExternalCheckbox.field_22764 = this.useInternalSearchRadio.isSelected();
        this.clearExternalCheckbox.field_22764 = this.useExternalSearchRadio.isSelected();
    }

    private void save() {
        this.config.setUseExternalSearch(this.useExternalSearchRadio.isSelected());
        this.config.setRememberLastSearch(this.rememberCheckbox.isSelected());
        this.config.setAutoFocusSearch(this.autoFocusCheckbox.isSelected());
        this.config.setSyncWithExternalSearch(this.syncWithExternalCheckbox.isSelected());
        this.config.setClearExternalSearchOnOpen(this.clearExternalCheckbox.isSelected());
        this.config.setSearchTooltips(this.searchTooltipsCheckbox.isSelected());
        this.config.setPinAutoCraftedItems(this.pinAutoCraftedItemsCheckbox.isSelected());
        this.config.setNotifyForFinishedCraftingJobs(this.notifyForFinishedCraftingJobsCheckbox.isSelected());
        this.config.setClearGridOnClose(this.clearGridOnCloseCheckbox.isSelected());
        this.updateState();
    }
}

