/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.compiler.tags;

import appeng.client.guidebook.compiler.PageCompiler;
import appeng.client.guidebook.compiler.tags.BlockTagCompiler;
import appeng.client.guidebook.compiler.tags.MdxAttrs;
import appeng.client.guidebook.document.block.LytBlock;
import appeng.client.guidebook.document.block.LytBlockContainer;
import appeng.client.guidebook.document.block.recipes.LytChargerRecipe;
import appeng.client.guidebook.document.block.recipes.LytCraftingRecipe;
import appeng.client.guidebook.document.block.recipes.LytInscriberRecipe;
import appeng.client.guidebook.document.block.recipes.LytSmeltingRecipe;
import appeng.client.guidebook.document.block.recipes.LytSmithingRecipe;
import appeng.client.guidebook.document.block.recipes.LytTransformRecipe;
import appeng.libs.mdast.mdx.model.MdxJsxElementFields;
import appeng.libs.mdast.model.MdAstNode;
import appeng.recipes.handlers.ChargerRecipe;
import appeng.recipes.handlers.InscriberRecipe;
import appeng.recipes.transform.TransformRecipe;
import appeng.util.Platform;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class RecipeCompiler
extends BlockTagCompiler {
    private final List<RecipeTypeMapping<?, ?>> mappings = List.of(new RecipeTypeMapping(class_3956.field_17545, LytCraftingRecipe::new), new RecipeTypeMapping(class_3956.field_17546, LytSmeltingRecipe::new), new RecipeTypeMapping(class_3956.field_25388, LytSmithingRecipe::new), new RecipeTypeMapping(InscriberRecipe.TYPE, LytInscriberRecipe::new), new RecipeTypeMapping(ChargerRecipe.TYPE, LytChargerRecipe::new), new RecipeTypeMapping(TransformRecipe.TYPE, LytTransformRecipe::new));

    @Override
    public Set<String> getTagNames() {
        return Set.of("Recipe", "RecipeFor");
    }

    @Override
    protected void compile(PageCompiler compiler, LytBlockContainer parent, MdxJsxElementFields el) {
        class_1863 recipeManager = Platform.getClientRecipeManager();
        if (recipeManager == null) {
            parent.appendError(compiler, "Cannot show recipe while not in-game", el);
            return;
        }
        if ("RecipeFor".equals(el.name())) {
            Pair<class_2960, class_1792> itemAndId = MdxAttrs.getRequiredItemAndId(compiler, parent, el, "id");
            if (itemAndId == null) {
                return;
            }
            class_2960 id = (class_2960)itemAndId.getLeft();
            class_1792 item = (class_1792)itemAndId.getRight();
            for (RecipeTypeMapping<?, ?> mapping : this.mappings) {
                LytBlock block = mapping.tryCreate(recipeManager, item);
                if (block == null) continue;
                block.setSourceNode((MdAstNode)((Object)el));
                parent.append(block);
                return;
            }
            parent.appendError(compiler, "Couldn't find recipe for " + id, el);
        } else {
            class_2960 recipeId = MdxAttrs.getRequiredId(compiler, parent, el, "id");
            if (recipeId == null) {
                return;
            }
            class_1860 recipe = recipeManager.method_8130(recipeId).orElse(null);
            if (recipe == null) {
                parent.appendError(compiler, "Couldn't find recipe " + recipeId, el);
                return;
            }
            for (RecipeTypeMapping<?, ?> mapping : this.mappings) {
                LytBlock block = mapping.tryCreate(recipe);
                if (block == null) continue;
                block.setSourceNode((MdAstNode)((Object)el));
                parent.append(block);
                return;
            }
            parent.appendError(compiler, "Couldn't find a handler for recipe " + recipeId, el);
        }
    }

    private record RecipeTypeMapping<T extends class_1860<C>, C extends class_1263>(class_3956<T> recipeType, Function<T, LytBlock> factory) {
        @Nullable
        LytBlock tryCreate(class_1863 recipeManager, class_1792 resultItem) {
            for (class_1860 recipe : recipeManager.method_17717(this.recipeType).values()) {
                try {
                    if (recipe.method_8110(null).method_7909() != resultItem) continue;
                    return this.factory.apply(recipe);
                }
                catch (Exception exception) {
                }
            }
            return null;
        }

        @Nullable
        LytBlock tryCreate(class_1860<?> recipe) {
            if (this.recipeType == recipe.method_17716()) {
                return this.factory.apply(recipe);
            }
            return null;
        }
    }
}

