/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.document.block.recipes;

import appeng.client.guidebook.document.DefaultStyles;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.document.block.LytSlot;
import appeng.client.guidebook.document.block.LytSlotGrid;
import appeng.client.guidebook.document.block.recipes.LytRecipeBox;
import appeng.client.guidebook.layout.LayoutContext;
import appeng.client.guidebook.render.RenderContext;
import appeng.core.AppEng;
import appeng.util.Platform;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_2246;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3955;

public class LytCraftingRecipe
extends LytRecipeBox {
    private static final class_2960 ARROW_LIGHT = AppEng.makeId("ae2guide/gui/recipe_arrow_light.png");
    private static final class_2960 ARROW_DARK = AppEng.makeId("ae2guide/gui/recipe_arrow_dark.png");
    private final class_3955 recipe;
    private final LytSlotGrid grid;
    private final LytSlot resultSlot;

    public LytCraftingRecipe(class_3955 recipe) {
        super((class_1860<?>)recipe);
        this.recipe = recipe;
        this.setPadding(5);
        this.paddingTop = 15;
        class_2371 ingredients = recipe.method_8117();
        if (recipe instanceof class_1869) {
            class_1869 shapedRecipe = (class_1869)recipe;
            this.grid = new LytSlotGrid(shapedRecipe.method_8150(), shapedRecipe.method_8158());
            for (int x = 0; x < shapedRecipe.method_8150(); ++x) {
                for (int y = 0; y < shapedRecipe.method_8158(); ++y) {
                    class_1856 ingredient;
                    int index = y * shapedRecipe.method_8150() + x;
                    if (index >= ingredients.size() || (ingredient = (class_1856)ingredients.get(index)).method_8103()) continue;
                    this.grid.setIngredient(x, y, ingredient);
                }
            }
        } else {
            int ingredientCount = ingredients.size();
            this.grid = new LytSlotGrid(Math.min(3, ingredientCount), (ingredientCount + 2) / 3);
            for (int i = 0; i < ingredients.size(); ++i) {
                int col = i % 3;
                int row = i / 3;
                this.grid.setIngredient(col, row, (class_1856)ingredients.get(i));
            }
        }
        this.append(this.grid);
        this.resultSlot = new LytSlot(recipe.method_8110(Platform.getClientRegistryAccess()));
        this.append(this.resultSlot);
    }

    @Override
    protected LytRect computeBoxLayout(LayoutContext context, int x, int y, int availableWidth) {
        LytRect gridBounds = this.grid.layout(context, x, y, availableWidth);
        LytRect slotBounds = this.resultSlot.layout(context, gridBounds.right() + 28, Math.max(y, gridBounds.y() + (gridBounds.height() - 18) / 2), availableWidth);
        return LytRect.union(gridBounds, slotBounds);
    }

    @Override
    public void render(RenderContext context) {
        context.renderPanel(this.getBounds());
        context.renderItem(class_2246.field_9980.method_8389().method_7854(), this.bounds.x() + this.paddingLeft, this.bounds.y() + 4, 8.0f, 8.0f);
        context.renderText(this.recipe instanceof class_1867 ? "Crafting (Shapeless)" : "Crafting", DefaultStyles.CRAFTING_RECIPE_TYPE.mergeWith(DefaultStyles.BASE_STYLE), this.bounds.x() + this.paddingLeft + 10, this.bounds.y() + 4);
        context.fillTexturedRect(new LytRect(this.bounds.right() - 25 - 24, this.bounds.y() + 10 + (this.bounds.height() - 27) / 2, 24, 17), context.isDarkMode() ? ARROW_DARK : ARROW_LIGHT);
        super.render(context);
    }
}

