/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.document.flow;

import appeng.client.guidebook.PageAnchor;
import appeng.client.guidebook.color.SymbolicColor;
import appeng.client.guidebook.document.flow.LytTooltipSpan;
import appeng.client.guidebook.screen.GuideScreen;
import appeng.sounds.AppEngSounds;
import java.net.URI;
import java.util.function.Consumer;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_407;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LytFlowLink
extends LytTooltipSpan {
    private static final Logger LOG = LoggerFactory.getLogger(LytFlowLink.class);
    @Nullable
    private Consumer<GuideScreen> clickCallback;
    @Nullable
    private class_3414 clickSound = AppEngSounds.GUIDE_CLICK_EVENT;

    public LytFlowLink() {
        this.modifyStyle(style -> style.color(SymbolicColor.LINK));
        this.modifyHoverStyle(style -> style.underlined(true));
    }

    public void setClickCallback(@Nullable Consumer<GuideScreen> clickCallback) {
        this.clickCallback = clickCallback;
    }

    @Override
    public boolean mouseClicked(GuideScreen screen, int x, int y, int button) {
        if (button == 0 && this.clickCallback != null) {
            if (this.clickSound != null) {
                class_1144 handler = class_310.method_1551().method_1483();
                handler.method_4873((class_1113)class_1109.method_4758((class_3414)this.clickSound, (float)1.0f));
            }
            this.clickCallback.accept(screen);
            return true;
        }
        return false;
    }

    @Nullable
    public class_3414 getClickSound() {
        return this.clickSound;
    }

    public void setClickSound(@Nullable class_3414 clickSound) {
        this.clickSound = clickSound;
    }

    public void setExternalUrl(URI uri) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("External URLs must be absolute: " + uri);
        }
        this.setClickCallback(screen -> {
            class_310 mc = class_310.method_1551();
            mc.method_1507((class_437)new class_407(yes -> {
                if (yes) {
                    class_156.method_668().method_673(uri);
                }
                mc.method_1507((class_437)screen);
            }, uri.toString(), true));
        });
    }

    public void setPageLink(PageAnchor anchor) {
        this.setClickCallback(screen -> screen.navigateTo(anchor));
    }
}

