/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.scene;

import appeng.client.guidebook.document.LytPoint;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.scene.CameraSettings;
import appeng.client.guidebook.scene.annotation.InWorldAnnotation;
import appeng.client.guidebook.scene.annotation.OverlayAnnotation;
import appeng.client.guidebook.scene.annotation.SceneAnnotation;
import appeng.client.guidebook.scene.level.GuidebookLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.OptionalDouble;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Intersectionf;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class GuidebookScene {
    private final GuidebookLevel level;
    private final CameraSettings cameraSettings;
    private final List<InWorldAnnotation> inWorldAnnotations = new ArrayList<InWorldAnnotation>();
    private final List<OverlayAnnotation> overlayAnnotations = new ArrayList<OverlayAnnotation>();
    private int width;
    private int height;

    public GuidebookScene(GuidebookLevel level, CameraSettings cameraSettings) {
        this.level = level;
        this.cameraSettings = cameraSettings;
    }

    public Vector4f getScreenBounds() {
        float offx = this.cameraSettings.getOffsetX();
        float offy = this.cameraSettings.getOffsetY();
        this.cameraSettings.setOffsetX(0.0f);
        this.cameraSettings.setOffsetY(0.0f);
        Matrix4f viewMatrix = this.cameraSettings.getViewMatrix();
        this.cameraSettings.setOffsetX(offx);
        this.cameraSettings.setOffsetY(offy);
        Bounds result = this.getBounds(viewMatrix);
        for (InWorldAnnotation highlight : this.inWorldAnnotations) {
            Pair<Vector2f, Vector2f> bounds = highlight.getScreenBounds(viewMatrix);
            result.min().x = Math.min(result.min().x, ((Vector2f)bounds.getLeft()).x);
            result.min().y = Math.min(result.min().y, ((Vector2f)bounds.getLeft()).y);
            result.max().x = Math.max(result.max().x, ((Vector2f)bounds.getRight()).x);
            result.max().y = Math.max(result.max().y, ((Vector2f)bounds.getRight()).y);
        }
        return new Vector4f(result.min().x, result.min().y, result.max().x, result.max().y);
    }

    public void centerScene() {
        Vector4f bounds = this.getScreenBounds();
        float w = -(bounds.z - bounds.x) / 2.0f;
        float h = -(bounds.w - bounds.y) / 2.0f;
        this.cameraSettings.setOffsetX(w - bounds.x);
        this.cameraSettings.setOffsetY(h - bounds.y);
    }

    @NotNull
    private Bounds getBounds(Matrix4f viewMatrix) {
        if (!this.level.hasFilledBlocks()) {
            return new Bounds(new Vector3f(), new Vector3f());
        }
        Vector3f tmpPos = new Vector3f();
        Vector3f min = new Vector3f(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        Vector3f max = new Vector3f(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        this.level.getFilledBlocks().forEach(pos -> {
            for (int xCorner = 0; xCorner <= 1; ++xCorner) {
                for (int yCorner = 0; yCorner <= 1; ++yCorner) {
                    for (int zCorner = 0; zCorner <= 1; ++zCorner) {
                        viewMatrix.transformPosition((float)(pos.method_10263() + xCorner), (float)(pos.method_10264() + yCorner), (float)(pos.method_10260() + zCorner), tmpPos);
                        min.min((Vector3fc)tmpPos);
                        max.max((Vector3fc)tmpPos);
                    }
                }
            }
        });
        return new Bounds(min, max);
    }

    public Vector2f worldToScreen(float x, float y, float z) {
        Matrix4f viewMatrix = this.cameraSettings.getViewMatrix();
        Matrix4f projectionMatrix = this.cameraSettings.getProjectionMatrix();
        Vector3f screenPos = new Vector3f();
        viewMatrix.transformPosition(x, y, z, screenPos);
        projectionMatrix.transformProject(screenPos);
        return new Vector2f(screenPos.x, screenPos.y);
    }

    private static Vector2f worldToScreen(Matrix4f viewMatrix, Matrix4f projectionMatrix, float x, float y, float z) {
        Vector3f screenPos = new Vector3f();
        viewMatrix.transformPosition(x, y, z, screenPos);
        projectionMatrix.transformProject(screenPos);
        return new Vector2f();
    }

    private void buildPickRay(float screenX, float screenY, Vector3f rayOrigin, Vector3f rayDir) {
        Matrix4f viewProj = new Matrix4f((Matrix4fc)this.cameraSettings.getProjectionMatrix());
        viewProj.mul((Matrix4fc)this.cameraSettings.getViewMatrix());
        viewProj.unprojectRay(screenX, screenY, new int[]{-1, -1, 2, 2}, rayOrigin, rayDir);
    }

    @Nullable
    public SceneAnnotation pickAnnotation(LytPoint point, LytRect viewport, Predicate<? super SceneAnnotation> predicate) {
        Vector2f screenPos = this.documentToScreen(viewport, point);
        SceneAnnotation annotation = this.pickOverlayAnnotation(point, viewport, predicate);
        if (annotation == null) {
            annotation = this.pickInWorldAnnotation(screenPos.x, screenPos.y, predicate);
        }
        return annotation;
    }

    @Nullable
    public OverlayAnnotation pickOverlayAnnotation(LytPoint point, LytRect viewport, Predicate<? super OverlayAnnotation> predicate) {
        for (int i = this.overlayAnnotations.size() - 1; i >= 0; --i) {
            LytRect bounds;
            OverlayAnnotation annotation = this.overlayAnnotations.get(i);
            if (!predicate.test(annotation) || !(bounds = annotation.getBoundingRect(this, viewport)).contains(point)) continue;
            return annotation;
        }
        return null;
    }

    @Nullable
    public InWorldAnnotation pickInWorldAnnotation(float screenX, float screenY, Predicate<? super InWorldAnnotation> predicate) {
        Vector3f rayOrigin = new Vector3f();
        Vector3f rayDir = new Vector3f();
        this.buildPickRay(screenX, screenY, rayOrigin, rayDir);
        float pickDistance = Float.POSITIVE_INFINITY;
        InWorldAnnotation pickedBox = null;
        for (InWorldAnnotation highlight : this.inWorldAnnotations) {
            OptionalDouble intersectionDist;
            if (!predicate.test(highlight) || !(intersectionDist = highlight.intersect(rayOrigin, rayDir)).isPresent() || !(intersectionDist.getAsDouble() < (double)pickDistance)) continue;
            pickDistance = (float)intersectionDist.getAsDouble();
            pickedBox = highlight;
        }
        return pickedBox;
    }

    public class_3965 pickBlock(LytPoint point, LytRect viewport) {
        Vector2f screenPos = this.documentToScreen(viewport, point);
        Vector3f rayOrigin = new Vector3f();
        Vector3f rayDir = new Vector3f();
        this.buildPickRay(screenPos.x, screenPos.y, rayOrigin, rayDir);
        GuidebookLevel.Bounds levelBounds = this.level.getBounds();
        Vector2f intersection = new Vector2f();
        if (!Intersectionf.intersectRayAab((Vector3fc)rayOrigin, (Vector3fc)rayDir, (Vector3fc)new Vector3f((float)levelBounds.min().method_10263(), (float)levelBounds.min().method_10264(), (float)levelBounds.min().method_10260()), (Vector3fc)new Vector3f((float)levelBounds.max().method_10263(), (float)levelBounds.max().method_10264(), (float)levelBounds.max().method_10260()), (Vector2f)intersection)) {
            return class_3965.method_17778((class_243)class_243.field_1353, (class_2350)class_2350.field_11036, (class_2338)class_2338.field_10980);
        }
        Vector3f start = new Vector3f((Vector3fc)rayDir).mulAdd(intersection.x, (Vector3fc)rayOrigin);
        Vector3f end = new Vector3f((Vector3fc)rayDir).mulAdd(intersection.y, (Vector3fc)rayOrigin);
        class_243 fromVec3 = new class_243(start);
        class_243 toVec3 = new class_243(end);
        class_3959.class_3960 blockClipContext = class_3959.class_3960.field_17559;
        class_3959.class_242 fluidClipContext = class_3959.class_242.field_1347;
        return (class_3965)class_1922.method_17744((class_243)fromVec3, (class_243)toVec3, null, (ignored, blockPos) -> {
            class_2680 blockState = this.level.method_8320((class_2338)blockPos);
            class_3610 fluidState = this.level.method_8316((class_2338)blockPos);
            class_265 blockShape = blockClipContext.get(blockState, (class_1922)this.level, blockPos, class_3726.method_16194());
            class_3965 blockHit = this.level.method_17745(fromVec3, toVec3, (class_2338)blockPos, blockShape, blockState);
            class_265 fluidShape = fluidClipContext.method_17751(fluidState) ? fluidState.method_17776((class_1922)this.level, blockPos) : class_259.method_1073();
            class_3965 fluidHit = fluidShape.method_1092(fromVec3, toVec3, blockPos);
            double blockDist = blockHit == null ? Double.MAX_VALUE : fromVec3.method_1025(blockHit.method_17784());
            double fluidDist = fluidHit == null ? Double.MAX_VALUE : fromVec3.method_1025(fluidHit.method_17784());
            return blockDist <= fluidDist ? blockHit : fluidHit;
        }, ignored -> {
            class_243 vec3 = fromVec3.method_1020(toVec3);
            return class_3965.method_17778((class_243)toVec3, (class_2350)class_2350.method_10142((double)vec3.field_1352, (double)vec3.field_1351, (double)vec3.field_1350), (class_2338)class_2338.method_49638((class_2374)toVec3));
        });
    }

    public Stream<class_2338> getFilledBlocks() {
        return this.level.getFilledBlocks();
    }

    public Vector3fc getWorldCenter() {
        Vector3f tmpPos = new Vector3f();
        Vector3f min = new Vector3f(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        Vector3f max = new Vector3f(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        this.level.getFilledBlocks().forEach(pos -> {
            Vector3f tmp = new Vector3f();
            for (int xCorner = 0; xCorner <= 1; ++xCorner) {
                for (int yCorner = 0; yCorner <= 1; ++yCorner) {
                    for (int zCorner = 0; zCorner <= 1; ++zCorner) {
                        tmp.set((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
                        min.min((Vector3fc)tmp);
                        max.max((Vector3fc)tmp);
                        tmp.add(1.0f, 1.0f, 1.0f);
                        min.min((Vector3fc)tmp);
                        max.max((Vector3fc)tmp);
                    }
                }
            }
        });
        Vector3f avg = new Vector3f((Vector3fc)min);
        avg.add((Vector3fc)max);
        avg.div(2.0f);
        return avg;
    }

    public GuidebookLevel getLevel() {
        return this.level;
    }

    public CameraSettings getCameraSettings() {
        return this.cameraSettings;
    }

    public void clearAnnotations() {
        this.inWorldAnnotations.clear();
        this.overlayAnnotations.clear();
    }

    public void addAnnotation(SceneAnnotation annotation) {
        if (annotation instanceof InWorldAnnotation) {
            InWorldAnnotation inWorldAnnotation = (InWorldAnnotation)annotation;
            this.inWorldAnnotations.add(inWorldAnnotation);
        }
        if (annotation instanceof OverlayAnnotation) {
            OverlayAnnotation overlayAnnotation = (OverlayAnnotation)annotation;
            this.overlayAnnotations.add(overlayAnnotation);
        }
    }

    public void removeAnnotation(SceneAnnotation annotation) {
        if (annotation instanceof InWorldAnnotation) {
            this.inWorldAnnotations.remove(annotation);
        }
        if (annotation instanceof OverlayAnnotation) {
            this.overlayAnnotations.remove(annotation);
        }
    }

    public Collection<InWorldAnnotation> getInWorldAnnotations() {
        return this.inWorldAnnotations;
    }

    public Collection<OverlayAnnotation> getOverlayAnnotations() {
        return this.overlayAnnotations;
    }

    public Vector2f documentToScreen(LytRect viewport, LytPoint documentPoint) {
        float localX = (documentPoint.x() - (float)viewport.x()) / (float)viewport.width() * 2.0f - 1.0f;
        float localY = -((documentPoint.y() - (float)viewport.y()) / (float)viewport.height() * 2.0f - 1.0f);
        return new Vector2f(localX, localY);
    }

    public LytPoint screenToDocument(Vector2f screen, LytRect viewport) {
        float x = (float)viewport.x() + (screen.x + 1.0f) / 2.0f * (float)viewport.width();
        float y = (float)viewport.y() + (-screen.y + 1.0f) / 2.0f * (float)viewport.height();
        return new LytPoint(x, y);
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    private record Bounds(Vector3f min, Vector3f max) {
    }
}

