/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.parts;

import appeng.api.ids.AETags;
import appeng.api.implementations.items.IFacadeItem;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.PartHelper;
import appeng.core.AEConfig;
import appeng.core.definitions.AEItems;
import appeng.facade.FacadePart;
import appeng.hooks.AEToolItem;
import appeng.items.AEBaseItem;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_7923;

public class FacadeItem
extends AEBaseItem
implements IFacadeItem,
AEToolItem {
    private static final String NBT_ITEM_ID = "item";

    public FacadeItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    public class_1269 onItemUseFirst(class_1799 stack, class_1838 context) {
        if (stack.method_7909() != this) {
            return class_1269.field_5811;
        }
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_1657 player = context.method_8036();
        FacadePart facade = this.createPartFromItemStack(stack, context.method_8038());
        if (facade == null || !FacadeItem.placeFacade(facade, level, pos)) {
            return class_1269.field_5811;
        }
        if (!level.field_9236 && player != null && !player.method_7337()) {
            stack.method_7933(-1);
            if (stack.method_7960()) {
                player.method_6122(context.method_20287(), class_1799.field_8037);
            }
        }
        return class_1269.method_29236((boolean)level.field_9236);
    }

    public static boolean canPlaceFacade(IPartHost host, IFacadePart facade) {
        if (host.getPart(null) == null) {
            return false;
        }
        return host.getFacadeContainer().canAddFacade(facade);
    }

    private static boolean placeFacade(FacadePart facade, class_1937 level, class_2338 blockPos) {
        IPartHost host = PartHelper.getPartHost(level, blockPos);
        if (host == null) {
            return false;
        }
        if (!FacadeItem.canPlaceFacade(host, facade)) {
            return false;
        }
        if (!host.getFacadeContainer().addFacade(facade)) {
            return false;
        }
        class_2680 blockState = facade.getBlockState();
        class_2498 soundType = blockState.method_26231();
        level.method_8396(null, blockPos, soundType.method_10598(), class_3419.field_15245, (soundType.method_10597() + 1.0f) / 2.0f, soundType.method_10599() * 0.8f);
        host.markForSave();
        host.markForUpdate();
        return true;
    }

    public static IFacadePart createFacade(class_1799 held, class_2350 side) {
        if (held.method_7909() instanceof IFacadeItem) {
            return ((IFacadeItem)held.method_7909()).createPartFromItemStack(held, side);
        }
        return null;
    }

    public class_2561 method_7864(class_1799 is) {
        try {
            class_1799 in = this.getTextureItem(is);
            if (!in.method_7960()) {
                return super.method_7864(is).method_27661().method_27693(" - ").method_10852(in.method_7964());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return super.method_7864(is);
    }

    @Override
    public void addToMainCreativeTab(class_1761.class_7704 output) {
    }

    public class_1799 createFacadeForItem(class_1799 itemStack, boolean returnItem) {
        boolean isBlockAllowed;
        class_1792 class_17922;
        if (itemStack.method_7960() || itemStack.method_7985() || !((class_17922 = itemStack.method_7909()) instanceof class_1747)) {
            return class_1799.field_8037;
        }
        class_1747 blockItem = (class_1747)class_17922;
        class_2248 block = blockItem.method_7711();
        if (block == class_2246.field_10124) {
            return class_1799.field_8037;
        }
        class_2680 blockState = block.method_9564();
        boolean areBlockEntitiesEnabled = AEConfig.instance().isBlockEntityFacadesEnabled();
        boolean isWhiteListed = block.method_40142().method_40220(AETags.FACADE_BLOCK_WHITELIST);
        boolean isModel = blockState.method_26217() == class_2464.field_11458;
        class_2680 defaultState = block.method_9564();
        boolean isBlockEntity = defaultState.method_31709();
        boolean isFullCube = defaultState.method_26212((class_1922)class_2682.field_12294, class_2338.field_10980);
        boolean isBlockEntityAllowed = !isBlockEntity || areBlockEntitiesEnabled && isWhiteListed;
        boolean bl = isBlockAllowed = isFullCube || isWhiteListed;
        if (isModel && isBlockEntityAllowed && isBlockAllowed) {
            if (returnItem) {
                return itemStack;
            }
            return this.createFacadeForItemUnchecked(itemStack);
        }
        return class_1799.field_8037;
    }

    public class_1799 createFacadeForItemUnchecked(class_1799 itemStack) {
        class_1799 is = new class_1799((class_1935)this);
        class_2487 data = new class_2487();
        data.method_10582(NBT_ITEM_ID, class_7923.field_41178.method_10221((Object)itemStack.method_7909()).toString());
        is.method_7980(data);
        return is;
    }

    @Override
    public FacadePart createPartFromItemStack(class_1799 is, class_2350 side) {
        class_1799 in = this.getTextureItem(is);
        if (!in.method_7960()) {
            return new FacadePart(is, side);
        }
        return null;
    }

    @Override
    public class_1799 getTextureItem(class_1799 is) {
        class_2487 nbt = is.method_7969();
        if (nbt == null) {
            return class_1799.field_8037;
        }
        class_2960 itemId = new class_2960(nbt.method_10558(NBT_ITEM_ID));
        class_1792 baseItem = (class_1792)class_7923.field_41178.method_10223(itemId);
        return new class_1799((class_1935)baseItem, 1);
    }

    @Override
    public class_2680 getTextureBlockState(class_1799 is) {
        class_1799 baseItemStack = this.getTextureItem(is);
        if (baseItemStack.method_7960()) {
            return class_2246.field_10033.method_9564();
        }
        class_2248 block = class_2248.method_9503((class_1792)baseItemStack.method_7909());
        if (block == class_2246.field_10124) {
            return class_2246.field_10033.method_9564();
        }
        return block.method_9564();
    }

    public class_1799 createFromID(int id) {
        class_1799 facadeStack = AEItems.FACADE.stack();
        class_1792 item = (class_1792)class_7923.field_41178.method_10200(id);
        if (item == class_1802.field_8162) {
            return class_1799.field_8037;
        }
        class_2487 facadeTag = new class_2487();
        facadeTag.method_10582(NBT_ITEM_ID, class_7923.field_41178.method_10221((Object)item).toString());
        facadeStack.method_7980(facadeTag);
        return facadeStack;
    }
}

