/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.config.FuzzyMode;
import appeng.api.stacks.AEKeyType;
import appeng.api.storage.cells.IBasicCellItem;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.upgrades.Upgrades;
import appeng.core.AppEng;
import appeng.items.contents.CellConfig;
import appeng.items.storage.StorageTier;
import appeng.items.tools.powered.AbstractPortableCell;
import appeng.util.ConfigInventory;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_5632;

public class PortableCellItem
extends AbstractPortableCell
implements IBasicCellItem {
    private final StorageTier tier;
    private final AEKeyType keyType;
    private final int totalTypes;

    public PortableCellItem(AEKeyType keyType, int totalTypes, class_3917<?> menuType, StorageTier tier, class_1792.class_1793 props, int defaultColor) {
        super(menuType, props, defaultColor);
        this.tier = tier;
        this.keyType = keyType;
        this.totalTypes = totalTypes;
    }

    @Override
    public double getChargeRate(class_1799 stack) {
        return 80.0 + 80.0 * (double)Upgrades.getEnergyCardMultiplier(this.getUpgrades(stack));
    }

    @Override
    public class_2960 getRecipeId() {
        return AppEng.makeId("tools/" + Objects.requireNonNull(this.getRegistryName()).method_12832());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 level, List<class_2561> lines, class_1836 advancedTooltips) {
        super.method_7851(stack, level, lines, advancedTooltips);
        this.addCellInformationToTooltip(stack, lines);
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        return this.getCellTooltipImage(stack);
    }

    @Override
    public int getBytes(class_1799 cellItem) {
        return this.tier.bytes() / 2;
    }

    @Override
    public int getBytesPerType(class_1799 cellItem) {
        return this.tier.bytes() / 128;
    }

    @Override
    public int getTotalTypes(class_1799 cellItem) {
        return this.totalTypes;
    }

    @Override
    public double getIdleDrain() {
        return 0.5;
    }

    @Override
    public IUpgradeInventory getUpgrades(class_1799 is) {
        return UpgradeInventories.forItem(is, this.keyType == AEKeyType.items() ? 4 : 3, (x$0, x$1) -> super.onUpgradesChanged(x$0, x$1));
    }

    @Override
    public ConfigInventory getConfigInventory(class_1799 is) {
        return CellConfig.create(this.keyType.filter(), is);
    }

    @Override
    public FuzzyMode getFuzzyMode(class_1799 is) {
        String fz = is.method_7948().method_10558("FuzzyMode");
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public void setFuzzyMode(class_1799 is, FuzzyMode fzMode) {
        is.method_7948().method_10582("FuzzyMode", fzMode.name());
    }

    @Override
    public AEKeyType getKeyType() {
        return this.keyType;
    }

    public StorageTier getTier() {
        return this.tier;
    }
}

