/*
 * Decompiled with CFR 0.152.
 */
package appeng.libs.mdx;

import appeng.libs.micromark.Assert;
import appeng.libs.micromark.CharUtil;
import appeng.libs.micromark.ParseException;
import appeng.libs.micromark.Point;
import appeng.libs.micromark.State;
import appeng.libs.micromark.TokenizeContext;
import appeng.libs.micromark.Tokenizer;
import appeng.libs.micromark.factory.FactorySpace;

public final class FactoryMdxExpression {
    private FactoryMdxExpression() {
    }

    public static State create(final TokenizeContext context, final Tokenizer.Effects effects, final State ok, final String type, final String markerType, final String chunkType, final boolean allowLazy, final int startColumn) {
        class StateMachine {
            final Tokenizer.Event tail;
            final int initialPrefix;
            final int prefixExpressionIndent;
            int balance;
            Point startPosition;
            RuntimeException lastCrash;

            StateMachine() {
                this.tail = context.getLastEvent();
                this.initialPrefix = this.tail != null && this.tail.token().type.equals("linePrefix") ? this.tail.context().sliceSerialize(this.tail.token(), true).length() : 0;
                this.prefixExpressionIndent = this.initialPrefix != 0 ? this.initialPrefix + 1 : 0;
                this.balance = 1;
            }

            State start(int code) {
                Assert.check(code == 123, "expected `{`");
                effects.enter(type);
                effects.enter(markerType);
                effects.consume(code);
                effects.exit(markerType);
                this.startPosition = context.now();
                return this::atBreak;
            }

            State atBreak(int code) {
                if (code == Integer.MIN_VALUE) {
                    if (this.lastCrash != null) {
                        throw this.lastCrash;
                    }
                    throw new ParseException("Unexpected end of file in expression, expected a corresponding closing brace for `{`", context.now(), "micromark-extension-mdx-expression:unexpected-eof");
                }
                if (code == 125) {
                    return this.atClosingBrace(code);
                }
                if (CharUtil.markdownLineEnding(code)) {
                    effects.enter("lineEnding");
                    effects.consume(code);
                    effects.exit("lineEnding");
                    int prefixTagIndent = startColumn != 0 ? startColumn + 4 - context.now().column() : 0;
                    int indent = Math.max(this.prefixExpressionIndent, prefixTagIndent);
                    return indent != 0 ? FactorySpace.create(effects, this::atBreak, "linePrefix", indent) : this::atBreak;
                }
                Point now = context.now();
                if (now.line() != this.startPosition.line() && !allowLazy && context.isOnLazyLine()) {
                    throw new ParseException("Unexpected end of file in expression, expected a corresponding closing brace for `{`", context.now(), "micromark-extension-mdx-expression:unexpected-eof");
                }
                effects.enter(chunkType);
                return this.inside(code);
            }

            State inside(int code) {
                if (code == Integer.MIN_VALUE || code == 125 || CharUtil.markdownLineEnding(code)) {
                    effects.exit(chunkType);
                    return this.atBreak(code);
                }
                if (code == 123) {
                    effects.consume(code);
                    ++this.balance;
                    return this::inside;
                }
                effects.consume(code);
                return this::inside;
            }

            State atClosingBrace(int code) {
                --this.balance;
                if (this.balance != 0) {
                    effects.enter(chunkType);
                    effects.consume(code);
                    return this::inside;
                }
                effects.enter(markerType);
                effects.consume(code);
                effects.exit(markerType);
                effects.exit(type);
                return ok;
            }
        }
        return new StateMachine()::start;
    }
}

