/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.pathfinding;

import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridVisitor;
import appeng.api.networking.pathing.ControllerState;
import appeng.blockentity.networking.ControllerBlockEntity;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class ControllerValidator
implements IGridVisitor {
    public static final int MAX_SIZE = 7;
    private boolean valid = true;
    private int found = 0;
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;

    private ControllerValidator(class_2338 pos) {
        this.minX = pos.method_10263();
        this.maxX = pos.method_10263();
        this.minY = pos.method_10264();
        this.maxY = pos.method_10264();
        this.minZ = pos.method_10260();
        this.maxZ = pos.method_10260();
    }

    public static ControllerState calculateState(Collection<ControllerBlockEntity> controllers) {
        if (controllers.isEmpty()) {
            return ControllerState.NO_CONTROLLER;
        }
        ControllerBlockEntity startingController = controllers.iterator().next();
        IGridNode startingNode = startingController.getGridNode();
        if (startingNode == null) {
            return ControllerState.CONTROLLER_CONFLICT;
        }
        ControllerValidator cv = new ControllerValidator(startingController.method_11016());
        startingNode.beginVisit(cv);
        if (!cv.isValid()) {
            return ControllerState.CONTROLLER_CONFLICT;
        }
        if (cv.getFound() != controllers.size()) {
            return ControllerState.CONTROLLER_CONFLICT;
        }
        if (ControllerValidator.hasControllerCross(controllers)) {
            return ControllerState.CONTROLLER_CONFLICT;
        }
        return ControllerState.CONTROLLER_ONLINE;
    }

    @Override
    public boolean visitNode(IGridNode node) {
        Object object;
        if (this.isValid() && (object = node.getOwner()) instanceof ControllerBlockEntity) {
            ControllerBlockEntity c = (ControllerBlockEntity)object;
            class_2338 pos = c.method_11016();
            this.minX = Math.min(pos.method_10263(), this.minX);
            this.maxX = Math.max(pos.method_10263(), this.maxX);
            this.minY = Math.min(pos.method_10264(), this.minY);
            this.maxY = Math.max(pos.method_10264(), this.maxY);
            this.minZ = Math.min(pos.method_10260(), this.minZ);
            this.maxZ = Math.max(pos.method_10260(), this.maxZ);
            if (this.maxX - this.minX < 7 && this.maxY - this.minY < 7 && this.maxZ - this.minZ < 7) {
                ++this.found;
                return true;
            }
            this.valid = false;
        }
        return false;
    }

    private static boolean hasControllerCross(Collection<ControllerBlockEntity> controllers) {
        HashSet<class_2338> posSet = new HashSet<class_2338>(controllers.size());
        for (ControllerBlockEntity controller : controllers) {
            posSet.add(controller.method_11016().method_10062());
        }
        for (class_2338 pos : posSet) {
            boolean upDown;
            boolean eastWest;
            boolean northSouth = posSet.contains(pos.method_10093(class_2350.field_11043)) && posSet.contains(pos.method_10093(class_2350.field_11035));
            if ((northSouth ? 1 : 0) + ((eastWest = posSet.contains(pos.method_10093(class_2350.field_11034)) && posSet.contains(pos.method_10093(class_2350.field_11039))) ? 1 : 0) + ((upDown = posSet.contains(pos.method_10093(class_2350.field_11036)) && posSet.contains(pos.method_10093(class_2350.field_11033))) ? 1 : 0) <= 1) continue;
            return true;
        }
        return false;
    }

    public boolean isValid() {
        return this.valid;
    }

    public int getFound() {
        return this.found;
    }
}

