/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.parts.AEBasePart;
import appeng.parts.automation.PlaneConnections;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import org.jetbrains.annotations.Nullable;

public final class PlaneConnectionHelper {
    private final AEBasePart part;

    public PlaneConnectionHelper(AEBasePart part) {
        this.part = part;
    }

    public PlaneConnections getConnections() {
        class_2350 facingUp;
        class_2350 facingRight;
        class_2586 hostBlockEntity = this.getHostBlockEntity();
        class_2350 side = this.part.getSide();
        switch (side) {
            case field_11036: {
                facingRight = class_2350.field_11034;
                facingUp = class_2350.field_11043;
                break;
            }
            case field_11033: {
                facingRight = class_2350.field_11039;
                facingUp = class_2350.field_11043;
                break;
            }
            case field_11043: {
                facingRight = class_2350.field_11039;
                facingUp = class_2350.field_11036;
                break;
            }
            case field_11035: {
                facingRight = class_2350.field_11034;
                facingUp = class_2350.field_11036;
                break;
            }
            case field_11039: {
                facingRight = class_2350.field_11035;
                facingUp = class_2350.field_11036;
                break;
            }
            case field_11034: {
                facingRight = class_2350.field_11043;
                facingUp = class_2350.field_11036;
                break;
            }
            default: {
                return PlaneConnections.of(false, false, false, false);
            }
        }
        boolean left = false;
        boolean right = false;
        boolean down = false;
        boolean up = false;
        if (hostBlockEntity != null) {
            class_2338 pos;
            class_1937 level = hostBlockEntity.method_10997();
            if (this.isCompatiblePlaneAdjacent(level.method_8321((pos = hostBlockEntity.method_11016()).method_10093(facingRight.method_10153())))) {
                left = true;
            }
            if (this.isCompatiblePlaneAdjacent(level.method_8321(pos.method_10093(facingRight)))) {
                right = true;
            }
            if (this.isCompatiblePlaneAdjacent(level.method_8321(pos.method_10093(facingUp.method_10153())))) {
                down = true;
            }
            if (this.isCompatiblePlaneAdjacent(level.method_8321(pos.method_10093(facingUp)))) {
                up = true;
            }
        }
        return PlaneConnections.of(up, right, down, left);
    }

    public void getBoxes(IPartCollisionHelper bch) {
        boolean minX = true;
        boolean minY = true;
        int maxX = 15;
        int maxY = 15;
        class_2586 hostEntity = this.getHostBlockEntity();
        if (hostEntity != null) {
            class_1937 level = hostEntity.method_10997();
            class_2338 pos = hostEntity.method_11016();
            class_2350 e = bch.getWorldX();
            class_2350 u = bch.getWorldY();
            if (this.isCompatiblePlaneAdjacent(level.method_8321(pos.method_10093(e.method_10153())))) {
                minX = false;
            }
            if (this.isCompatiblePlaneAdjacent(level.method_8321(pos.method_10093(e)))) {
                maxX = 16;
            }
            if (this.isCompatiblePlaneAdjacent(level.method_8321(pos.method_10093(u.method_10153())))) {
                minY = false;
            }
            if (this.isCompatiblePlaneAdjacent(level.method_8321(pos.method_10093(u)))) {
                maxY = 16;
            }
        }
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox((double)minX, (double)minY, 15.0, maxX, maxY, 16.0);
    }

    public void updateConnections() {
    }

    private boolean isCompatiblePlaneAdjacent(@Nullable class_2586 adjacentBlockEntity) {
        if (adjacentBlockEntity instanceof IPartHost) {
            IPart p = ((IPartHost)adjacentBlockEntity).getPart(this.part.getSide());
            return p != null && p.getClass() == this.part.getClass();
        }
        return false;
    }

    private class_2586 getHostBlockEntity() {
        IPartHost host = this.part.getHost();
        if (host != null) {
            return host.getBlockEntity();
        }
        return null;
    }
}

