/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testplots;

import appeng.api.networking.IGrid;
import appeng.api.parts.IPart;
import appeng.api.parts.PartHelper;
import appeng.core.definitions.ItemDefinition;
import appeng.items.parts.PartItem;
import appeng.me.service.P2PService;
import appeng.parts.AEBasePart;
import appeng.parts.p2p.P2PTunnelPart;
import appeng.server.testplots.PosAndSide;
import appeng.server.testworld.PlotBuilder;
import appeng.util.SettingsFrom;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_3218;

public final class P2PPlotHelper {
    private P2PPlotHelper() {
    }

    public static <T extends P2PTunnelPart<?>> void placeTunnel(PlotBuilder plot, ItemDefinition<PartItem<T>> tunnel) {
        class_2338 origin = class_2338.field_10980;
        plot.creativeEnergyCell(origin.method_10074());
        plot.cable(origin);
        plot.cable(origin.method_10067()).part(class_2350.field_11039, tunnel);
        plot.cable(origin.method_10078()).part(class_2350.field_11034, tunnel);
        plot.afterGridInitAt(origin, (grid, gridNode) -> {
            class_2338 absOrigin = ((AEBasePart)gridNode.getOwner()).getBlockEntity().method_11016();
            P2PPlotHelper.linkTunnels(grid, ((PartItem)tunnel.method_8389()).getPartClass(), absOrigin.method_10067(), absOrigin.method_10078());
        });
    }

    public static <T extends P2PTunnelPart<?>> short linkTunnels(IGrid grid, Class<T> tunnelType, class_2338 inputPos, class_2338 outputPos) {
        P2PService p2p = P2PService.get(grid);
        P2PTunnelPart inputTunnel = null;
        P2PTunnelPart outputTunnel = null;
        for (P2PTunnelPart p2pPart : grid.getMachines(tunnelType)) {
            if (p2pPart.getBlockEntity().method_11016().equals((Object)inputPos)) {
                inputTunnel = p2pPart;
                continue;
            }
            if (!p2pPart.getBlockEntity().method_11016().equals((Object)outputPos)) continue;
            outputTunnel = p2pPart;
        }
        Objects.requireNonNull(inputTunnel, "inputTunnel");
        Objects.requireNonNull(outputTunnel, "outputTunnel");
        inputTunnel.setFrequency(p2p.newFrequency());
        p2p.updateFreq(inputTunnel, inputTunnel.getFrequency());
        class_2487 settings = new class_2487();
        inputTunnel.exportSettings(SettingsFrom.MEMORY_CARD, settings);
        outputTunnel.importSettings(SettingsFrom.MEMORY_CARD, settings, null);
        return inputTunnel.getFrequency();
    }

    public static short linkTunnels(IGrid grid, PosAndSide inputPos, Collection<PosAndSide> outputPositions) {
        P2PService p2p = P2PService.get(grid);
        class_3218 level = grid.getPivot().getLevel();
        P2PTunnelPart<?> inputTunnel = P2PPlotHelper.getTunnelAt((class_1937)level, inputPos);
        inputTunnel.setFrequency(p2p.newFrequency());
        p2p.updateFreq(inputTunnel, inputTunnel.getFrequency());
        class_2487 settings = new class_2487();
        inputTunnel.exportSettings(SettingsFrom.MEMORY_CARD, settings);
        for (PosAndSide outputPos : outputPositions) {
            P2PTunnelPart<?> outputTunnel = P2PPlotHelper.getTunnelAt((class_1937)level, outputPos);
            outputTunnel.importSettings(SettingsFrom.MEMORY_CARD, settings, null);
        }
        return inputTunnel.getFrequency();
    }

    private static P2PTunnelPart<?> getTunnelAt(class_1937 level, PosAndSide posAndSide) {
        IPart part = PartHelper.getPart((class_1922)level, posAndSide.pos(), posAndSide.side());
        if (!(part instanceof P2PTunnelPart)) {
            throw new IllegalStateException("No P2P @ " + posAndSide);
        }
        P2PTunnelPart p2PTunnelPart = (P2PTunnelPart)part;
        return p2PTunnelPart;
    }
}

