/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testplots;

import appeng.api.config.Actionable;
import appeng.api.config.LockCraftingMode;
import appeng.api.config.Settings;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.blockentity.crafting.PatternProviderBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEParts;
import appeng.helpers.patternprovider.PatternProviderLogic;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import appeng.parts.crafting.PatternProviderPart;
import appeng.server.testplots.TestPlot;
import appeng.server.testworld.PlotBuilder;
import appeng.server.testworld.PlotTestHelper;
import appeng.server.testworld.SavedBlockEntity;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;

public final class PatternProviderLockModePlots {
    private static final class_2338 LEVER_POS = class_2338.field_10980.method_10078();
    private static final class_2338 BUTTON_POS = class_2338.field_10980.method_10067();
    private static final GenericStack ONE_PLANK = new GenericStack(AEItemKey.of((class_1935)class_2246.field_10161), 1L);
    private static final GenericStack TWO_PLANK = new GenericStack(AEItemKey.of((class_1935)class_2246.field_10161), 2L);

    private PatternProviderLockModePlots() {
    }

    @TestPlot(value="pp_block_lockmode_pulse")
    public static void testBlockLockModePulse(PlotBuilder plot) {
        PatternProviderLockModePlots.setup(plot, false, LockCraftingMode.LOCK_UNTIL_PULSE);
        PatternProviderLockModePlots.testLockModePulse(plot);
    }

    @TestPlot(value="pp_part_lockmode_pulse")
    public static void testPartLockModePulse(PlotBuilder plot) {
        PatternProviderLockModePlots.setup(plot, true, LockCraftingMode.LOCK_UNTIL_PULSE);
        PatternProviderLockModePlots.testLockModePulse(plot);
    }

    private static void testLockModePulse(PlotBuilder plot) {
        plot.test(helper -> {
            PatternProviderLogicHost host = PatternProviderLockModePlots.getHost(helper);
            PatternProviderLogic pp = host.getLogic();
            helper.method_36041().method_36077(1, () -> {
                helper.assertEquals(class_2338.field_10980, (Object)LockCraftingMode.NONE, (Object)pp.getCraftingLockedReason());
                helper.check(PatternProviderLockModePlots.pushPattern(host), "Pushing pattern failed");
                helper.assertEquals(class_2338.field_10980, (Object)LockCraftingMode.LOCK_UNTIL_PULSE, (Object)pp.getCraftingLockedReason());
                helper.check(!PatternProviderLockModePlots.pushPattern(host), "Pushing pattern should fail");
            }).method_36077(1, () -> {
                helper.method_36039(LEVER_POS);
                helper.assertEquals(class_2338.field_10980, (Object)LockCraftingMode.NONE, (Object)pp.getCraftingLockedReason());
                helper.check(PatternProviderLockModePlots.pushPattern(host), "Pushing pattern failed");
                helper.assertEquals(class_2338.field_10980, (Object)LockCraftingMode.LOCK_UNTIL_PULSE, (Object)pp.getCraftingLockedReason());
                helper.check(!PatternProviderLockModePlots.pushPattern(host), "Pushing pattern should fail");
                helper.method_36039(LEVER_POS);
                helper.assertEquals(class_2338.field_10980, (Object)LockCraftingMode.LOCK_UNTIL_PULSE, (Object)pp.getCraftingLockedReason());
                helper.check(!PatternProviderLockModePlots.pushPattern(host), "Pushing pattern should fail");
            }).method_36077(1, () -> {
                helper.assertEquals(class_2338.field_10980, (Object)LockCraftingMode.LOCK_UNTIL_PULSE, (Object)pp.getCraftingLockedReason());
                helper.check(!PatternProviderLockModePlots.pushPattern(host), "Pushing pattern should fail");
                helper.method_36026(BUTTON_POS);
                helper.assertEquals(class_2338.field_10980, (Object)LockCraftingMode.NONE, (Object)pp.getCraftingLockedReason());
                helper.check(PatternProviderLockModePlots.pushPattern(host), "Pushing pattern should succeed");
            }).method_36077(1, () -> {
                KeyCounter counter = helper.countContainerContentAt(class_2338.field_10980.method_10084());
                helper.assertEquals(class_2338.field_10980.method_10084(), 3L, counter.get(AEItemKey.of((class_1935)class_2246.field_10431)));
            }).method_36075();
        });
    }

    @TestPlot(value="pp_block_lockmode_high")
    public static void testBlockLockModeHigh(PlotBuilder plot) {
        PatternProviderLockModePlots.setup(plot, false, LockCraftingMode.LOCK_WHILE_HIGH);
        PatternProviderLockModePlots.testLockModeHigh(plot);
    }

    @TestPlot(value="pp_part_lockmode_high")
    public static void testPartLockModeHigh(PlotBuilder plot) {
        PatternProviderLockModePlots.setup(plot, true, LockCraftingMode.LOCK_WHILE_HIGH);
        PatternProviderLockModePlots.testLockModeHigh(plot);
    }

    private static void testLockModeHigh(PlotBuilder plot) {
        plot.test(helper -> {
            PatternProviderLogicHost host = PatternProviderLockModePlots.getHost(helper);
            PatternProviderLogic pp = host.getLogic();
            helper.method_36041().method_36077(1, () -> {
                helper.assertEquals(class_2338.field_10980, (Object)LockCraftingMode.NONE, (Object)pp.getCraftingLockedReason());
                helper.check(PatternProviderLockModePlots.pushPattern(host), "Pushing pattern failed (1st attempt)");
                helper.check(PatternProviderLockModePlots.pushPattern(host), "Pushing pattern failed (2nd attempt)");
            }).method_36077(1, () -> {
                helper.method_36039(LEVER_POS);
                helper.assertEquals(class_2338.field_10980, (Object)LockCraftingMode.LOCK_WHILE_HIGH, (Object)pp.getCraftingLockedReason());
                helper.check(!PatternProviderLockModePlots.pushPattern(host), "Pushing pattern should fail");
                helper.method_36039(LEVER_POS);
                helper.assertEquals(class_2338.field_10980, (Object)LockCraftingMode.NONE, (Object)pp.getCraftingLockedReason());
                helper.check(PatternProviderLockModePlots.pushPattern(host), "Pushing pattern failed");
                helper.assertEquals(class_2338.field_10980, (Object)LockCraftingMode.NONE, (Object)pp.getCraftingLockedReason());
                helper.check(PatternProviderLockModePlots.pushPattern(host), "Pushing pattern failed (2nd attempt)");
            }).method_36077(1, () -> {
                KeyCounter counter = helper.countContainerContentAt(class_2338.field_10980.method_10084());
                helper.assertEquals(class_2338.field_10980.method_10084(), 4L, counter.get(AEItemKey.of((class_1935)class_2246.field_10431)));
            }).method_36075();
        });
    }

    @TestPlot(value="pp_block_lockmode_low")
    public static void testBlockLockModeLow(PlotBuilder plot) {
        PatternProviderLockModePlots.setup(plot, false, LockCraftingMode.LOCK_WHILE_LOW);
        PatternProviderLockModePlots.testLockModeLow(plot);
    }

    @TestPlot(value="pp_part_lockmode_low")
    public static void testPartLockModeLow(PlotBuilder plot) {
        PatternProviderLockModePlots.setup(plot, true, LockCraftingMode.LOCK_WHILE_LOW);
        PatternProviderLockModePlots.testLockModeLow(plot);
    }

    private static void testLockModeLow(PlotBuilder plot) {
        plot.test(helper -> {
            PatternProviderLogicHost host = PatternProviderLockModePlots.getHost(helper);
            PatternProviderLogic pp = host.getLogic();
            helper.method_36041().method_36077(1, () -> {
                helper.assertEquals(class_2338.field_10980, (Object)LockCraftingMode.LOCK_WHILE_LOW, (Object)pp.getCraftingLockedReason());
                helper.check(!PatternProviderLockModePlots.pushPattern(host), "Pushing pattern should fail");
            }).method_36077(1, () -> {
                helper.method_36039(LEVER_POS);
                helper.assertEquals(class_2338.field_10980, (Object)LockCraftingMode.NONE, (Object)pp.getCraftingLockedReason());
                helper.check(PatternProviderLockModePlots.pushPattern(host), "Pushing pattern failed");
                helper.assertEquals(class_2338.field_10980, (Object)LockCraftingMode.NONE, (Object)pp.getCraftingLockedReason());
                helper.check(PatternProviderLockModePlots.pushPattern(host), "Pushing pattern failed (2nd attempt)");
                helper.method_36039(LEVER_POS);
                helper.assertEquals(class_2338.field_10980, (Object)LockCraftingMode.LOCK_WHILE_LOW, (Object)pp.getCraftingLockedReason());
                helper.check(!PatternProviderLockModePlots.pushPattern(host), "Pushing pattern should fail");
            }).method_36077(1, () -> {
                KeyCounter counter = helper.countContainerContentAt(class_2338.field_10980.method_10084());
                helper.assertEquals(class_2338.field_10980.method_10084(), 2L, counter.get(AEItemKey.of((class_1935)class_2246.field_10431)));
            }).method_36075();
        });
    }

    @TestPlot(value="pp_block_lockmode_result")
    public static void testBlockLockModeResult(PlotBuilder plot) {
        PatternProviderLockModePlots.setup(plot, false, LockCraftingMode.LOCK_UNTIL_RESULT);
        PatternProviderLockModePlots.testLockModeResult(plot);
    }

    @TestPlot(value="pp_part_lockmode_result")
    public static void testPartLockModeResult(PlotBuilder plot) {
        PatternProviderLockModePlots.setup(plot, true, LockCraftingMode.LOCK_UNTIL_RESULT);
        PatternProviderLockModePlots.testLockModeResult(plot);
    }

    private static void testLockModeResult(PlotBuilder plot) {
        plot.storageDrive(class_2338.field_10980.method_10072(), class_2350.field_11035);
        plot.test(helper -> {
            PatternProviderLogicHost host = PatternProviderLockModePlots.getHost(helper);
            PatternProviderLogic pp = host.getLogic();
            helper.method_36041().method_36077(1, () -> {
                helper.assertEquals(class_2338.field_10980, (Object)LockCraftingMode.NONE, (Object)pp.getCraftingLockedReason());
                helper.check(PatternProviderLockModePlots.pushPattern(host), "Pushing pattern should not fail");
                helper.assertEquals(class_2338.field_10980, (Object)LockCraftingMode.LOCK_UNTIL_RESULT, (Object)pp.getCraftingLockedReason());
                GenericStack expectedResult = TWO_PLANK;
                helper.assertEquals(class_2338.field_10980, expectedResult, pp.getUnlockStack());
            }).method_36077(1, () -> {
                pp.getReturnInv().insert(AEItemKey.of((class_1935)class_1802.field_8118), 1L, Actionable.SIMULATE, null);
                helper.assertEquals(class_2338.field_10980, (Object)LockCraftingMode.LOCK_UNTIL_RESULT, (Object)pp.getCraftingLockedReason());
                helper.assertEquals(class_2338.field_10980, TWO_PLANK, pp.getUnlockStack());
                pp.getReturnInv().insert(AEItemKey.of((class_1935)class_1802.field_8118), 1L, Actionable.MODULATE, null);
                helper.check(!pp.getReturnInv().isEmpty(), "Items should not be returned to the network immediately");
                helper.assertEquals(class_2338.field_10980, (Object)LockCraftingMode.LOCK_UNTIL_RESULT, (Object)pp.getCraftingLockedReason());
                helper.assertEquals(class_2338.field_10980, TWO_PLANK, pp.getUnlockStack());
            }).method_36077(1, () -> {
                helper.assertEquals(class_2338.field_10980, (Object)LockCraftingMode.LOCK_UNTIL_RESULT, (Object)pp.getCraftingLockedReason());
                helper.assertEquals(class_2338.field_10980, ONE_PLANK, pp.getUnlockStack());
            }).method_36085(() -> pp.getReturnInv().insert(AEItemKey.of((class_1935)class_1802.field_8118), 1L, Actionable.MODULATE, null)).method_36077(1, () -> {
                helper.assertEquals(class_2338.field_10980, (Object)LockCraftingMode.NONE, (Object)pp.getCraftingLockedReason());
                helper.assertEquals(class_2338.field_10980, null, pp.getUnlockStack());
            }).method_36077(1, () -> {
                helper.check(PatternProviderLockModePlots.pushPattern(host), "Pushing pattern failed");
                helper.assertEquals(class_2338.field_10980, (Object)LockCraftingMode.LOCK_UNTIL_RESULT, (Object)pp.getCraftingLockedReason());
                helper.assertEquals(class_2338.field_10980, TWO_PLANK, pp.getUnlockStack());
            }).method_36077(1, () -> {
                KeyCounter counter = helper.countContainerContentAt(class_2338.field_10980.method_10084());
                helper.assertEquals(class_2338.field_10980.method_10084(), 2L, counter.get(AEItemKey.of((class_1935)class_2246.field_10431)));
            }).method_36075();
        });
    }

    @TestPlot(value="pp_part_wait_for_pulse_saved")
    public static void testPartWaitForPulseSaved(PlotBuilder plot) {
        PatternProviderLockModePlots.setup(plot, true, LockCraftingMode.LOCK_UNTIL_PULSE);
        PatternProviderLockModePlots.testWaitForPulseSaved(plot);
    }

    @TestPlot(value="pp_block_wait_for_pulse_saved")
    public static void testBlockWaitForPulseSaved(PlotBuilder plot) {
        PatternProviderLockModePlots.setup(plot, false, LockCraftingMode.LOCK_UNTIL_PULSE);
        PatternProviderLockModePlots.testWaitForPulseSaved(plot);
    }

    private static void testWaitForPulseSaved(PlotBuilder plot) {
        plot.test(helper -> {
            PatternProviderLogicHost host = PatternProviderLockModePlots.getHost(helper);
            PatternProviderLogic pp = host.getLogic();
            SavedBlockEntity savedBe = new SavedBlockEntity((PlotTestHelper)((Object)helper));
            helper.method_36041().method_36085(() -> {
                helper.check(PatternProviderLockModePlots.pushPattern(host), "push pattern should succeed");
                helper.assertEquals(class_2338.field_10980, (Object)LockCraftingMode.LOCK_UNTIL_PULSE, (Object)pp.getCraftingLockedReason());
                savedBe.saveAndRemove(class_2338.field_10980);
            }).method_36077(1, () -> savedBe.restore()).method_36077(1, () -> {
                PatternProviderLogicHost newHost = PatternProviderLockModePlots.getHost(helper);
                PatternProviderLogic newPp = newHost.getLogic();
                helper.check(newPp != pp, "New pattern provider should not be the same as the old one");
                helper.assertEquals(class_2338.field_10980, (Object)LockCraftingMode.LOCK_UNTIL_PULSE, (Object)newPp.getCraftingLockedReason());
                helper.check(!PatternProviderLockModePlots.pushPattern(newHost), "push pattern should fail");
            }).method_36075();
        });
    }

    @TestPlot(value="pp_part_wait_for_result_saved")
    public static void testPartWaitForResultSaved(PlotBuilder plot) {
        PatternProviderLockModePlots.setup(plot, true, LockCraftingMode.LOCK_UNTIL_RESULT);
        PatternProviderLockModePlots.testWaitForResultSaved(plot);
    }

    @TestPlot(value="pp_block_wait_for_result_saved")
    public static void testBlockWaitForResultSaved(PlotBuilder plot) {
        PatternProviderLockModePlots.setup(plot, false, LockCraftingMode.LOCK_UNTIL_RESULT);
        PatternProviderLockModePlots.testWaitForResultSaved(plot);
    }

    private static void testWaitForResultSaved(PlotBuilder plot) {
        plot.test(helper -> {
            PatternProviderLogicHost host = PatternProviderLockModePlots.getHost(helper);
            PatternProviderLogic pp = host.getLogic();
            SavedBlockEntity savedBe = new SavedBlockEntity((PlotTestHelper)((Object)helper));
            helper.method_36041().method_36085(() -> {
                helper.check(PatternProviderLockModePlots.pushPattern(host), "push pattern should succeed");
                helper.assertEquals(class_2338.field_10980, (Object)LockCraftingMode.LOCK_UNTIL_RESULT, (Object)pp.getCraftingLockedReason());
                helper.assertEquals(class_2338.field_10980, TWO_PLANK, pp.getUnlockStack());
                savedBe.save(class_2338.field_10980);
                helper.method_36044(class_2338.field_10980);
            }).method_36077(1, () -> savedBe.restore()).method_36077(1, () -> {
                PatternProviderLogicHost newHost = PatternProviderLockModePlots.getHost(helper);
                PatternProviderLogic newPp = newHost.getLogic();
                helper.check(newPp != pp, "New pattern provider should not be the same as the old one");
                helper.assertEquals(class_2338.field_10980, (Object)LockCraftingMode.LOCK_UNTIL_RESULT, (Object)newPp.getCraftingLockedReason());
                helper.assertEquals(class_2338.field_10980, TWO_PLANK, pp.getUnlockStack());
                helper.check(!PatternProviderLockModePlots.pushPattern(newHost), "push pattern should fail");
            }).method_36075();
        });
    }

    private static boolean pushPattern(PatternProviderLogicHost host) {
        IPatternDetails details = PatternProviderLockModePlots.createPatternDetails(host);
        KeyCounter[] inputs = new KeyCounter[]{new KeyCounter()};
        inputs[0].add(AEItemKey.of((class_1935)class_2246.field_10431), 1L);
        return host.getLogic().pushPattern(details, inputs);
    }

    private static PatternProviderLogicHost getHost(PlotTestHelper plotTestHelper) {
        class_2586 be = plotTestHelper.method_36014(class_2338.field_10980);
        if (be instanceof PatternProviderBlockEntity) {
            PatternProviderBlockEntity host = (PatternProviderBlockEntity)be;
            return host;
        }
        return plotTestHelper.getPart(class_2338.field_10980, class_2350.field_11036, PatternProviderPart.class);
    }

    private static void setup(PlotBuilder plot, boolean usePart, LockCraftingMode mode) {
        class_2338 origin = class_2338.field_10980;
        plot.creativeEnergyCell(origin.method_10074());
        if (!usePart) {
            plot.blockEntity(origin, AEBlocks.PATTERN_PROVIDER, host -> PatternProviderLockModePlots.setupPatternProvider(host, mode));
        } else {
            plot.cable(origin).part(class_2350.field_11036, AEParts.PATTERN_PROVIDER, host -> PatternProviderLockModePlots.setupPatternProvider(host, mode)).facade(class_2350.field_11039, (class_1935)class_2246.field_10340).facade(class_2350.field_11034, (class_1935)class_2246.field_10340);
        }
        plot.buttonOn(class_2338.field_10980, class_2350.field_11039);
        plot.leverOn(class_2338.field_10980, class_2350.field_11034);
        plot.chest(origin.method_10084(), new class_1799[0]);
    }

    private static void setupPatternProvider(PatternProviderLogicHost host, LockCraftingMode mode) {
        PatternProviderLogic pp = host.getLogic();
        pp.getConfigManager().putSetting(Settings.LOCK_CRAFTING_MODE, mode);
        class_1799 pattern = PatternProviderLockModePlots.createPattern();
        pp.getPatternInv().addItems(pattern);
    }

    private static class_1799 createPattern() {
        return PatternDetailsHelper.encodeProcessingPattern(new GenericStack[]{new GenericStack(AEItemKey.of((class_1935)class_2246.field_10431), 1L)}, new GenericStack[]{TWO_PLANK});
    }

    private static IPatternDetails createPatternDetails(PatternProviderLogicHost host) {
        return PatternDetailsHelper.decodePattern(PatternProviderLockModePlots.createPattern(), host.getBlockEntity().method_10997());
    }
}

