/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.hosePulley;

import com.simibubi.create.content.fluids.transfer.FluidDrainingBehaviour;
import com.simibubi.create.content.fluids.transfer.FluidFillingBehaviour;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;

public class HosePulleyFluidHandler
implements SingleSlotStorage<FluidVariant> {
    private SmartFluidTank internalTank;
    private FluidFillingBehaviour filler;
    private FluidDrainingBehaviour drainer;
    private Supplier<class_2338> rootPosGetter;
    private Supplier<Boolean> predicate;

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        if (!this.internalTank.isEmpty() && !this.internalTank.getFluid().canFill(resource)) {
            return 0L;
        }
        if (resource.isBlank() || !FluidHelper.hasBlockState(resource.getFluid())) {
            return 0L;
        }
        long diff = maxAmount;
        long totalAmountAfterFill = diff + this.internalTank.getFluidAmount();
        long remaining = maxAmount;
        boolean deposited = false;
        if (this.predicate.get().booleanValue() && totalAmountAfterFill >= 81000L && this.filler.tryDeposit(resource.getFluid(), this.rootPosGetter.get(), transaction)) {
            this.drainer.counterpartActed(transaction);
            remaining -= 81000L;
            diff -= 81000L;
            deposited = true;
        }
        if (diff <= 0L) {
            this.internalTank.extract(resource, -diff, transaction);
            return maxAmount;
        }
        return this.internalTank.insert(resource, remaining, transaction) + (deposited ? 81000L : 0L);
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        if (resource != null && !this.internalTank.isEmpty() && !this.internalTank.getFluid().canFill(resource)) {
            return 0L;
        }
        if (this.internalTank.getFluidAmount() >= 81000L) {
            return this.internalTank.extract(resource, maxAmount, transaction);
        }
        class_2338 pos = this.rootPosGetter.get();
        FluidStack returned = this.drainer.getDrainableFluid(pos);
        if (!this.predicate.get().booleanValue() || !this.drainer.pullNext(pos, transaction)) {
            return this.internalTank.extract(resource, maxAmount, transaction);
        }
        this.filler.counterpartActed(transaction);
        FluidStack leftover = returned.copy();
        long available = 81000L + this.internalTank.getFluidAmount();
        if (!this.internalTank.isEmpty() && !this.internalTank.getFluid().isFluidEqual(returned) || returned.isEmpty()) {
            return this.internalTank.extract(resource, maxAmount, transaction);
        }
        if (resource != null && !returned.canFill(resource)) {
            return 0L;
        }
        long drained = Math.min(maxAmount, available);
        returned.setAmount(drained);
        leftover.setAmount(available - drained);
        if (!leftover.isEmpty()) {
            this.internalTank.setFluid(leftover, transaction);
        }
        return returned.getAmount();
    }

    public boolean isResourceBlank() {
        return this.getResource().isBlank();
    }

    public FluidVariant getResource() {
        if (!this.internalTank.isResourceBlank() || this.drainer.blockEntity.method_10997() == null) {
            return (FluidVariant)this.internalTank.getResource();
        }
        class_3610 state = this.drainer.blockEntity.method_10997().method_8316(this.rootPosGetter.get());
        class_3611 f = state.method_15772();
        if (f instanceof class_3609) {
            class_3609 flowing = (class_3609)f;
            f = flowing.method_15751();
        }
        if (!f.method_15793(state)) {
            return FluidVariant.blank();
        }
        return FluidVariant.of((class_3611)f);
    }

    public long getAmount() {
        return this.isResourceBlank() ? 0L : Long.MAX_VALUE;
    }

    public long getCapacity() {
        return Long.MAX_VALUE;
    }

    public HosePulleyFluidHandler(SmartFluidTank internalTank, FluidFillingBehaviour filler, FluidDrainingBehaviour drainer, Supplier<class_2338> rootPosGetter, Supplier<Boolean> predicate) {
        this.internalTank = internalTank;
        this.filler = filler;
        this.drainer = drainer;
        this.rootPosGetter = rootPosGetter;
        this.predicate = predicate;
    }

    public SmartFluidTank getInternalTank() {
        return this.internalTank;
    }
}

