/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.base;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.AllParticleTypes;
import com.simibubi.create.content.kinetics.base.RotationIndicatorParticle;
import com.simibubi.create.foundation.particle.ICustomParticleDataWithSprite;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2540;
import net.minecraft.class_702;

public class RotationIndicatorParticleData
implements class_2394,
ICustomParticleDataWithSprite<RotationIndicatorParticleData> {
    public static final PrimitiveCodec<Character> CHAR = new PrimitiveCodec<Character>(){

        public <T> DataResult<Character> read(DynamicOps<T> ops, T input) {
            return ops.getNumberValue(input).map(n -> Character.valueOf((char)n.shortValue()));
        }

        public <T> T write(DynamicOps<T> ops, Character value) {
            return (T)ops.createShort((short)value.charValue());
        }

        public String toString() {
            return "Char";
        }
    };
    public static final Codec<RotationIndicatorParticleData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.fieldOf("color").forGetter(p -> p.color), (App)Codec.FLOAT.fieldOf("speed").forGetter(p -> Float.valueOf(p.speed)), (App)Codec.FLOAT.fieldOf("radius1").forGetter(p -> Float.valueOf(p.radius1)), (App)Codec.FLOAT.fieldOf("radius2").forGetter(p -> Float.valueOf(p.radius2)), (App)Codec.INT.fieldOf("lifeSpan").forGetter(p -> p.lifeSpan), (App)CHAR.fieldOf("axis").forGetter(p -> Character.valueOf(p.axis))).apply((Applicative)i, RotationIndicatorParticleData::new));
    public static final class_2394.class_2395<RotationIndicatorParticleData> DESERIALIZER = new class_2394.class_2395<RotationIndicatorParticleData>(){

        public RotationIndicatorParticleData fromCommand(class_2396<RotationIndicatorParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int color = reader.readInt();
            reader.expect(' ');
            float speed = (float)reader.readDouble();
            reader.expect(' ');
            float rad1 = (float)reader.readDouble();
            reader.expect(' ');
            float rad2 = (float)reader.readDouble();
            reader.expect(' ');
            int lifeSpan = reader.readInt();
            reader.expect(' ');
            char axis = reader.read();
            return new RotationIndicatorParticleData(color, speed, rad1, rad2, lifeSpan, axis);
        }

        public RotationIndicatorParticleData fromNetwork(class_2396<RotationIndicatorParticleData> particleTypeIn, class_2540 buffer) {
            return new RotationIndicatorParticleData(buffer.readInt(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readInt(), buffer.readChar());
        }
    };
    final int color;
    final float speed;
    final float radius1;
    final float radius2;
    final int lifeSpan;
    final char axis;

    public RotationIndicatorParticleData(int color, float speed, float radius1, float radius2, int lifeSpan, char axis) {
        this.color = color;
        this.speed = speed;
        this.radius1 = radius1;
        this.radius2 = radius2;
        this.lifeSpan = lifeSpan;
        this.axis = axis;
    }

    public RotationIndicatorParticleData() {
        this(0, 0.0f, 0.0f, 0.0f, 0, '0');
    }

    public class_2396<?> method_10295() {
        return AllParticleTypes.ROTATION_INDICATOR.get();
    }

    public class_2350.class_2351 getAxis() {
        return class_2350.class_2351.valueOf((String)("" + this.axis));
    }

    public void method_10294(class_2540 buffer) {
        buffer.writeInt(this.color);
        buffer.writeFloat(this.speed);
        buffer.writeFloat(this.radius1);
        buffer.writeFloat(this.radius2);
        buffer.writeInt(this.lifeSpan);
        buffer.writeChar((int)this.axis);
    }

    public String method_10293() {
        return String.format(Locale.ROOT, "%s %d %.2f %.2f %.2f %d %c", AllParticleTypes.ROTATION_INDICATOR.parameter(), this.color, Float.valueOf(this.speed), Float.valueOf(this.radius1), Float.valueOf(this.radius2), this.lifeSpan, Character.valueOf(this.axis));
    }

    @Override
    public class_2394.class_2395<RotationIndicatorParticleData> getDeserializer() {
        return DESERIALIZER;
    }

    @Override
    public Codec<RotationIndicatorParticleData> getCodec(class_2396<RotationIndicatorParticleData> type) {
        return CODEC;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_702.class_4091<RotationIndicatorParticleData> getMetaFactory() {
        return RotationIndicatorParticle.Factory::new;
    }
}

