/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.depot;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.depot.DepotItemHandler;
import com.simibubi.create.content.logistics.funnel.AbstractFunnelBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;

public class DepotBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<DepotBehaviour> TYPE = new BehaviourType();
    TransportedItemStack heldItem;
    List<TransportedItemStack> incoming;
    ItemStackHandler processingOutputBuffer;
    public DepotItemHandler itemHandler;
    TransportedItemStackHandlerBehaviour transportedHandler;
    Supplier<Integer> maxStackSize;
    Supplier<Boolean> canAcceptItems;
    Predicate<class_2350> canFunnelsPullFrom;
    Consumer<class_1799> onHeldInserted;
    Predicate<class_1799> acceptedItems;
    boolean allowMerge;
    SnapshotParticipant<Data> snapshotParticipant = new SnapshotParticipant<Data>(){

        protected Data createSnapshot() {
            return new Data(new ArrayList<TransportedItemStack>(DepotBehaviour.this.incoming), DepotBehaviour.this.heldItem == null ? null : DepotBehaviour.this.heldItem.fullCopy());
        }

        protected void readSnapshot(Data snapshot) {
            DepotBehaviour.this.incoming = snapshot.incoming;
            DepotBehaviour.this.heldItem = snapshot.held;
        }

        protected void onFinalCommit() {
            DepotBehaviour.this.blockEntity.notifyUpdate();
        }
    };

    public DepotBehaviour(final SmartBlockEntity be) {
        super(be);
        this.maxStackSize = () -> 64;
        this.canAcceptItems = () -> true;
        this.canFunnelsPullFrom = $ -> true;
        this.acceptedItems = $ -> true;
        this.onHeldInserted = $ -> {};
        this.incoming = new ArrayList<TransportedItemStack>();
        this.itemHandler = new DepotItemHandler(this);
        this.processingOutputBuffer = new ItemStackHandler(8){

            protected void onContentsChanged(int slot) {
                be.notifyUpdate();
            }
        };
    }

    public void enableMerging() {
        this.allowMerge = true;
    }

    public DepotBehaviour withCallback(Consumer<class_1799> changeListener) {
        this.onHeldInserted = changeListener;
        return this;
    }

    public DepotBehaviour onlyAccepts(Predicate<class_1799> filter) {
        this.acceptedItems = filter;
        return this;
    }

    @Override
    public void tick() {
        BeltProcessingBehaviour.ProcessingResult result;
        super.tick();
        class_1937 world = this.blockEntity.method_10997();
        Iterator<TransportedItemStack> iterator = this.incoming.iterator();
        while (iterator.hasNext()) {
            TransportedItemStack ts = iterator.next();
            if (!this.tick(ts) || world.field_9236 && !this.blockEntity.isVirtual()) continue;
            if (this.heldItem == null) {
                this.heldItem = ts;
            } else if (!ItemHelper.canItemStackAmountsStack(this.heldItem.stack, ts.stack)) {
                class_243 vec = VecHelper.getCenterOf((class_2382)this.blockEntity.method_11016());
                class_1264.method_5449((class_1937)this.blockEntity.method_10997(), (double)vec.field_1352, (double)(vec.field_1351 + 0.5), (double)vec.field_1350, (class_1799)ts.stack);
            } else {
                this.heldItem.stack.method_7933(ts.stack.method_7947());
            }
            iterator.remove();
            this.blockEntity.notifyUpdate();
        }
        if (this.heldItem == null) {
            return;
        }
        if (!this.tick(this.heldItem)) {
            return;
        }
        class_2338 pos = this.blockEntity.method_11016();
        if (world.field_9236) {
            return;
        }
        if (this.handleBeltFunnelOutput()) {
            return;
        }
        BeltProcessingBehaviour processingBehaviour = BlockEntityBehaviour.get((class_1922)world, pos.method_10086(2), BeltProcessingBehaviour.TYPE);
        if (processingBehaviour == null) {
            return;
        }
        if (!this.heldItem.locked && BeltProcessingBehaviour.isBlocked((class_1922)world, pos)) {
            return;
        }
        class_1799 previousItem = this.heldItem.stack;
        boolean wasLocked = this.heldItem.locked;
        BeltProcessingBehaviour.ProcessingResult processingResult = result = wasLocked ? processingBehaviour.handleHeldItem(this.heldItem, this.transportedHandler) : processingBehaviour.handleReceivedItem(this.heldItem, this.transportedHandler);
        if (result == BeltProcessingBehaviour.ProcessingResult.REMOVE) {
            this.heldItem = null;
            this.blockEntity.sendData();
            return;
        }
        if (this.heldItem == null) {
            this.blockEntity.sendData();
            return;
        }
        boolean bl = this.heldItem.locked = result == BeltProcessingBehaviour.ProcessingResult.HOLD;
        if (this.heldItem.locked != wasLocked || !class_1799.method_7973((class_1799)previousItem, (class_1799)this.heldItem.stack)) {
            this.blockEntity.sendData();
        }
    }

    protected boolean tick(TransportedItemStack heldItem) {
        heldItem.prevBeltPosition = heldItem.beltPosition;
        heldItem.prevSideOffset = heldItem.sideOffset;
        float diff = 0.5f - heldItem.beltPosition;
        if (diff > 0.001953125f) {
            if (diff > 0.03125f && !BeltHelper.isItemUpright(heldItem.stack)) {
                ++heldItem.angle;
            }
            heldItem.beltPosition += diff / 4.0f;
        }
        return diff < 0.0625f;
    }

    private boolean handleBeltFunnelOutput() {
        class_2680 funnel = this.getWorld().method_8320(this.getPos().method_10084());
        class_2350 funnelFacing = AbstractFunnelBlock.getFunnelFacing(funnel);
        if (funnelFacing == null || !this.canFunnelsPullFrom.test(funnelFacing.method_10153())) {
            return false;
        }
        for (int slot = 0; slot < this.processingOutputBuffer.getSlotCount(); ++slot) {
            class_1799 previousItem = this.processingOutputBuffer.getStackInSlot(slot);
            if (previousItem.method_7960()) continue;
            class_1799 afterInsert = this.blockEntity.getBehaviour(DirectBeltInputBehaviour.TYPE).tryExportingToBeltFunnel(previousItem, null, false);
            if (afterInsert == null) {
                return false;
            }
            if (previousItem.method_7947() == afterInsert.method_7947()) continue;
            this.processingOutputBuffer.setStackInSlot(slot, afterInsert);
            this.blockEntity.notifyUpdate();
            return true;
        }
        class_1799 previousItem = this.heldItem.stack;
        if (previousItem.method_7960()) {
            return false;
        }
        class_1799 afterInsert = this.blockEntity.getBehaviour(DirectBeltInputBehaviour.TYPE).tryExportingToBeltFunnel(previousItem, null, false);
        if (afterInsert == null) {
            return false;
        }
        if (previousItem.method_7947() != afterInsert.method_7947()) {
            if (afterInsert.method_7960()) {
                this.heldItem = null;
            } else {
                this.heldItem.stack = afterInsert;
            }
            this.blockEntity.notifyUpdate();
            return true;
        }
        return false;
    }

    @Override
    public void destroy() {
        super.destroy();
        class_1937 level = this.getWorld();
        class_2338 pos = this.getPos();
        ItemHelper.dropContents(level, pos, (Storage<ItemVariant>)this.processingOutputBuffer);
        for (TransportedItemStack transportedItemStack : this.incoming) {
            class_2248.method_9577((class_1937)level, (class_2338)pos, (class_1799)transportedItemStack.stack);
        }
        if (!this.getHeldItemStack().method_7960()) {
            class_2248.method_9577((class_1937)level, (class_2338)pos, (class_1799)this.getHeldItemStack());
        }
    }

    @Override
    public void unload() {
        this.itemHandler = null;
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        if (this.heldItem != null) {
            compound.method_10566("HeldItem", (class_2520)this.heldItem.serializeNBT());
        }
        compound.method_10566("OutputBuffer", (class_2520)this.processingOutputBuffer.serializeNBT());
        if (this.canMergeItems() && !this.incoming.isEmpty()) {
            compound.method_10566("Incoming", (class_2520)NBTHelper.writeCompoundList(this.incoming, TransportedItemStack::serializeNBT));
        }
    }

    @Override
    public void read(class_2487 compound, boolean clientPacket) {
        this.heldItem = null;
        if (compound.method_10545("HeldItem")) {
            this.heldItem = TransportedItemStack.read(compound.method_10562("HeldItem"));
        }
        this.processingOutputBuffer.deserializeNBT(compound.method_10562("OutputBuffer"));
        if (this.canMergeItems()) {
            class_2499 list = compound.method_10554("Incoming", 10);
            this.incoming = NBTHelper.readCompoundList(list, TransportedItemStack::read);
        }
    }

    public void addSubBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(this.blockEntity).allowingBeltFunnels().setInsertionHandler(this::tryInsertingFromSide).considerOccupiedWhen(this::isOccupied));
        this.transportedHandler = new TransportedItemStackHandlerBehaviour(this.blockEntity, this::applyToAllItems).withStackPlacement(this::getWorldPositionOf);
        behaviours.add(this.transportedHandler);
    }

    public class_1799 getHeldItemStack() {
        return this.heldItem == null ? class_1799.field_8037 : this.heldItem.stack;
    }

    public boolean canMergeItems() {
        return this.allowMerge;
    }

    public int getPresentStackSize() {
        int cumulativeStackSize = 0;
        cumulativeStackSize += this.getHeldItemStack().method_7947();
        for (int slot = 0; slot < this.processingOutputBuffer.getSlotCount(); ++slot) {
            cumulativeStackSize += this.processingOutputBuffer.getStackInSlot(slot).method_7947();
        }
        return cumulativeStackSize;
    }

    public int getRemainingSpace() {
        int cumulativeStackSize = this.getPresentStackSize();
        for (TransportedItemStack transportedItemStack : this.incoming) {
            cumulativeStackSize += transportedItemStack.stack.method_7947();
        }
        int fromGetter = this.maxStackSize.get();
        return (fromGetter == 0 ? 64 : fromGetter) - cumulativeStackSize;
    }

    public class_1799 insert(TransportedItemStack heldItem, TransactionContext ctx) {
        if (!this.canAcceptItems.get().booleanValue()) {
            return heldItem.stack;
        }
        if (!this.acceptedItems.test(heldItem.stack)) {
            return heldItem.stack;
        }
        if (this.canMergeItems()) {
            int remainingSpace = this.getRemainingSpace();
            class_1799 inserted = heldItem.stack;
            if (remainingSpace <= 0) {
                return inserted;
            }
            if (this.heldItem != null && !ItemHelper.canItemStackAmountsStack(this.heldItem.stack, inserted)) {
                return inserted;
            }
            class_1799 returned = class_1799.field_8037;
            this.snapshotParticipant.updateSnapshots(ctx);
            if (remainingSpace < inserted.method_7947()) {
                returned = ItemHandlerHelper.copyStackWithSize((class_1799)heldItem.stack, (int)(inserted.method_7947() - remainingSpace));
                TransportedItemStack copy = heldItem.copy();
                copy.stack.method_7939(remainingSpace);
                if (this.heldItem != null) {
                    this.incoming.add(copy);
                } else {
                    this.heldItem = copy;
                }
            } else if (this.heldItem != null) {
                this.incoming.add(heldItem);
            } else {
                this.heldItem = heldItem;
            }
            return returned;
        }
        if (this.isEmpty()) {
            if (heldItem.insertedFrom.method_10166().method_10179()) {
                TransactionCallback.onSuccess((TransactionContext)ctx, () -> AllSoundEvents.DEPOT_SLIDE.playOnServer(this.getWorld(), (class_2382)this.getPos()));
            } else {
                TransactionCallback.onSuccess((TransactionContext)ctx, () -> AllSoundEvents.DEPOT_PLOP.playOnServer(this.getWorld(), (class_2382)this.getPos()));
            }
        }
        this.snapshotParticipant.updateSnapshots(ctx);
        this.heldItem = heldItem;
        TransactionCallback.onSuccess((TransactionContext)ctx, () -> this.onHeldInserted.accept(heldItem.stack));
        return class_1799.field_8037;
    }

    public void setHeldItem(TransportedItemStack heldItem) {
        this.heldItem = heldItem;
    }

    public void removeHeldItem() {
        this.heldItem = null;
    }

    public void setCenteredHeldItem(TransportedItemStack heldItem) {
        this.heldItem = heldItem;
        this.heldItem.beltPosition = 0.5f;
        this.heldItem.prevBeltPosition = 0.5f;
    }

    private boolean isOccupied(class_2350 side) {
        if (!this.getHeldItemStack().method_7960() && !this.canMergeItems()) {
            return true;
        }
        if (!this.isOutputEmpty() && !this.canMergeItems()) {
            return true;
        }
        return this.canAcceptItems.get() == false;
    }

    private class_1799 tryInsertingFromSide(TransportedItemStack transportedStack, class_2350 side, boolean simulate) {
        class_1799 inserted = transportedStack.stack;
        if (this.isOccupied(side)) {
            return inserted;
        }
        int size = transportedStack.stack.method_7947();
        transportedStack = transportedStack.copy();
        transportedStack.beltPosition = side.method_10166().method_10178() ? 0.5f : 0.0f;
        transportedStack.insertedFrom = side;
        transportedStack.prevSideOffset = transportedStack.sideOffset;
        transportedStack.prevBeltPosition = transportedStack.beltPosition;
        try (Transaction t = TransferUtil.getTransaction();){
            this.snapshotParticipant.updateSnapshots((TransactionContext)t);
            class_1799 remainder = this.insert(transportedStack, (TransactionContext)t);
            if (remainder.method_7947() != size) {
                this.blockEntity.notifyUpdate();
            }
            if (!simulate) {
                t.commit();
            }
            class_1799 class_17992 = remainder;
            return class_17992;
        }
    }

    private void applyToAllItems(float maxDistanceFromCentre, Function<TransportedItemStack, TransportedItemStackHandlerBehaviour.TransportedResult> processFunction) {
        if (this.heldItem == null) {
            return;
        }
        if (0.5f - this.heldItem.beltPosition > maxDistanceFromCentre) {
            return;
        }
        boolean dirty = false;
        TransportedItemStack transportedItemStack = this.heldItem;
        class_1799 stackBefore = transportedItemStack.stack.method_7972();
        TransportedItemStackHandlerBehaviour.TransportedResult result = processFunction.apply(transportedItemStack);
        if (result == null || result.didntChangeFrom(stackBefore)) {
            return;
        }
        dirty = true;
        this.heldItem = null;
        if (result.hasHeldOutput()) {
            this.setCenteredHeldItem(result.getHeldOutput());
        }
        for (TransportedItemStack added : result.getOutputs()) {
            if (this.getHeldItemStack().method_7960()) {
                this.setCenteredHeldItem(added);
                continue;
            }
            Transaction t = TransferUtil.getTransaction();
            try {
                long inserted = this.processingOutputBuffer.insert(ItemVariant.of((class_1799)added.stack), (long)added.stack.method_7947(), (TransactionContext)t);
                t.commit();
                class_1799 remainder = added.stack.method_7972();
                remainder.method_7939(ItemHelper.truncateLong((long)added.stack.method_7947() - inserted));
                class_243 vec = VecHelper.getCenterOf((class_2382)this.blockEntity.method_11016());
                class_1264.method_5449((class_1937)this.blockEntity.method_10997(), (double)vec.field_1352, (double)(vec.field_1351 + 0.5), (double)vec.field_1350, (class_1799)remainder);
            }
            finally {
                if (t == null) continue;
                t.close();
            }
        }
        if (dirty) {
            this.blockEntity.notifyUpdate();
        }
    }

    public boolean isEmpty() {
        return this.heldItem == null && this.isOutputEmpty();
    }

    public boolean isOutputEmpty() {
        for (int i = 0; i < this.processingOutputBuffer.getSlotCount(); ++i) {
            if (this.processingOutputBuffer.getStackInSlot(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    private class_243 getWorldPositionOf(TransportedItemStack transported) {
        return VecHelper.getCenterOf((class_2382)this.blockEntity.method_11016());
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public boolean isItemValid(class_1799 stack) {
        return this.acceptedItems.test(stack);
    }

    record Data(List<TransportedItemStack> incoming, TransportedItemStack held) {
    }
}

