/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.tunnel;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.logistics.flwdata.FlapData;
import com.simibubi.create.content.logistics.tunnel.BeltTunnelBlockEntity;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_1944;
import net.minecraft.class_2350;
import net.minecraft.class_2586;

public class BeltTunnelInstance
extends BlockEntityInstance<BeltTunnelBlockEntity>
implements DynamicInstance {
    private final Map<class_2350, ArrayList<FlapData>> tunnelFlaps = new EnumMap<class_2350, ArrayList<FlapData>>(class_2350.class);

    public BeltTunnelInstance(MaterialManager materialManager, BeltTunnelBlockEntity blockEntity) {
        super(materialManager, (class_2586)blockEntity);
        Instancer model = materialManager.defaultSolid().material(AllMaterialSpecs.FLAPS).getModel(AllPartialModels.BELT_TUNNEL_FLAP, this.blockState);
        int blockLight = this.world.method_8314(class_1944.field_9282, this.pos);
        int skyLight = this.world.method_8314(class_1944.field_9284, this.pos);
        blockEntity.flaps.forEach((direction, flapValue) -> {
            float flapness = flapValue.getValue(AnimationTickHolder.getPartialTicks());
            float horizontalAngle = direction.method_10153().method_10144();
            float flapScale = direction.method_10166() == class_2350.class_2351.field_11048 ? 1.0f : -1.0f;
            ArrayList<FlapData> flaps = new ArrayList<FlapData>(4);
            for (int segment = 0; segment <= 3; ++segment) {
                float intensity = segment == 3 ? 1.5f : (float)(segment + 1);
                float segmentOffset = -0.190625f * (float)segment + 0.0046875f;
                FlapData key = (FlapData)model.createInstance();
                key.setPosition(this.getInstancePosition()).setSegmentOffset(segmentOffset, 0.0f, 0.0f).setBlockLight(blockLight).setSkyLight(skyLight).setHorizontalAngle(horizontalAngle).setFlapness(flapness).setFlapScale(flapScale).setPivotVoxelSpace(0.0f, 10.0f, 1.0f).setIntensity(intensity);
                flaps.add(key);
            }
            this.tunnelFlaps.put((class_2350)direction, flaps);
        });
    }

    public boolean shouldReset() {
        return super.shouldReset() || this.tunnelFlaps.size() != ((BeltTunnelBlockEntity)this.blockEntity).flaps.size();
    }

    public void beginFrame() {
        this.tunnelFlaps.forEach((direction, keys) -> {
            LerpedFloat lerpedFloat = ((BeltTunnelBlockEntity)this.blockEntity).flaps.get(direction);
            if (lerpedFloat == null) {
                return;
            }
            float flapness = lerpedFloat.getValue(AnimationTickHolder.getPartialTicks());
            for (FlapData flap : keys) {
                flap.setFlapness(flapness);
            }
        });
    }

    public void updateLight() {
        this.relight(this.pos, this.tunnelFlaps.values().stream().flatMap(Collection::stream));
    }

    public void remove() {
        this.tunnelFlaps.values().stream().flatMap(Collection::stream).forEach(InstanceData::delete);
    }
}

