/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.station;

import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.CreateClient;
import com.simibubi.create.compat.computercraft.ComputerScreen;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TrainIconType;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.content.trains.station.StationRenderer;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.utility.Components;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public abstract class AbstractStationScreen
extends AbstractSimiScreen {
    protected AllGuiTextures background;
    protected StationBlockEntity blockEntity;
    protected GlobalStation station;
    protected WeakReference<Train> displayedTrain;
    private IconButton confirmButton;

    public AbstractStationScreen(StationBlockEntity be, GlobalStation station) {
        super((class_2561)be.method_11010().method_26204().method_9518());
        this.blockEntity = be;
        this.station = station;
        this.displayedTrain = new WeakReference<Object>(null);
    }

    @Override
    protected void method_25426() {
        if (this.blockEntity.computerBehaviour.hasAttachedComputer()) {
            this.field_22787.method_1507((class_437)new ComputerScreen(this.field_22785, () -> Components.literal(this.station.name), this::renderAdditional, this, this.blockEntity.computerBehaviour::hasAttachedComputer));
        }
        this.setWindowSize(this.background.width, this.background.height);
        super.method_25426();
        this.method_37067();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.confirmButton = new IconButton(x + this.background.width - 33, y + this.background.height - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> ((AbstractStationScreen)this).method_25419());
        this.method_37063(this.confirmButton);
    }

    public int getTrainIconWidth(Train train) {
        TrainIconType icon = train.icon;
        List<Carriage> carriages = train.carriages;
        int w = icon.getIconWidth(-1);
        if (carriages.size() == 1) {
            return w;
        }
        for (int i = 1; i < carriages.size(); ++i) {
            if (i == carriages.size() - 1 && train.doubleEnded) {
                w += icon.getIconWidth(-2) + 1;
                break;
            }
            Carriage carriage = carriages.get(i);
            w += icon.getIconWidth(carriage.bogeySpacing) + 1;
        }
        return w;
    }

    @Override
    public void method_25393() {
        super.method_25393();
        if (this.blockEntity.computerBehaviour.hasAttachedComputer()) {
            this.field_22787.method_1507((class_437)new ComputerScreen(this.field_22785, () -> Components.literal(this.station.name), this::renderAdditional, this, this.blockEntity.computerBehaviour::hasAttachedComputer));
        }
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        this.renderAdditional(graphics, mouseX, mouseY, partialTicks, x, y, this.background);
    }

    private void renderAdditional(class_332 graphics, int mouseX, int mouseY, float partialTicks, int guiLeft, int guiTop, AllGuiTextures background) {
        class_4587 ms = graphics.method_51448();
        ms.method_22903();
        TransformStack msr = TransformStack.cast((class_4587)ms);
        ((TransformStack)((TransformStack)((TransformStack)((TransformStack)msr.pushPose()).translate((double)(guiLeft + background.width + 4), (double)(guiTop + background.height + 4), 100.0)).scale(40.0f)).rotateX(-22.0)).rotateY(63.0);
        GuiGameElement.of((class_2680)this.blockEntity.method_11010().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false))).render(graphics);
        if (this.blockEntity.resolveFlagAngle()) {
            msr.translate(0.0625, -1.1875, -0.75);
            StationRenderer.transformFlag(msr, this.blockEntity, partialTicks, 180, false);
            GuiGameElement.of(this.getFlag(partialTicks)).render(graphics);
        }
        ms.method_22909();
    }

    protected abstract PartialModel getFlag(float var1);

    protected Train getImminent() {
        return this.blockEntity.imminentTrain == null ? null : CreateClient.RAILWAYS.trains.get(this.blockEntity.imminentTrain);
    }

    protected boolean trainPresent() {
        return this.blockEntity.trainPresent;
    }
}

