/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import com.simibubi.create.AllTags;
import com.simibubi.create.compat.Mods;
import com.simibubi.create.compat.dynamictrees.DynamicTree;
import com.simibubi.create.foundation.utility.AbstractBlockBreakQueue;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2211;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2266;
import net.minecraft.class_2279;
import net.minecraft.class_2283;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2391;
import net.minecraft.class_2393;
import net.minecraft.class_2397;
import net.minecraft.class_2523;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3481;

public class TreeCutter {
    public static final Tree NO_TREE = new Tree(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());

    public static boolean canDynamicTreeCutFrom(class_2248 startBlock) {
        return Mods.DYNAMICTREES.runIfInstalled(() -> () -> DynamicTree.isDynamicBranch(startBlock)).orElse(false);
    }

    @Nonnull
    public static Optional<AbstractBlockBreakQueue> findDynamicTree(class_2248 startBlock, class_2338 pos) {
        if (TreeCutter.canDynamicTreeCutFrom(startBlock)) {
            return Mods.DYNAMICTREES.runIfInstalled(() -> () -> new DynamicTree(pos));
        }
        return Optional.empty();
    }

    @Nonnull
    public static Tree findTree(@Nullable class_1922 reader, class_2338 pos) {
        class_2680 currentState;
        class_2338 currentPos2;
        if (reader == null) {
            return NO_TREE;
        }
        ArrayList<class_2338> logs = new ArrayList<class_2338>();
        ArrayList<class_2338> leaves = new ArrayList<class_2338>();
        ArrayList<class_2338> attachments = new ArrayList<class_2338>();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        LinkedList<class_2338> frontier = new LinkedList<class_2338>();
        class_2680 stateAbove = reader.method_8320(pos.method_10084());
        if (TreeCutter.isVerticalPlant(stateAbove)) {
            class_2338 current;
            logs.add(pos.method_10084());
            for (int i = 1; i < 256 && TreeCutter.isVerticalPlant(reader.method_8320(current = pos.method_10086(i))); ++i) {
                logs.add(current);
            }
            Collections.reverse(logs);
            return new Tree(logs, leaves, attachments);
        }
        if (TreeCutter.isChorus(stateAbove)) {
            frontier.add(pos.method_10084());
            while (!frontier.isEmpty()) {
                class_2338 current = (class_2338)frontier.remove(0);
                visited.add(current);
                logs.add(current);
                for (class_2350 direction : Iterate.directions) {
                    class_2338 offset = current.method_10093(direction);
                    if (visited.contains(offset) || !TreeCutter.isChorus(reader.method_8320(offset))) continue;
                    frontier.add(offset);
                }
            }
            Collections.reverse(logs);
            return new Tree(logs, leaves, attachments);
        }
        if (!TreeCutter.validateCut(reader, pos)) {
            return NO_TREE;
        }
        visited.add(pos);
        class_2338.method_20437((class_2338)pos.method_10069(-1, 0, -1), (class_2338)pos.method_10069(1, 1, 1)).forEach(p -> frontier.add(new class_2338((class_2382)p)));
        boolean hasRoots = false;
        while (!frontier.isEmpty()) {
            currentPos2 = (class_2338)frontier.remove(0);
            if (!visited.add(currentPos2)) continue;
            currentState = reader.method_8320(currentPos2);
            if (TreeCutter.isRoot(currentState)) {
                hasRoots = true;
            } else if (!TreeCutter.isLog(currentState)) continue;
            logs.add(currentPos2);
            TreeCutter.forNeighbours(currentPos2, visited, SearchDirection.UP, p -> frontier.add(new class_2338((class_2382)p)));
        }
        visited.clear();
        visited.addAll(logs);
        frontier.addAll(logs);
        if (hasRoots) {
            while (!frontier.isEmpty()) {
                currentPos2 = (class_2338)frontier.remove(0);
                if (!logs.contains(currentPos2) && !visited.add(currentPos2) || !TreeCutter.isRoot(currentState = reader.method_8320(currentPos2))) continue;
                logs.add(currentPos2);
                TreeCutter.forNeighbours(currentPos2, visited, SearchDirection.DOWN, p -> frontier.add(new class_2338((class_2382)p)));
            }
            visited.clear();
            visited.addAll(logs);
            frontier.addAll(logs);
        }
        while (!frontier.isEmpty()) {
            class_2338 prevPos = (class_2338)frontier.remove(0);
            if (!logs.contains(prevPos) && !visited.add(prevPos)) continue;
            class_2680 prevState = reader.method_8320(prevPos);
            int prevLeafDistance = TreeCutter.isLeaf(prevState) ? TreeCutter.getLeafDistance(prevState) : 0;
            TreeCutter.forNeighbours(prevPos, visited, SearchDirection.BOTH, currentPos -> {
                class_2680 state = reader.method_8320(currentPos);
                class_2338 subtract = currentPos.method_10059((class_2382)pos);
                class_2338 currentPosImmutable = currentPos.method_10062();
                if (AllTags.AllBlockTags.TREE_ATTACHMENTS.matches(state)) {
                    attachments.add(currentPosImmutable);
                    visited.add(currentPosImmutable);
                    return;
                }
                int horizontalDistance = Math.max(Math.abs(subtract.method_10263()), Math.abs(subtract.method_10260()));
                if (horizontalDistance <= TreeCutter.nonDecayingLeafDistance(state)) {
                    leaves.add(currentPosImmutable);
                    frontier.add(currentPosImmutable);
                    return;
                }
                if (TreeCutter.isLeaf(state) && TreeCutter.getLeafDistance(state) > prevLeafDistance) {
                    leaves.add(currentPosImmutable);
                    frontier.add(currentPosImmutable);
                    return;
                }
            });
        }
        return new Tree(logs, leaves, attachments);
    }

    private static int getLeafDistance(class_2680 state) {
        class_2758 distanceProperty = class_2397.field_11199;
        for (class_2769 property : state.method_11656().keySet()) {
            if (!(property instanceof class_2758)) continue;
            class_2758 ip = (class_2758)property;
            if (!property.method_11899().equals("distance")) continue;
            distanceProperty = ip;
        }
        return (Integer)state.method_11654((class_2769)distanceProperty);
    }

    public static boolean isChorus(class_2680 stateAbove) {
        return stateAbove.method_26204() instanceof class_2283 || stateAbove.method_26204() instanceof class_2279;
    }

    public static boolean isVerticalPlant(class_2680 stateAbove) {
        class_2248 block = stateAbove.method_26204();
        if (block instanceof class_2211) {
            return true;
        }
        if (block instanceof class_2266) {
            return true;
        }
        if (block instanceof class_2523) {
            return true;
        }
        if (block instanceof class_2391) {
            return true;
        }
        return block instanceof class_2393;
    }

    private static boolean validateCut(class_1922 reader, class_2338 pos) {
        HashSet<class_2338> visited = new HashSet<class_2338>();
        LinkedList<class_2338> frontier = new LinkedList<class_2338>();
        frontier.add(pos);
        frontier.add(pos.method_10084());
        int posY = pos.method_10264();
        while (!frontier.isEmpty()) {
            class_2338 currentPos = (class_2338)frontier.remove(0);
            class_2338 belowPos = currentPos.method_10074();
            visited.add(currentPos);
            boolean lowerLayer = currentPos.method_10264() == posY;
            class_2680 currentState = reader.method_8320(currentPos);
            class_2680 belowState = reader.method_8320(belowPos);
            if (!TreeCutter.isLog(currentState) && !TreeCutter.isRoot(currentState)) continue;
            if (!lowerLayer && !pos.equals((Object)belowPos) && (TreeCutter.isLog(belowState) || TreeCutter.isRoot(belowState))) {
                return false;
            }
            for (class_2350 direction : Iterate.directions) {
                class_2338 offset;
                if (direction == class_2350.field_11033 || direction == class_2350.field_11036 && !lowerLayer || visited.contains(offset = currentPos.method_10093(direction))) continue;
                frontier.add(offset);
            }
        }
        return true;
    }

    private static void forNeighbours(class_2338 pos, Set<class_2338> visited, SearchDirection direction, Consumer<class_2338> acceptor) {
        class_2338.method_20437((class_2338)pos.method_10069(-1, direction.minY, -1), (class_2338)pos.method_10069(1, direction.maxY, 1)).filter(((Predicate<class_2338>)visited::contains).negate()).forEach(acceptor);
    }

    public static boolean isRoot(class_2680 state) {
        return state.method_27852(class_2246.field_37546);
    }

    public static boolean isLog(class_2680 state) {
        return state.method_26164(class_3481.field_15475) || AllTags.AllBlockTags.SLIMY_LOGS.matches(state) || state.method_27852(class_2246.field_10556);
    }

    private static int nonDecayingLeafDistance(class_2680 state) {
        if (state.method_27852(class_2246.field_10240)) {
            return 2;
        }
        if (state.method_27852(class_2246.field_10580)) {
            return 3;
        }
        if (state.method_26164(class_3481.field_21954) || state.method_27852(class_2246.field_22123) || state.method_27852(class_2246.field_22124)) {
            return 3;
        }
        return -1;
    }

    private static boolean isLeaf(class_2680 state) {
        for (class_2769 property : state.method_11656().keySet()) {
            if (!(property instanceof class_2758) || !property.method_11899().equals("distance")) continue;
            return true;
        }
        return false;
    }

    public static class Tree
    extends AbstractBlockBreakQueue {
        private final List<class_2338> logs;
        private final List<class_2338> leaves;
        private final List<class_2338> attachments;

        public Tree(List<class_2338> logs, List<class_2338> leaves, List<class_2338> attachments) {
            this.logs = logs;
            this.leaves = leaves;
            this.attachments = attachments;
        }

        @Override
        public void destroyBlocks(class_1937 world, class_1799 toDamage, @Nullable class_1657 playerEntity, BiConsumer<class_2338, class_1799> drop) {
            this.attachments.forEach(this.makeCallbackFor(world, 0.03125f, toDamage, playerEntity, drop));
            this.logs.forEach(this.makeCallbackFor(world, 0.5f, toDamage, playerEntity, drop));
            this.leaves.forEach(this.makeCallbackFor(world, 0.125f, toDamage, playerEntity, drop));
        }
    }

    private static enum SearchDirection {
        UP(0, 1),
        DOWN(-1, 0),
        BOTH(-1, 1);

        int minY;
        int maxY;

        private SearchDirection(int minY, int maxY) {
            this.minY = minY;
            this.maxY = maxY;
        }
    }
}

