/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.mod;

import info.journeymap.shaded.org.jetbrains.annotations.Nullable;
import java.lang.reflect.Method;
import java.util.Collection;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.util.ObfHelper;
import net.minecraft.class_2680;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import org.apache.logging.log4j.Logger;

public class ModPropertyEnum<T> {
    private static final Logger logger = Journeymap.getLogger();
    private final boolean valid;
    private final class_2754 propertyEnum;
    private final Method method;

    public ModPropertyEnum(class_2754 propertyEnum, Method method, Class<T> returnType) {
        this.valid = propertyEnum != null && method != null;
        this.propertyEnum = propertyEnum;
        this.method = method;
    }

    public ModPropertyEnum(class_2754 propertyEnum, String methodName, Class<T> returnType, Class<?>[] methodArgTypes) {
        this(propertyEnum, ModPropertyEnum.lookupMethod(propertyEnum, methodName, (Class[])methodArgTypes), returnType);
    }

    public ModPropertyEnum(String declaringClassName, String propertyEnumStaticFieldName, String methodName, Class<T> returnType) {
        this(declaringClassName, propertyEnumStaticFieldName, methodName, returnType, new Class[0]);
    }

    public ModPropertyEnum(String declaringClassName, String propertyEnumStaticFieldName, String methodName, Class<T> returnType, Class<?>[] methodArgTypes) {
        this(ModPropertyEnum.lookupPropertyEnum(declaringClassName, propertyEnumStaticFieldName), methodName, returnType, methodArgTypes);
    }

    public ModPropertyEnum(String declaringClassName, String propertyEnumStaticFieldName, Method method, Class<T> returnType) {
        this(ModPropertyEnum.lookupPropertyEnum(declaringClassName, propertyEnumStaticFieldName), method, returnType);
    }

    public static class_2754 lookupPropertyEnum(String declaringClassName, String propertyEnumStaticFieldName) {
        try {
            Class<?> declaringClass = Class.forName(declaringClassName);
            return (class_2754)ObfHelper.findField(declaringClass, propertyEnumStaticFieldName).get(declaringClass);
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error reflecting PropertyEnum on %s.%s: %s", (Object)declaringClassName, (Object)propertyEnumStaticFieldName, (Object)LogFormatter.toPartialString(e));
            return null;
        }
    }

    public static Method lookupMethod(class_2754 propertyEnum, String methodName, Class ... methodArgTypes) {
        if (propertyEnum != null) {
            return ModPropertyEnum.lookupMethod(propertyEnum.method_11902().getName(), methodName, methodArgTypes);
        }
        return null;
    }

    public static Method lookupMethod(String declaringClassName, String methodName, Class ... methodArgTypes) {
        try {
            Class<?> declaringClass = Class.forName(declaringClassName);
            return ObfHelper.findMethod(declaringClass, methodName, methodArgTypes);
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error reflecting method %s.%s(): %s", (Object)declaringClassName, (Object)methodName, (Object)LogFormatter.toPartialString(e));
            return null;
        }
    }

    public class_2754 getPropertyEnum() {
        return this.propertyEnum;
    }

    public boolean isValid() {
        return this.valid;
    }

    @Nullable
    public T getValue(class_2680 blockState, Object ... args2) {
        if (this.valid) {
            try {
                Comparable enumValue = blockState.method_11654((class_2769)this.propertyEnum);
                if (enumValue != null) {
                    return (T)this.method.invoke((Object)enumValue, args2);
                }
            }
            catch (Exception e) {
                logger.error("Error using mod PropertyEnum: " + LogFormatter.toPartialString(e));
            }
        }
        return null;
    }

    @Nullable
    public static <T> T getFirstValue(Collection<ModPropertyEnum<T>> modPropertyEnums, class_2680 blockState, Object ... args2) {
        for (ModPropertyEnum<T> modPropertyEnum : modPropertyEnums) {
            T result = modPropertyEnum.getValue(blockState, args2);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

