/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.util;

import info.journeymap.shaded.org.jetbrains.annotations.NotNull;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import journeymap.common.Journeymap;

public class ObfHelper {
    @NotNull
    public static <T> Field findField(@NotNull Class<? super T> declaringClass, String ... propertyEnumStaticFieldName) {
        for (String name : propertyEnumStaticFieldName) {
            Field f = ObfHelper.getFieldInternal(declaringClass, name);
            if (f == null) continue;
            return f;
        }
        throw new IllegalArgumentException("Could not find any of fields " + Arrays.toString(propertyEnumStaticFieldName) + " on class " + declaringClass);
    }

    public static Method findMethod(@NotNull Class<?> declaringClass, @NotNull String methodName, Class<?> ... methodArgTypes) {
        try {
            Method m = declaringClass.getDeclaredMethod(methodName, methodArgTypes);
            m.setAccessible(true);
            return m;
        }
        catch (NoSuchMethodException | SecurityException e) {
            Journeymap.getLogger().error("No Such Method in class {} : {} : {}", (Object)declaringClass.getName(), (Object)methodName, methodArgTypes);
            return null;
        }
    }

    private static Field getFieldInternal(Class<?> cls, String name) {
        try {
            Field f = cls.getDeclaredField(name);
            f.setAccessible(true);
            return f;
        }
        catch (NoSuchFieldException | SecurityException e) {
            return null;
        }
    }
}

