/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks.renderer;

import com.jesz.createdieselgenerators.PartialModels;
import com.jesz.createdieselgenerators.blocks.entity.DistillationTankBlockEntity;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public class DistillationTankRenderer
extends SafeBlockEntityRenderer<DistillationTankBlockEntity> {
    public DistillationTankRenderer(class_5614.class_5615 context) {
    }

    protected void renderSafe(DistillationTankBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        LerpedFloat fluidLevel;
        if (!be.isController()) {
            return;
        }
        if (be.isBottom()) {
            this.renderAsBoiler(be, partialTicks, ms, buffer, light, overlay);
        }
        if ((fluidLevel = be.getFluidLevel()) == null) {
            return;
        }
        float capHeight = 0.25f;
        float tankHullWidth = 0.0703125f;
        float minPuddleHeight = 0.0625f;
        float totalHeight = (float)be.getHeight() - 2.0f * capHeight - minPuddleHeight;
        float level = fluidLevel.getValue(partialTicks);
        if (level < 1.0f / (512.0f * totalHeight)) {
            return;
        }
        float clampedLevel = class_3532.method_15363((float)(level * totalHeight), (float)0.0f, (float)totalHeight);
        SmartFluidTank tank = be.tankInventory;
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        boolean top = FluidVariantAttributes.isLighterThanAir((FluidVariant)fluidStack.getType());
        float xMin = tankHullWidth;
        float xMax = xMin + (float)be.getWidth() - 2.0f * tankHullWidth;
        float yMin = totalHeight + capHeight + minPuddleHeight - clampedLevel;
        float yMax = yMin + clampedLevel;
        if (top) {
            yMin += totalHeight - clampedLevel;
            yMax += totalHeight - clampedLevel;
        }
        float zMin = tankHullWidth;
        float zMax = zMin + (float)be.getWidth() - 2.0f * tankHullWidth;
        ms.method_22903();
        ms.method_46416(0.0f, clampedLevel - totalHeight, 0.0f);
        FluidRenderer.renderFluidBox((FluidStack)fluidStack, (float)xMin, (float)yMin, (float)zMin, (float)xMax, (float)yMax, (float)zMax, (class_4597)buffer, (class_4587)ms, (int)light, (boolean)false);
        ms.method_22909();
    }

    protected void renderAsBoiler(DistillationTankBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        class_2680 blockState = be.method_11010();
        class_4588 vb = buffer.getBuffer(class_1921.method_23577());
        ms.method_22903();
        TransformStack msr = TransformStack.cast((class_4587)ms);
        msr.translate((double)((float)be.getWidth() / 2.0f), 0.5, (double)((float)be.getWidth() / 2.0f));
        float dialPivot = 0.359375f;
        float progress = class_3532.method_15363((float)be.progress, (float)0.0f, (float)1.0f);
        for (class_2350 d : Iterate.horizontalDirections) {
            ms.method_22903();
            ((SuperByteBuffer)((SuperByteBuffer)CachedBufferer.partial((PartialModel)PartialModels.DISTILLATION_GAUGE, (class_2680)blockState).rotateY((double)d.method_10144())).unCentre()).translate((double)((float)be.getWidth() / 2.0f - 0.375f), 0.0, 0.0).light(light).renderInto(ms, vb);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBufferer.partial((PartialModel)AllPartialModels.BOILER_GAUGE_DIAL, (class_2680)blockState).rotateY((double)d.method_10144())).unCentre()).translate((double)((float)be.getWidth() / 2.0f - 0.375f), 0.0, 0.0).translate(0.0, (double)dialPivot, (double)dialPivot).rotateX((double)(-90.0f * progress))).translate(0.0, (double)(-dialPivot), (double)(-dialPivot)).light(light).renderInto(ms, vb);
            ms.method_22909();
        }
        ms.method_22909();
    }

    public boolean shouldRenderOffScreen(DistillationTankBlockEntity be) {
        return be.isController();
    }
}

