/*
 * Decompiled with CFR 0.152.
 */
package com.mangomilk.design_decor.blocks.stepped_lever;

import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.transform.Rotate;
import com.jozufozu.flywheel.util.transform.Translate;
import com.mangomilk.design_decor.blocks.stepped_lever.SteppedLeverBlock;
import com.mangomilk.design_decor.blocks.stepped_lever.SteppedLeverBlockEntity;
import com.mangomilk.design_decor.registry.CDDPartialModels;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2738;
import net.minecraft.class_2769;

public class SteppedLeverInstance
extends BlockEntityInstance<SteppedLeverBlockEntity>
implements DynamicInstance {
    protected final ModelData handle;
    final float rX;
    final float rY;

    public SteppedLeverInstance(MaterialManager materialManager, SteppedLeverBlockEntity blockEntity) {
        super(materialManager, (class_2586)blockEntity);
        Material mat = this.getTransformMaterial();
        this.handle = (ModelData)mat.getModel(CDDPartialModels.STEPPED_LEVER_HANDLE, this.blockState).createInstance();
        class_2738 face = (class_2738)this.blockState.method_11654((class_2769)SteppedLeverBlock.field_11007);
        this.rX = face == class_2738.field_12475 ? 0.0f : (face == class_2738.field_12471 ? 90.0f : 180.0f);
        this.rY = AngleHelper.horizontalAngle((class_2350)((class_2350)this.blockState.method_11654((class_2769)SteppedLeverBlock.field_11177)));
        this.animateLever();
    }

    public void beginFrame() {
        if (!((SteppedLeverBlockEntity)this.blockEntity).clientState.settled()) {
            this.animateLever();
        }
    }

    protected void animateLever() {
        float state = ((SteppedLeverBlockEntity)this.blockEntity).clientState.getValue(AnimationTickHolder.getPartialTicks());
        float angle = (float)((double)(state / 15.0f * 90.0f / 180.0f) * Math.PI);
        ((ModelData)this.transform(this.handle.loadIdentity()).translate(0.5, 0.25, 0.5).rotate(class_2350.field_11034, angle)).translate(-0.5, -0.25, -0.5);
    }

    public void remove() {
        this.handle.delete();
    }

    public void updateLight() {
        this.relight(this.pos, new FlatLit[]{this.handle});
    }

    private <T extends Translate<T> & Rotate<T>> T transform(T msr) {
        return (T)((Translate)((Translate)((Rotate)((Translate)((Rotate)((Translate)((Translate)msr.translate((class_2382)this.getInstancePosition())).centre())).rotate(class_2350.field_11036, (float)((double)(this.rY / 180.0f) * Math.PI)))).rotate(class_2350.field_11034, (float)((double)(this.rX / 180.0f) * Math.PI))).unCentre());
    }
}

