/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.harvest;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3481;
import net.minecraft.class_4013;
import net.minecraft.class_5250;
import net.minecraft.class_6862;
import snownee.jade.addon.harvest.ShearsToolHandler;
import snownee.jade.addon.harvest.SimpleToolHandler;
import snownee.jade.addon.harvest.ToolHandler;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.ui.SubTextElement;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.CommonProxy;

public enum HarvestToolProvider implements IBlockComponentProvider,
class_4013
{
    INSTANCE;

    public static final Cache<class_2680, ImmutableList<class_1799>> resultCache;
    public static final Map<String, ToolHandler> TOOL_HANDLERS;
    private static final class_2561 CHECK;
    private static final class_2561 X;
    private static final class_241 ITEM_SIZE;

    public static ImmutableList<class_1799> getTool(class_2680 state, class_1937 world, class_2338 pos) {
        ImmutableList.Builder tools = ImmutableList.builder();
        for (ToolHandler handler : TOOL_HANDLERS.values()) {
            class_1799 tool = handler.test(state, world, pos);
            if (tool.method_7960()) continue;
            tools.add((Object)tool);
        }
        return tools.build();
    }

    public static synchronized void registerHandler(ToolHandler handler) {
        TOOL_HANDLERS.put(handler.getName(), handler);
    }

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        class_1657 player = accessor.getPlayer();
        if (!config.get(Identifiers.MC_HARVEST_TOOL_CREATIVE) && (player.method_7337() || player.method_7325())) {
            return;
        }
        class_2680 state = accessor.getBlockState();
        class_1937 level = accessor.getLevel();
        class_2338 pos = accessor.getPosition();
        float destroySpeed = state.method_26214((class_1922)level, pos);
        float destroyProgress = state.method_26165(player, (class_1922)level, pos);
        if (destroySpeed < 0.0f || destroyProgress <= 0.0f) {
            if (config.get(Identifiers.MC_SHOW_UNBREAKABLE)) {
                class_5250 text = IThemeHelper.get().failure(class_2561.method_43471((String)"jade.harvest_tool.unbreakable"));
                tooltip.add(IElementHelper.get().text((class_2561)text).message(null));
            }
            return;
        }
        boolean newLine = config.get(Identifiers.MC_HARVEST_TOOL_NEW_LINE);
        List<IElement> elements = this.getText(accessor, config);
        if (elements.isEmpty()) {
            return;
        }
        elements.forEach(e -> e.message(null));
        if (newLine) {
            tooltip.add(elements);
        } else {
            elements.forEach(e -> e.align(IElement.Align.RIGHT));
            tooltip.append(0, elements);
        }
    }

    public List<IElement> getText(BlockAccessor accessor, IPluginConfig config) {
        class_2680 state = accessor.getBlockState();
        if (!state.method_29291() && !config.get(Identifiers.MC_EFFECTIVE_TOOL)) {
            return List.of();
        }
        List tools = List.of();
        try {
            tools = (List)resultCache.get((Object)state, () -> HarvestToolProvider.getTool(state, accessor.getLevel(), accessor.getPosition()));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        if (tools.isEmpty()) {
            return List.of();
        }
        int offsetY = 0;
        if (!config.get(Identifiers.MC_HARVEST_TOOL_NEW_LINE)) {
            offsetY = -3;
        }
        ArrayList elements = Lists.newArrayList();
        for (class_1799 tool : tools) {
            elements.add(IElementHelper.get().item(tool, 0.75f).translate(new class_241(-1.0f, (float)offsetY)).size(ITEM_SIZE).message(null));
        }
        if (!elements.isEmpty()) {
            elements.add(0, IElementHelper.get().spacer(5, 0));
            class_1799 held = accessor.getPlayer().method_6047();
            boolean canHarvest = held.method_7951(state);
            if (CommonProxy.isShearable(state) && CommonProxy.isShears(held)) {
                canHarvest = true;
            }
            if (state.method_29291() || canHarvest) {
                IThemeHelper t = IThemeHelper.get();
                class_5250 text = canHarvest ? t.success(CHECK) : t.danger(X);
                elements.add(new SubTextElement((class_2561)text).translate(new class_241(-3.0f, (float)(7 + offsetY))));
            }
        }
        return elements;
    }

    public void method_14491(class_3300 resourceManager) {
        resultCache.invalidateAll();
    }

    @Override
    public class_2960 getUid() {
        return Identifiers.MC_HARVEST_TOOL;
    }

    @Override
    public int getDefaultPriority() {
        return -8000;
    }

    static {
        resultCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
        TOOL_HANDLERS = Maps.newLinkedHashMap();
        CHECK = class_2561.method_43470((String)"\u2714");
        X = class_2561.method_43470((String)"\u2715");
        ITEM_SIZE = new class_241(10.0f, 0.0f);
        if (CommonProxy.isPhysicallyClient()) {
            HarvestToolProvider.registerHandler(new SimpleToolHandler("pickaxe", (class_6862<class_2248>)class_3481.field_33715, class_1802.field_8647, class_1802.field_8387, class_1802.field_8403, class_1802.field_8377, class_1802.field_22024));
            HarvestToolProvider.registerHandler(new SimpleToolHandler("axe", (class_6862<class_2248>)class_3481.field_33713, class_1802.field_8406, class_1802.field_8062, class_1802.field_8475, class_1802.field_8556, class_1802.field_22025));
            HarvestToolProvider.registerHandler(new SimpleToolHandler("shovel", (class_6862<class_2248>)class_3481.field_33716, class_1802.field_8876, class_1802.field_8776, class_1802.field_8699, class_1802.field_8250, class_1802.field_22023));
            HarvestToolProvider.registerHandler(new SimpleToolHandler("hoe", (class_6862<class_2248>)class_3481.field_33714, class_1802.field_8167, class_1802.field_8431, class_1802.field_8609, class_1802.field_8527, class_1802.field_22026));
            HarvestToolProvider.registerHandler(ClientProxy.createSwordToolHandler());
            HarvestToolProvider.registerHandler(new ShearsToolHandler());
        }
    }
}

