/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import net.minecraft.class_1074;
import net.minecraft.class_241;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Identifiers;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.Element;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.IconUI;

public class ArmorElement
extends Element {
    private final float armor;

    public ArmorElement(float armor) {
        if (!PluginConfig.INSTANCE.get(Identifiers.MC_ENTITY_HEALTH_SHOW_FRACTIONS)) {
            armor = class_3532.method_15386((float)armor);
        }
        this.armor = armor;
    }

    @Override
    public class_241 getSize() {
        if (this.armor > (float)PluginConfig.INSTANCE.getInt(Identifiers.MC_ENTITY_ARMOR_MAX_FOR_RENDER)) {
            String text = "  " + DisplayHelper.dfCommas.format(this.armor);
            class_327 font = class_310.method_1551().field_1772;
            return new class_241((float)(8 + font.method_1727(text)), 10.0f);
        }
        int maxHearts = PluginConfig.INSTANCE.getInt(Identifiers.MC_ENTITY_HEALTH_ICONS_PER_LINE);
        int lineCount = (int)Math.ceil(this.armor / (float)maxHearts * 0.5f);
        return new class_241((float)(8 * maxHearts), (float)(10 * lineCount));
    }

    @Override
    public void render(class_332 guiGraphics, float x, float y, float maxX, float maxY) {
        if (this.armor > (float)PluginConfig.INSTANCE.getInt(Identifiers.MC_ENTITY_ARMOR_MAX_FOR_RENDER)) {
            DisplayHelper.renderIcon(guiGraphics, x, y, 8, 8, IconUI.ARMOR);
            String text = "  " + DisplayHelper.dfCommas.format(this.armor);
            DisplayHelper.INSTANCE.drawText(guiGraphics, text, x + 8.0f, y, IThemeHelper.get().getNormalColor());
        } else {
            float armor = this.armor * 0.5f;
            int maxHearts = PluginConfig.INSTANCE.getInt(Identifiers.MC_ENTITY_HEALTH_ICONS_PER_LINE);
            int lineCount = (int)Math.ceil(armor / (float)maxHearts);
            int armorCount = lineCount * maxHearts;
            int xOffset = 0;
            for (int i = 1; i <= armorCount; ++i) {
                if (i <= class_3532.method_15375((float)armor)) {
                    DisplayHelper.renderIcon(guiGraphics, x + (float)xOffset, y, 8, 8, IconUI.ARMOR);
                    xOffset += 8;
                }
                if ((float)i > armor && (float)i < armor + 1.0f) {
                    DisplayHelper.renderIcon(guiGraphics, x + (float)xOffset, y, 8, 8, IconUI.HALF_ARMOR);
                    xOffset += 8;
                }
                if ((float)i >= armor + 1.0f) {
                    DisplayHelper.renderIcon(guiGraphics, x + (float)xOffset, y, 8, 8, IconUI.EMPTY_ARMOR);
                    xOffset += 8;
                }
                if (i % maxHearts != 0) continue;
                y += 10.0f;
                xOffset = 0;
            }
        }
    }

    @Override
    @Nullable
    public String getMessage() {
        return class_1074.method_4662((String)"narration.jade.armor", (Object[])new Object[]{DisplayHelper.dfCommas.format(this.armor)});
    }
}

