/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.capability.data;

import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import fuzs.puzzleslib.api.capability.v2.data.CapabilityComponent;
import fuzs.puzzleslib.api.capability.v2.data.PlayerCapabilityKey;
import fuzs.puzzleslib.api.capability.v2.data.SyncStrategy;
import fuzs.puzzleslib.impl.capability.data.ComponentHolder;
import fuzs.puzzleslib.impl.capability.data.FabricCapabilityKey;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.networking.v1.EntityTrackingEvents;
import net.minecraft.class_1297;
import net.minecraft.class_3222;

public class FabricPlayerCapabilityKey<C extends CapabilityComponent>
extends FabricCapabilityKey<C>
implements PlayerCapabilityKey<C> {
    private SyncStrategy syncStrategy = SyncStrategy.MANUAL;

    public FabricPlayerCapabilityKey(ComponentKey<ComponentHolder> capability, Class<C> componentClass) {
        super(capability, componentClass);
    }

    public FabricPlayerCapabilityKey<C> setSyncStrategy(SyncStrategy syncStrategy) {
        if (this.syncStrategy != SyncStrategy.MANUAL) {
            throw new IllegalStateException("Attempting to set new sync behaviour when it has already been set");
        }
        this.syncStrategy = syncStrategy;
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> this.maybeGet(entity).ifPresent(capability -> PlayerCapabilityKey.syncCapabilityToRemote(entity, (class_3222)entity, this.syncStrategy, capability, this.getId(), true)));
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> this.maybeGet(player).ifPresent(capability -> PlayerCapabilityKey.syncCapabilityToRemote((class_1297)player, player, this.syncStrategy, capability, this.getId(), true)));
        if (syncStrategy == SyncStrategy.SELF_AND_TRACKING) {
            EntityTrackingEvents.START_TRACKING.register((trackedEntity, player) -> this.maybeGet(trackedEntity).ifPresent(capability -> PlayerCapabilityKey.syncCapabilityToRemote(trackedEntity, player, SyncStrategy.SELF, capability, this.getId(), true)));
        }
        return this;
    }

    @Override
    public void syncToRemote(class_3222 player) {
        PlayerCapabilityKey.syncCapabilityToRemote((class_1297)player, player, this.syncStrategy, this.orThrow(player), this.getId(), false);
    }
}

