/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.network;

import com.google.common.collect.Lists;
import fuzs.puzzleslib.api.network.v3.NetworkHandlerV3;
import java.util.List;
import net.minecraft.class_2960;

public abstract class NetworkHandlerRegistryImpl
implements NetworkHandlerV3.Builder {
    final class_2960 channelIdentifier;
    private final List<Class<?>> clientboundMessages = Lists.newArrayList();
    private final List<Class<?>> serverboundMessages = Lists.newArrayList();
    public boolean clientAcceptsVanillaOrMissing;
    public boolean serverAcceptsVanillaOrMissing;

    NetworkHandlerRegistryImpl(class_2960 channelIdentifier) {
        this.channelIdentifier = channelIdentifier;
    }

    @Override
    public <T extends Record> NetworkHandlerV3.Builder registerClientbound(Class<T> clazz) {
        if (this.clientboundMessages.contains(clazz)) {
            throw new IllegalStateException("Duplicate message of type %s".formatted(clazz));
        }
        this.clientboundMessages.add(clazz);
        return this;
    }

    @Override
    public <T extends Record> NetworkHandlerV3.Builder registerServerbound(Class<T> clazz) {
        if (this.serverboundMessages.contains(clazz)) {
            throw new IllegalStateException("Duplicate message of type %s".formatted(clazz));
        }
        this.serverboundMessages.add(clazz);
        return this;
    }

    @Override
    public NetworkHandlerV3.Builder clientAcceptsVanillaOrMissing() {
        this.clientAcceptsVanillaOrMissing = true;
        return this;
    }

    @Override
    public NetworkHandlerV3.Builder serverAcceptsVanillaOrMissing() {
        this.serverAcceptsVanillaOrMissing = true;
        return this;
    }

    @Override
    public void build() {
        for (Class<?> message : this.clientboundMessages) {
            this.registerClientbound$Internal(message);
        }
        for (Class<?> message : this.serverboundMessages) {
            this.registerServerbound$Internal(message);
        }
        this.clientboundMessages.clear();
        this.serverboundMessages.clear();
    }

    abstract <T extends Record> void registerClientbound$Internal(Class<?> var1);

    abstract <T extends Record> void registerServerbound$Internal(Class<?> var1);
}

