/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.backend;

import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.NBTHelper;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.bank.BankMenu;
import dev.ithundxr.createnumismatics.content.coins.LinkedMergingCoinBag;
import dev.ithundxr.createnumismatics.content.coins.MergingCoinBag;
import dev.ithundxr.createnumismatics.multiloader.PlayerSelection;
import dev.ithundxr.createnumismatics.multiloader.S2CPacket;
import dev.ithundxr.createnumismatics.registry.NumismaticsMenuTypes;
import dev.ithundxr.createnumismatics.registry.NumismaticsPackets;
import dev.ithundxr.createnumismatics.registry.packets.BankAccountLabelPacket;
import dev.ithundxr.createnumismatics.util.UsernameUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3917;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BankAccount
implements class_3908 {
    public final UUID id;
    public final Type type;
    private int balance;
    @Nullable
    private List<UUID> trustList;
    @Nullable
    private String label;
    public final MergingCoinBag linkedCoinBag = new BankAccountCoinBag();
    private final boolean clientSide;
    public final class_3913 dataAccess = new class_3913(){

        public int method_17390(int index) {
            return BankAccount.this.balance;
        }

        public void method_17391(int index, int value) {
            if (BankAccount.this.clientSide) {
                BankAccount.this.setBalance(value);
            }
        }

        public int method_17389() {
            return 1;
        }
    };

    public BankAccount(UUID id, Type type) {
        this(id, 0, type);
    }

    public BankAccount(UUID id, int balance, Type type) {
        this(id, type, balance, false);
    }

    protected BankAccount(UUID id, Type type, int balance, boolean clientSide) {
        this.id = id;
        this.type = type;
        this.balance = balance;
        this.clientSide = clientSide;
        if (type.useTrustList && !clientSide) {
            this.trustList = new ArrayList<UUID>();
        }
    }

    public static BankAccount clientSide(class_2540 buf) {
        return new BankAccount(buf.method_10790(), Type.read(buf), buf.method_10816(), true);
    }

    public int getBalance() {
        return this.balance;
    }

    public void setBalance(int balance) {
        if (balance == this.balance) {
            return;
        }
        if (balance < 0) {
            Numismatics.crashDev("Balance cannot be negative! (Account: " + this + ")");
        }
        this.balance = balance;
        this.markDirty();
    }

    public void deposit(Coin coin, int count) {
        this.deposit(coin.toSpurs(count));
    }

    public void deposit(int amount) {
        if (amount < 0) {
            Numismatics.crashDev("Cannot add negative amount to balance! (Account: " + this + ")");
            return;
        }
        this.setBalance(this.getBalance() + amount);
    }

    public boolean deduct(Coin coin, int amount) {
        return this.deduct(coin, amount, false);
    }

    public boolean deduct(int amount) {
        return this.deduct(amount, false);
    }

    public boolean deduct(Coin coin, int amount, boolean force) {
        return this.deduct(coin.toSpurs(amount), force);
    }

    public boolean deduct(int amount, boolean force) {
        if (amount < 0) {
            Numismatics.crashDev("Cannot remove negative amount from balance! (Account: " + this + ")");
            return false;
        }
        if (this.getBalance() < amount) {
            if (force) {
                this.setBalance(0);
            }
            return false;
        }
        this.setBalance(this.getBalance() - amount);
        return true;
    }

    public String toString() {
        return super.toString() + " {id=" + this.id + ", balance=" + this.balance + ", clientside=" + this.clientSide + "}";
    }

    public static BankAccount create(Type type) {
        return new BankAccount(UUID.randomUUID(), type);
    }

    public static BankAccount load(class_2487 nbt) {
        if (!nbt.method_25928("id")) {
            Numismatics.LOGGER.error("Account found without ID, deleting");
            return null;
        }
        BankAccount account = new BankAccount(nbt.method_25926("id"), Type.read(nbt));
        account.balance = nbt.method_10550("balance");
        if (account.trustList != null && nbt.method_10545("TrustList")) {
            account.trustList.clear();
            account.trustList.addAll(NBTHelper.readCompoundList((class_2499)nbt.method_10554("TrustList", 10), tag -> tag.method_25926("UUID")));
        }
        if (account.type.hasLabel && nbt.method_10573("Label", 8)) {
            account.label = nbt.method_10558("Label");
        }
        return account;
    }

    public class_2487 save(class_2487 nbt) {
        nbt.method_25927("id", this.id);
        this.type.write(nbt);
        nbt.method_10569("balance", this.balance);
        if (this.type.useTrustList && this.trustList != null) {
            this.trustList = this.trustList.stream().filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
            nbt.method_10566("TrustList", (class_2520)NBTHelper.writeCompoundList(this.trustList, uuid -> {
                class_2487 tag = new class_2487();
                tag.method_25927("UUID", uuid);
                return tag;
            }));
        }
        if (this.type.hasLabel && this.label != null) {
            nbt.method_10582("Label", this.label);
        }
        return nbt;
    }

    public void markDirty() {
        if (!this.clientSide) {
            Numismatics.BANK.markBankDirty();
        }
    }

    @Nullable
    public String getLabel() {
        return this.type.hasLabel ? this.label : null;
    }

    public void setLabel(@Nullable String label) {
        if (this.type.hasLabel) {
            if (this.label != null && this.label.equals(label)) {
                return;
            }
            this.label = label;
            this.markDirty();
            NumismaticsPackets.PACKETS.sendTo(PlayerSelection.all(), (S2CPacket)new BankAccountLabelPacket(this));
        }
    }

    @NotNull
    public class_2561 method_5476() {
        if (this.getLabel() != null) {
            return Components.literal((String)this.getLabel());
        }
        String name = UsernameUtils.INSTANCE.getName(this.id, null);
        if (name != null) {
            return Components.literal((String)name);
        }
        return Components.translatable((String)"block.numismatics.bank_terminal");
    }

    @Nullable
    public class_1703 createMenu(int i, @NotNull class_1661 inventory, @NotNull class_1657 player) {
        return new BankMenu((class_3917)NumismaticsMenuTypes.BANK.get(), i, inventory, this, this.dataAccess);
    }

    public void sendToMenu(class_2540 buf) {
        buf.method_10797(this.id);
        this.type.write(buf);
        buf.method_10804(this.balance);
    }

    public boolean isClientSide() {
        return this.clientSide;
    }

    public boolean isAuthorized(class_1657 player) {
        return this.isAuthorized(player.method_5667());
    }

    public boolean isAuthorized(@Nullable UUID uuid) {
        if (uuid == null) {
            return false;
        }
        return uuid.equals(this.id) || this.type.useTrustList && this.trustList != null && this.trustList.contains(uuid);
    }

    public void updateTrustList(Consumer<List<UUID>> updater) {
        if (this.trustList != null) {
            updater.accept(this.trustList);
            this.markDirty();
        }
    }

    public static enum Type {
        PLAYER(false, false),
        BLAZE_BANKER(true, true);

        public final boolean useTrustList;
        public final boolean hasLabel;

        private Type(boolean useTrustList, boolean hasLabel) {
            this.useTrustList = useTrustList;
            this.hasLabel = hasLabel;
        }

        public static Type read(class_2540 buf) {
            return Type.values()[buf.readInt()];
        }

        public static Type read(class_2487 nbt) {
            String name = nbt.method_10558("AccountType");
            try {
                return Type.valueOf(name.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                return PLAYER;
            }
        }

        public void write(class_2540 buf) {
            buf.writeInt(this.ordinal());
        }

        public void write(class_2487 nbt) {
            nbt.method_10582("AccountType", this.name());
        }
    }

    private class BankAccountCoinBag
    extends LinkedMergingCoinBag {
        private BankAccountCoinBag() {
        }

        @Override
        protected int getDelegate() {
            return BankAccount.this.getBalance();
        }

        @Override
        protected void setDelegate(int value) {
            BankAccount.this.setBalance(value);
        }
    }
}

