/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.bank.blaze_banker;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.BankAccount;
import java.util.UUID;
import net.minecraft.class_2487;

public class BankAccountBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<BankAccountBehaviour> TYPE = new BehaviourType();
    private UUID accountUUID;

    public BankAccountBehaviour(SmartBlockEntity be) {
        super(be);
    }

    public UUID getAccountUUID() {
        if (this.accountUUID == null) {
            this.accountUUID = UUID.randomUUID();
            this.blockEntity.notifyUpdate();
        }
        return this.accountUUID;
    }

    public BankAccount getAccount() {
        return Numismatics.BANK.getOrCreateAccount(this.getAccountUUID(), BankAccount.Type.BLAZE_BANKER);
    }

    public boolean hasAccount() {
        if (this.accountUUID == null) {
            return false;
        }
        return Numismatics.BANK.getAccount(this.accountUUID) != null;
    }

    public void read(class_2487 nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        if (nbt.method_25928("accountUUID")) {
            this.accountUUID = nbt.method_25926("accountUUID");
        }
    }

    public void write(class_2487 nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        if (this.accountUUID != null) {
            nbt.method_25927("accountUUID", this.accountUUID);
        }
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void destroy() {
        super.destroy();
        BankAccount oldAccount = Numismatics.BANK.accounts.remove(this.accountUUID);
        if (oldAccount != null) {
            oldAccount.setLabel(null);
        }
        Numismatics.BANK.markBankDirty();
    }
}

