/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.bank.blaze_banker;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.BankAccount;
import dev.ithundxr.createnumismatics.content.backend.Trusted;
import dev.ithundxr.createnumismatics.content.backend.trust_list.TrustListContainer;
import dev.ithundxr.createnumismatics.content.backend.trust_list.TrustListHolder;
import dev.ithundxr.createnumismatics.content.bank.blaze_banker.BankAccountBehaviour;
import dev.ithundxr.createnumismatics.content.bank.blaze_banker.BlazeBankerMenu;
import dev.ithundxr.createnumismatics.content.bank.blaze_banker.BlazeBankerScreen;
import dev.ithundxr.createnumismatics.registry.NumismaticsMenuTypes;
import dev.ithundxr.createnumismatics.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_5819;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlazeBankerBlockEntity
extends SmartBlockEntity
implements Trusted,
TrustListHolder,
class_3908 {
    protected LerpedFloat headAnimation;
    protected LerpedFloat headAngle;
    private int clientsideBalance = 0;
    private int lastSentBalance = 0;
    protected BankAccountBehaviour bankAccountBehaviour;
    @Nullable
    protected UUID owner;
    @Nullable
    protected String label;
    protected final List<UUID> trustList = new ArrayList<UUID>();
    public final TrustListContainer trustListContainer = new TrustListContainer(this.trustList, this::onTrustListChanged);
    private boolean delayedDataSync = false;

    public String getLabel() {
        if (this.label != null && this.label.isEmpty()) {
            this.label = null;
        }
        return this.label;
    }

    public void setLabel(String label) {
        if (label.isEmpty()) {
            label = null;
        }
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.getAccount().setLabel(label);
        }
        this.label = label;
        this.notifyUpdate();
    }

    public BlazeBankerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.headAnimation = LerpedFloat.linear();
        this.headAngle = LerpedFloat.angular();
    }

    @Environment(value=EnvType.CLIENT)
    private void tickAnimation() {
        boolean active = class_310.method_1551().field_1755 instanceof BlazeBankerScreen;
        float target = 0.0f;
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && !player.method_5767()) {
            double z;
            double x;
            if (this.isVirtual()) {
                x = -4.0;
                z = -10.0;
            } else {
                x = player.method_23317();
                z = player.method_23321();
            }
            double dx = x - ((double)this.method_11016().method_10263() + 0.5);
            double dz = z - ((double)this.method_11016().method_10260() + 0.5);
            target = AngleHelper.deg((double)(-class_3532.method_15349((double)dz, (double)dx))) - 90.0f;
        }
        target = this.headAngle.getValue() + AngleHelper.getShortestAngleDiff((double)this.headAngle.getValue(), (double)target);
        this.headAngle.chase((double)target, 0.25, LerpedFloat.Chaser.exp((double)5.0));
        this.headAngle.tickChaser();
        this.headAnimation.chase(active ? 1.0 : 0.0, 0.25, LerpedFloat.Chaser.exp((double)0.25));
        this.headAnimation.tickChaser();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.bankAccountBehaviour = new BankAccountBehaviour(this);
        behaviours.add(this.bankAccountBehaviour);
    }

    private void onTrustListChanged() {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        BankAccount account = this.getAccount();
        account.updateTrustList(accountTrustList -> {
            accountTrustList.clear();
            accountTrustList.add(this.owner);
            accountTrustList.addAll(this.trustList);
        });
        this.notifyUpdate();
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        if (this.delayedDataSync) {
            this.delayedDataSync = false;
            this.sendData();
        }
        if (this.owner != null && !this.getAccount().isAuthorized(this.owner)) {
            this.onTrustListChanged();
        }
        if (this.lastSentBalance != this.getAccount().getBalance()) {
            this.lastSentBalance = this.getAccount().getBalance();
            this.sendData();
        }
    }

    public void tick() {
        super.tick();
        if (this.field_11863 != null && this.field_11863.field_9236) {
            this.tickAnimation();
            if (!this.isVirtual()) {
                this.spawnParticles(BlazeBurnerBlock.HeatLevel.KINDLED, 1.0);
            }
            return;
        }
    }

    protected void spawnParticles(BlazeBurnerBlock.HeatLevel heatLevel, double burstMult) {
        if (this.field_11863 == null) {
            return;
        }
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        class_5819 r = this.field_11863.method_8409();
        class_243 c = VecHelper.getCenterOf((class_2382)this.field_11867);
        class_243 v = c.method_1019(VecHelper.offsetRandomly((class_243)class_243.field_1353, (class_5819)r, (float)0.125f).method_18805(1.0, 0.0, 1.0));
        if (r.method_43048(4) != 0) {
            return;
        }
        boolean empty = this.field_11863.method_8320(this.field_11867.method_10084()).method_26220((class_1922)this.field_11863, this.field_11867.method_10084()).method_1110();
        if (empty || r.method_43048(8) == 0) {
            this.field_11863.method_8406((class_2394)class_2398.field_11237, v.field_1352, v.field_1351, v.field_1350, 0.0, 0.0, 0.0);
        }
        double yMotion = empty ? 0.0625 : r.method_43058() * (double)0.0125f;
        class_243 v2 = c.method_1019(VecHelper.offsetRandomly((class_243)class_243.field_1353, (class_5819)r, (float)0.5f).method_18805(1.0, 0.25, 1.0).method_1029().method_1021((empty ? 0.25 : 0.5) + r.method_43058() * 0.125)).method_1031(0.0, 0.5, 0.0);
        if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING)) {
            this.field_11863.method_8406((class_2394)class_2398.field_22246, v2.field_1352, v2.field_1351, v2.field_1350, 0.0, yMotion, 0.0);
        } else if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            this.field_11863.method_8406((class_2394)class_2398.field_11240, v2.field_1352, v2.field_1351, v2.field_1350, 0.0, yMotion, 0.0);
        }
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.owner != null) {
            tag.method_25927("Owner", this.owner);
        }
        if (!this.trustListContainer.method_5442()) {
            tag.method_10566("TrustListInv", (class_2520)this.trustListContainer.save(new class_2487()));
        }
        if (this.getLabel() != null) {
            tag.method_10582("Label", this.getLabel());
        }
        if (clientPacket && this.hasAccount()) {
            tag.method_10569("Balance", this.getAccount().getBalance());
        }
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.owner = tag.method_25928("Owner") ? tag.method_25926("Owner") : null;
        this.trustListContainer.method_5448();
        this.trustList.clear();
        if (tag.method_10573("TrustListInv", 10)) {
            this.trustListContainer.load(tag.method_10562("TrustListInv"));
        }
        if (clientPacket) {
            this.clientsideBalance = tag.method_10550("Balance");
        }
        this.setLabel(tag.method_10558("Label"));
    }

    public BankAccount getAccount() {
        if (this.method_11015()) {
            Numismatics.LOGGER.error("Tried to get account from removed banker!");
            return null;
        }
        if (this.bankAccountBehaviour == null) {
            return null;
        }
        return this.bankAccountBehaviour.getAccount();
    }

    public boolean hasAccount() {
        if (this.method_11015()) {
            Numismatics.LOGGER.error("Tried to check account from removed banker!");
            return false;
        }
        if (this.bankAccountBehaviour == null) {
            return false;
        }
        return this.bankAccountBehaviour.hasAccount();
    }

    @Override
    public boolean isTrustedInternal(class_1657 player) {
        if (Utils.isDevEnv()) {
            return player.method_6118(class_1304.field_6166).method_31574(class_1802.field_8753);
        }
        return this.owner == null || this.owner.equals(player.method_5667()) || this.trustList.contains(player.method_5667());
    }

    @Override
    public ImmutableList<UUID> getTrustList() {
        return ImmutableList.copyOf(this.trustList);
    }

    @Override
    public class_1263 getTrustListBackingContainer() {
        return this.trustListContainer;
    }

    void notifyDelayedDataSync() {
        this.delayedDataSync = true;
    }

    @NotNull
    public class_2561 method_5476() {
        return Components.translatable((String)"block.numismatics.blaze_banker");
    }

    @Nullable
    public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
        return new BlazeBankerMenu((class_3917)NumismaticsMenuTypes.BLAZE_BANKER.get(), i, inventory, this);
    }

    @NotNull
    public String getLabelNonNull() {
        return this.getLabel() == null ? "Blaze Banker" : this.getLabel();
    }

    public UUID getAccountId() {
        if (this.bankAccountBehaviour == null) {
            return null;
        }
        return this.bankAccountBehaviour.getAccountUUID();
    }

    public int getClientsideBalance() {
        return this.clientsideBalance;
    }

    @Override
    public void openTrustListMenu(class_3222 player) {
        if (!this.isTrusted((class_1657)player)) {
            return;
        }
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        Utils.openScreen(player, this, arg_0 -> ((BlazeBankerBlockEntity)this).sendToMenu(arg_0));
    }
}

