/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.coins;

import com.google.common.collect.ImmutableMap;
import com.simibubi.create.foundation.utility.Components;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.coins.DiscreteCoinBag;
import dev.ithundxr.createnumismatics.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoinItem
extends class_1792 {
    public final Coin coin;

    protected CoinItem(class_1792.class_1793 properties, Coin coin) {
        super(properties);
        this.coin = coin;
    }

    public static NonNullFunction<class_1792.class_1793, CoinItem> create(Coin coin) {
        return properties -> new CoinItem((class_1792.class_1793)properties, coin);
    }

    public static boolean extract(class_1657 player, class_1268 hand, Coin coin, boolean onlyHand) {
        return CoinItem.extract(player, hand, coin, false, onlyHand);
    }

    public static boolean extract(class_1657 player, class_1268 hand, Map<Coin, Integer> coins, boolean onlyHand) {
        return CoinItem.extract(player, hand, coins, false, onlyHand);
    }

    public static boolean extract(class_1657 player, class_1268 hand, Coin coin, boolean simulate, boolean onlyHand) {
        return CoinItem.extract(player, hand, (Map<Coin, Integer>)ImmutableMap.of((Object)((Object)coin), (Object)1), simulate, onlyHand);
    }

    public static boolean extract(class_1657 player, class_1268 hand, Map<Coin, Integer> coins, boolean simulate, boolean onlyHand) {
        if (!simulate && !CoinItem.extract(player, hand, coins, true, onlyHand)) {
            return false;
        }
        DiscreteCoinBag coinBag = DiscreteCoinBag.of(coins);
        ArrayList<class_1799> inventoryList = new ArrayList<class_1799>();
        if (onlyHand) {
            inventoryList.add(player.method_5998(hand));
        } else {
            inventoryList.addAll((Collection<class_1799>)player.method_31548().field_7547);
        }
        return CoinItem.extract(inventoryList, coinBag, simulate);
    }

    public static boolean extract(class_1263 container, Map<Coin, Integer> coins, boolean simulate) {
        if (!simulate && !CoinItem.extract(container, coins, true)) {
            return false;
        }
        DiscreteCoinBag coinBag = DiscreteCoinBag.of(coins);
        ArrayList<class_1799> inventoryList = new ArrayList<class_1799>();
        for (int i = 0; i < container.method_5439(); ++i) {
            inventoryList.add(container.method_5438(i));
        }
        return CoinItem.extract(inventoryList, coinBag, simulate);
    }

    public static boolean extract(List<class_1799> inventoryList, Map<Coin, Integer> coins, boolean simulate) {
        return CoinItem.extract(inventoryList, DiscreteCoinBag.of(coins), simulate);
    }

    private static boolean extract(List<class_1799> inventoryList, DiscreteCoinBag coinBag, boolean simulate) {
        for (class_1799 stack : inventoryList) {
            if (coinBag.isEmpty()) {
                return true;
            }
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof CoinItem)) continue;
            CoinItem coinItem = (CoinItem)class_17922;
            Coin coin = coinItem.coin;
            int needed = coinBag.getDiscrete(coin);
            if (needed == 0) continue;
            int available = stack.method_7947();
            int extracted = Math.min(needed, available);
            coinBag.subtract(coin, extracted);
            if (simulate) continue;
            stack.method_7939(stack.method_7947() - extracted);
        }
        return coinBag.isEmpty();
    }

    public static class_1799 setDisplayedCount(class_1799 stack, int amt) {
        class_2487 tag = stack.method_7948();
        tag.method_10569("DisplayedCount", amt);
        stack.method_7980(tag);
        return stack;
    }

    public static class_1799 clearDisplayedCount(class_1799 stack) {
        stack.method_7983("DisplayedCount");
        return stack;
    }

    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 level, @NotNull List<class_2561> tooltipComponents, @NotNull class_1836 isAdvanced) {
        int displayedCount;
        super.method_7851(stack, level, tooltipComponents, isAdvanced);
        Coin descriptor = this.coin.getDescription();
        if (descriptor == Coin.SPUR) {
            tooltipComponents.add((class_2561)Components.translatable((String)"item.numismatics.coin.tooltip.value.basic", (Object[])new Object[]{this.coin.value}));
        } else {
            int relativeValue = this.coin.value / descriptor.value;
            tooltipComponents.add((class_2561)Components.translatable((String)"item.numismatics.coin.tooltip.value", (Object[])new Object[]{relativeValue, descriptor.getName(relativeValue), this.coin.value}));
        }
        if (stack.method_7969() != null && (displayedCount = stack.method_7969().method_10550("DisplayedCount")) > 0) {
            tooltipComponents.add((class_2561)Components.translatable((String)"item.numismatics.coin.tooltip.count", (Object[])new Object[]{TextUtils.formatInt(displayedCount), this.coin.getName(displayedCount)}).method_27692(class_124.field_1065));
        }
    }
}

