/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.coins;

import com.simibubi.create.foundation.utility.Couple;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.coins.CoinBag;
import dev.ithundxr.createnumismatics.registry.NumismaticsItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;

public class DiscreteCoinBag
implements CoinBag {
    private final Map<Coin, Integer> coins = new HashMap<Coin, Integer>();
    private int value = 0;

    protected DiscreteCoinBag(Map<Coin, Integer> coins) {
        this.coins.putAll(coins);
        this.calculateValue();
    }

    public DiscreteCoinBag() {
    }

    private void calculateValue() {
        this.value = 0;
        for (Map.Entry<Coin, Integer> entry : this.coins.entrySet()) {
            this.value += entry.getKey().toSpurs(entry.getValue());
        }
    }

    @Override
    public void add(Coin coin, int count) {
        this.coins.put(coin, (Integer)this.get(coin).getFirst() + count);
        this.calculateValue();
    }

    @Override
    public void subtract(Coin coin, int count) {
        this.coins.put(coin, Math.max(0, (Integer)this.get(coin).getFirst() - count));
        this.calculateValue();
    }

    @Override
    public void set(Coin coin, int count, int spurRemainder) {
        if (spurRemainder != 0) {
            Numismatics.LOGGER.warn("DiscreteCoinBag.set() called with spurRemainder != 0");
        }
        count = Math.max(0, count);
        this.coins.put(coin, count);
        this.calculateValue();
    }

    public void setDiscrete(Coin coin, int count) {
        this.set(coin, count, 0);
    }

    @Override
    public Couple<Integer> get(Coin coin) {
        return Couple.create((Object)this.coins.getOrDefault((Object)coin, 0), (Object)0);
    }

    public int getDiscrete(Coin coin) {
        return (Integer)this.get(coin).getFirst();
    }

    @Override
    public class_1799 asStack(Coin coin) {
        int amt = (Integer)this.get(coin).getFirst();
        if (amt == 0) {
            return class_1799.field_8037;
        }
        return NumismaticsItems.getCoin(coin).asStack(amt);
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public boolean isEmpty() {
        return this.value == 0;
    }

    @Override
    public class_2487 save(class_2487 nbt) {
        for (Map.Entry<Coin, Integer> entry : this.coins.entrySet()) {
            if (entry.getValue() <= 0) continue;
            nbt.method_10569(entry.getKey().name(), entry.getValue().intValue());
        }
        return nbt;
    }

    @Override
    public void load(class_2487 nbt) {
        this.coins.clear();
        for (Coin coin : Coin.values()) {
            if (!nbt.method_10545(coin.name())) continue;
            this.coins.put(coin, nbt.method_10550(coin.name()));
        }
        this.calculateValue();
    }

    public static DiscreteCoinBag of(class_2487 nbt) {
        DiscreteCoinBag bag = new DiscreteCoinBag();
        bag.load(nbt);
        return bag;
    }

    public static DiscreteCoinBag of(Map<Coin, Integer> coins) {
        return new DiscreteCoinBag(coins);
    }

    public static DiscreteCoinBag of() {
        return new DiscreteCoinBag();
    }

    @Override
    public void clear() {
        this.coins.clear();
    }

    public void dropContents(class_1937 level, class_2338 pos) {
        this.dropContents(level, pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public void dropContents(class_1937 level, class_1297 entityAt) {
        this.dropContents(level, entityAt.method_23317(), entityAt.method_23318(), entityAt.method_23321());
    }

    private void dropContents(class_1937 level, double x, double y, double z) {
        this.coins.forEach((coin, amount) -> class_1264.method_5449((class_1937)level, (double)x, (double)y, (double)z, (class_1799)coin.asStack((int)amount)));
    }
}

