/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.depositor;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.BankAccount;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.backend.Trusted;
import dev.ithundxr.createnumismatics.content.backend.trust_list.TrustListContainer;
import dev.ithundxr.createnumismatics.content.backend.trust_list.TrustListHolder;
import dev.ithundxr.createnumismatics.content.bank.CardItem;
import dev.ithundxr.createnumismatics.content.coins.DiscreteCoinBag;
import dev.ithundxr.createnumismatics.content.depositor.AbstractDepositorBlock;
import dev.ithundxr.createnumismatics.registry.NumismaticsPackets;
import dev.ithundxr.createnumismatics.registry.NumismaticsTags;
import dev.ithundxr.createnumismatics.registry.packets.OpenTrustListPacket;
import dev.ithundxr.createnumismatics.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDepositorBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
Trusted,
TrustListHolder {
    public final class_1263 cardContainer = new class_1277(1){

        public void method_5431() {
            super.method_5431();
            AbstractDepositorBlockEntity.this.method_5431();
        }
    };
    @Nullable
    protected UUID owner;
    protected final List<UUID> trustList = new ArrayList<UUID>();
    public final TrustListContainer trustListContainer = new TrustListContainer(this.trustList, () -> ((AbstractDepositorBlockEntity)this).method_5431());
    protected final DiscreteCoinBag inventory = new DiscreteCoinBag();
    private boolean delayedDataSync = false;

    public AbstractDepositorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Nullable
    public UUID getCardId() {
        class_1799 card = this.cardContainer.method_5438(0);
        if (!(card.method_7909() instanceof CardItem)) {
            return null;
        }
        return CardItem.get(card);
    }

    public void activate() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_2248 class_22482 = this.method_11010().method_26204();
            if (class_22482 instanceof AbstractDepositorBlock) {
                AbstractDepositorBlock depositorBlock = (AbstractDepositorBlock)class_22482;
                depositorBlock.activate(this.method_11010(), serverLevel, this.field_11867);
            }
        }
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.owner != null) {
            tag.method_25927("Owner", this.owner);
        }
        if (!this.inventory.isEmpty()) {
            tag.method_10566("Inventory", (class_2520)this.inventory.save(new class_2487()));
        }
        if (!this.cardContainer.method_5438(0).method_7960()) {
            tag.method_10566("Card", (class_2520)this.cardContainer.method_5438(0).method_7953(new class_2487()));
        }
        if (!this.trustListContainer.method_5442()) {
            tag.method_10566("TrustListInv", (class_2520)this.trustListContainer.save(new class_2487()));
        }
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.owner = tag.method_25928("Owner") ? tag.method_25926("Owner") : null;
        this.inventory.clear();
        if (tag.method_10573("Inventory", 10)) {
            this.inventory.load(tag.method_10562("Inventory"));
        }
        if (tag.method_10573("Card", 10)) {
            class_1799 cardStack = class_1799.method_7915((class_2487)tag.method_10562("Card"));
            this.cardContainer.method_5447(0, cardStack);
        } else {
            this.cardContainer.method_5447(0, class_1799.field_8037);
        }
        this.trustListContainer.method_5448();
        this.trustList.clear();
        if (tag.method_10573("TrustListInv", 10)) {
            this.trustListContainer.load(tag.method_10562("TrustListInv"));
        }
    }

    @Override
    public boolean isTrustedInternal(class_1657 player) {
        if (Utils.isDevEnv()) {
            return player.method_6118(class_1304.field_6166).method_31574(class_1802.field_8753);
        }
        return this.owner == null || this.owner.equals(player.method_5667()) || this.trustList.contains(player.method_5667());
    }

    @Nullable
    public UUID getDepositAccount() {
        class_1799 cardStack = this.cardContainer.method_5438(0);
        if (cardStack.method_7960()) {
            return null;
        }
        if (!NumismaticsTags.AllItemTags.CARDS.matches(cardStack)) {
            return null;
        }
        return CardItem.get(cardStack);
    }

    public void addCoin(Coin coin, int count) {
        BankAccount account;
        UUID depositAccount = this.getDepositAccount();
        if (depositAccount != null && (account = Numismatics.BANK.getAccount(depositAccount)) != null) {
            account.deposit(coin, count);
            return;
        }
        this.inventory.add(coin, count);
        this.method_5431();
    }

    public void lazyTick() {
        BankAccount account;
        UUID depositAccount;
        super.lazyTick();
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        if (this.delayedDataSync) {
            this.delayedDataSync = false;
            this.sendData();
        }
        if ((depositAccount = this.getDepositAccount()) != null && !this.inventory.isEmpty() && (account = Numismatics.BANK.getAccount(depositAccount)) != null) {
            for (Coin coin : Coin.values()) {
                int count = this.inventory.getDiscrete(coin);
                this.inventory.subtract(coin, count);
                account.deposit(coin, count);
                this.notifyUpdate();
            }
        }
    }

    void notifyDelayedDataSync() {
        this.delayedDataSync = true;
    }

    @Environment(value=EnvType.CLIENT)
    public void openTrustList() {
        if (this.field_11863 == null || !this.field_11863.field_9236) {
            return;
        }
        NumismaticsPackets.PACKETS.send(new OpenTrustListPacket<AbstractDepositorBlockEntity>(this));
    }

    @Override
    public ImmutableList<UUID> getTrustList() {
        return ImmutableList.copyOf(this.trustList);
    }

    @Override
    public class_1263 getTrustListBackingContainer() {
        return this.trustListContainer;
    }
}

