/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.depositor;

import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Lang;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.backend.behaviours.SliderStylePriceBehaviour;
import dev.ithundxr.createnumismatics.content.backend.trust_list.TrustListMenu;
import dev.ithundxr.createnumismatics.content.coins.MergingCoinBag;
import dev.ithundxr.createnumismatics.content.depositor.AbstractDepositorBlockEntity;
import dev.ithundxr.createnumismatics.content.depositor.BrassDepositorMenu;
import dev.ithundxr.createnumismatics.registry.NumismaticsBlocks;
import dev.ithundxr.createnumismatics.registry.NumismaticsMenuTypes;
import dev.ithundxr.createnumismatics.util.TextUtils;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrassDepositorBlockEntity
extends AbstractDepositorBlockEntity
implements class_3908 {
    private SliderStylePriceBehaviour price;

    public BrassDepositorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.price = new SliderStylePriceBehaviour(this, this::addCoin, this::getCoinCount);
        behaviours.add(this.price);
    }

    public int getCoinCount(Coin coin) {
        return this.inventory.getDiscrete(coin);
    }

    @NotNull
    public class_2561 method_5476() {
        return Components.translatable((String)"block.numismatics.brass_depositor");
    }

    @Nullable
    public class_1703 createMenu(int i, @NotNull class_1661 inventory, @NotNull class_1657 player) {
        if (!this.isTrusted(player)) {
            return null;
        }
        return new BrassDepositorMenu((class_3917)NumismaticsMenuTypes.BRASS_DEPOSITOR.get(), i, inventory, this);
    }

    public int getTotalPrice() {
        return this.price.getTotalPrice();
    }

    public int getPrice(Coin coin) {
        return this.price.getPrice(coin);
    }

    public void setPrice(Coin coin, int price) {
        this.price.setPrice(coin, price);
    }

    public void addCoins(int totalPrice) {
        MergingCoinBag coinBag = new MergingCoinBag(totalPrice);
        for (int i = Coin.values().length - 1; i >= 0; --i) {
            Coin coin = Coin.values()[i];
            int count = (Integer)coinBag.get(coin).getFirst();
            if (count <= 0) continue;
            coinBag.subtract(coin, count);
            this.addCoin(coin, count);
        }
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        Couple<Integer> cogsAndSpurs = Coin.COG.convert(this.price.getTotalPrice());
        int cogs = (Integer)cogsAndSpurs.getFirst();
        int spurs = (Integer)cogsAndSpurs.getSecond();
        class_5250 balanceLabel = Components.translatable((String)"block.numismatics.brass_depositor.tooltip.price", (Object[])new Object[]{TextUtils.formatInt(cogs), Coin.COG.getName(cogs), spurs});
        Lang.builder().add(balanceLabel.method_27692(Coin.closest((int)this.price.getTotalPrice()).rarity.field_8908)).forGoggles(tooltip);
        for (class_5250 component : this.price.getCondensedPriceBreakdown()) {
            Lang.builder().add(component).forGoggles(tooltip);
        }
        return true;
    }

    @Override
    public void openTrustListMenu(class_3222 player) {
        TrustListMenu.openMenu(this, player, NumismaticsBlocks.BRASS_DEPOSITOR.asStack());
    }
}

