/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.vendor;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Lang;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.BankAccount;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.backend.Trusted;
import dev.ithundxr.createnumismatics.content.backend.behaviours.SliderStylePriceBehaviour;
import dev.ithundxr.createnumismatics.content.backend.trust_list.TrustListContainer;
import dev.ithundxr.createnumismatics.content.backend.trust_list.TrustListHolder;
import dev.ithundxr.createnumismatics.content.backend.trust_list.TrustListMenu;
import dev.ithundxr.createnumismatics.content.bank.CardItem;
import dev.ithundxr.createnumismatics.content.coins.CoinItem;
import dev.ithundxr.createnumismatics.content.coins.DiscreteCoinBag;
import dev.ithundxr.createnumismatics.content.vendor.VendorBlock;
import dev.ithundxr.createnumismatics.content.vendor.VendorMenu;
import dev.ithundxr.createnumismatics.registry.NumismaticsAdvancements;
import dev.ithundxr.createnumismatics.registry.NumismaticsBlocks;
import dev.ithundxr.createnumismatics.registry.NumismaticsMenuTypes;
import dev.ithundxr.createnumismatics.registry.NumismaticsPackets;
import dev.ithundxr.createnumismatics.registry.NumismaticsTags;
import dev.ithundxr.createnumismatics.registry.packets.OpenTrustListPacket;
import dev.ithundxr.createnumismatics.util.ItemUtil;
import dev.ithundxr.createnumismatics.util.TextUtils;
import dev.ithundxr.createnumismatics.util.UsernameUtils;
import dev.ithundxr.createnumismatics.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VendorBlockEntity
extends SmartBlockEntity
implements Trusted,
TrustListHolder,
IHaveGoggleInformation,
class_1278,
class_3908 {
    public final class_1263 cardContainer = new class_1277(1){

        public void method_5431() {
            super.method_5431();
            VendorBlockEntity.this.method_5431();
        }
    };
    public final class_1263 sellingContainer = new class_1277(1){

        public void method_5431() {
            super.method_5431();
            VendorBlockEntity.this.method_5431();
            VendorBlockEntity.this.correctStock();
        }
    };
    @Nullable
    protected UUID owner;
    protected final List<UUID> trustList = new ArrayList<UUID>();
    public final TrustListContainer trustListContainer = new TrustListContainer(this.trustList, () -> ((VendorBlockEntity)this).method_5431());
    protected final DiscreteCoinBag inventory = new DiscreteCoinBag();
    private boolean delayedDataSync = false;
    private SliderStylePriceBehaviour price;
    private Mode mode = Mode.SELL;
    public final class_2371<class_1799> items = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
    @Nullable
    private Boolean isCreativeVendorCached;

    public VendorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.price = new SliderStylePriceBehaviour(this, this::addCoin, this::getCoinCount);
        behaviours.add(this.price);
    }

    public int getCoinCount(Coin coin) {
        return this.inventory.getDiscrete(coin);
    }

    @Nullable
    public UUID getCardId() {
        class_1799 card = this.cardContainer.method_5438(0);
        if (!(card.method_7909() instanceof CardItem)) {
            return null;
        }
        return CardItem.get(card);
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.owner != null) {
            tag.method_25927("Owner", this.owner);
        }
        if (!this.inventory.isEmpty()) {
            tag.method_10566("CoinInventory", (class_2520)this.inventory.save(new class_2487()));
        }
        if (!this.cardContainer.method_5438(0).method_7960()) {
            tag.method_10566("Card", (class_2520)this.cardContainer.method_5438(0).method_7953(new class_2487()));
        }
        if (!this.getSellingItem().method_7960()) {
            tag.method_10566("Selling", (class_2520)this.getSellingItem().method_7953(new class_2487()));
        }
        if (!this.trustListContainer.method_5442()) {
            tag.method_10566("TrustListInv", (class_2520)this.trustListContainer.save(new class_2487()));
        }
        if (!this.items.isEmpty()) {
            tag.method_10566("Inventory", (class_2520)class_1262.method_5426((class_2487)new class_2487(), this.items));
        }
        tag.method_10569("Mode", this.mode.ordinal());
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.owner = tag.method_25928("Owner") ? tag.method_25926("Owner") : null;
        this.inventory.clear();
        if (tag.method_10573("CoinInventory", 10)) {
            this.inventory.load(tag.method_10562("CoinInventory"));
        }
        if (tag.method_10573("Card", 10)) {
            class_1799 cardStack = class_1799.method_7915((class_2487)tag.method_10562("Card"));
            this.cardContainer.method_5447(0, cardStack);
        } else {
            this.cardContainer.method_5447(0, class_1799.field_8037);
        }
        if (tag.method_10573("Selling", 10)) {
            class_1799 sellingStack = class_1799.method_7915((class_2487)tag.method_10562("Selling"));
            this.sellingContainer.method_5447(0, sellingStack);
        } else {
            this.sellingContainer.method_5447(0, class_1799.field_8037);
        }
        this.trustListContainer.method_5448();
        this.trustList.clear();
        if (tag.method_10573("TrustListInv", 10)) {
            this.trustListContainer.load(tag.method_10562("TrustListInv"));
        }
        this.items.clear();
        if (tag.method_10573("Inventory", 10)) {
            class_1262.method_5429((class_2487)tag.method_10562("Inventory"), this.items);
        }
        this.mode = Mode.values()[tag.method_10550("Mode")];
    }

    /*
     * Unable to fully structure code
     */
    public boolean isCreativeVendor() {
        block2: {
            if (this.isCreativeVendorCached != null) break block2;
            var2_1 = this.method_11010().method_26204();
            if (!(var2_1 instanceof VendorBlock)) ** GOTO lbl-1000
            vendorBlock = (VendorBlock)var2_1;
            if (vendorBlock.isCreativeVendor) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            this.isCreativeVendorCached = v0;
        }
        return this.isCreativeVendorCached;
    }

    @Override
    public boolean isTrustedInternal(class_1657 player) {
        if (Utils.isDevEnv()) {
            return player.method_6118(class_1304.field_6166).method_31574(class_1802.field_8753);
        }
        if (this.isCreativeVendor()) {
            return player != null && player.method_7337();
        }
        return this.owner == null || this.owner.equals(player.method_5667()) || this.trustList.contains(player.method_5667());
    }

    public void addCoin(Coin coin, int count) {
        BankAccount account;
        UUID depositAccount = this.getDepositAccount();
        if (depositAccount != null && (account = Numismatics.BANK.getAccount(depositAccount)) != null) {
            account.deposit(coin, count);
            return;
        }
        this.inventory.add(coin, count);
        this.method_5431();
    }

    @Nullable
    public UUID getDepositAccount() {
        class_1799 cardStack = this.cardContainer.method_5438(0);
        if (cardStack.method_7960()) {
            return null;
        }
        if (!NumismaticsTags.AllItemTags.CARDS.matches(cardStack)) {
            return null;
        }
        return CardItem.get(cardStack);
    }

    public void lazyTick() {
        BankAccount account;
        UUID depositAccount;
        super.lazyTick();
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        if (this.delayedDataSync) {
            this.delayedDataSync = false;
            this.sendData();
        }
        if ((depositAccount = this.getDepositAccount()) != null && !this.inventory.isEmpty() && (account = Numismatics.BANK.getAccount(depositAccount)) != null) {
            for (Coin coin : Coin.values()) {
                int count = this.inventory.getDiscrete(coin);
                this.inventory.subtract(coin, count);
                account.deposit(coin, count);
                this.notifyUpdate();
            }
        }
    }

    void notifyDelayedDataSync() {
        this.delayedDataSync = true;
    }

    @Override
    public ImmutableList<UUID> getTrustList() {
        return ImmutableList.copyOf(this.trustList);
    }

    @Override
    public class_1263 getTrustListBackingContainer() {
        return this.trustListContainer;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        class_1799 sellingStack = this.getSellingItem();
        if (sellingStack.method_7960()) {
            return false;
        }
        switch (this.mode) {
            case SELL: {
                if (this.hasStock()) break;
                Lang.builder().add(Components.translatable((String)"gui.numismatics.vendor.out_of_stock")).style(class_124.field_1079).forGoggles(tooltip);
                String ownerName = UsernameUtils.INSTANCE.getName(this.owner, null);
                if (ownerName == null) break;
                Lang.builder().add(Components.translatable((String)"gui.numismatics.vendor.generic_named", (Object[])new Object[]{ownerName})).style(class_124.field_1079).forGoggles(tooltip);
                break;
            }
            case BUY: {
                String ownerName;
                if (!this.hasSpace()) {
                    Lang.builder().add(Components.translatable((String)"gui.numismatics.vendor.full")).style(class_124.field_1079).forGoggles(tooltip);
                    ownerName = UsernameUtils.INSTANCE.getName(this.owner, null);
                    if (ownerName == null) break;
                    Lang.builder().add(Components.translatable((String)"gui.numismatics.vendor.generic_named", (Object[])new Object[]{ownerName})).style(class_124.field_1079).forGoggles(tooltip);
                    break;
                }
                if (this.hasEnoughMoney()) break;
                Lang.builder().add(Components.translatable((String)"gui.numismatics.vendor.insufficient_funds")).style(class_124.field_1079).forGoggles(tooltip);
                ownerName = UsernameUtils.INSTANCE.getName(this.owner, null);
                if (ownerName == null) break;
                Lang.builder().add(Components.translatable((String)"gui.numismatics.vendor.generic_named", (Object[])new Object[]{ownerName})).style(class_124.field_1079).forGoggles(tooltip);
            }
        }
        Couple<Integer> cogsAndSpurs = Coin.COG.convert(this.getTotalPrice());
        int cogs = (Integer)cogsAndSpurs.getFirst();
        int spurs = (Integer)cogsAndSpurs.getSecond();
        class_5250 balanceLabel = Components.translatable((String)"block.numismatics.vendor.tooltip.price", (Object[])new Object[]{TextUtils.formatInt(cogs), Coin.COG.getName(cogs), spurs});
        Lang.builder().add(Components.translatable((String)this.mode.getOpposite().getActionTranslationKey())).forGoggles(tooltip);
        boolean isFirst = true;
        for (class_2561 class_25612 : class_437.method_25408((class_310)class_310.method_1551(), (class_1799)sellingStack)) {
            class_5250 mutable = class_25612.method_27661();
            if (isFirst) {
                isFirst = false;
                if (sellingStack.method_7947() != 1) {
                    mutable.method_10852((class_2561)Components.translatable((String)"gui.numismatics.vendor.count", (Object[])new Object[]{sellingStack.method_7947()}).method_27692(class_124.field_1060));
                }
            }
            Lang.builder().add(mutable).forGoggles(tooltip);
        }
        tooltip.add(Components.immutableEmpty());
        Lang.builder().add(balanceLabel.method_27692(Coin.closest((int)this.getTotalPrice()).rarity.field_8908)).forGoggles(tooltip);
        for (class_5250 class_52502 : this.price.getCondensedPriceBreakdown()) {
            Lang.builder().add(class_52502).forGoggles(tooltip);
        }
        return true;
    }

    @NotNull
    public class_2561 method_5476() {
        return Components.translatable((String)(this.isCreativeVendor() ? "block.numismatics.creative_vendor" : "block.numismatics.vendor"));
    }

    @Nullable
    public class_1703 createMenu(int i, @NotNull class_1661 inventory, @NotNull class_1657 player) {
        if (!this.isTrusted(player)) {
            return null;
        }
        return new VendorMenu((class_3917)NumismaticsMenuTypes.VENDOR.get(), i, inventory, this);
    }

    public int getTotalPrice() {
        return this.price.getTotalPrice();
    }

    public int getPrice(Coin coin) {
        return this.price.getPrice(coin);
    }

    public void setPrice(Coin coin, int price) {
        this.price.setPrice(coin, price);
    }

    public class_1799 getSellingItem() {
        return this.sellingContainer.method_5438(0);
    }

    public int @NotNull [] method_5494(@NotNull class_2350 side) {
        int[] nArray;
        if (this.mode == Mode.BUY) {
            int[] nArray2;
            if (side == class_2350.field_11033) {
                int[] nArray3 = new int[9];
                nArray3[0] = 0;
                nArray3[1] = 1;
                nArray3[2] = 2;
                nArray3[3] = 3;
                nArray3[4] = 4;
                nArray3[5] = 5;
                nArray3[6] = 6;
                nArray3[7] = 7;
                nArray2 = nArray3;
                nArray3[8] = 8;
            } else {
                nArray2 = new int[]{};
            }
            return nArray2;
        }
        if (side == class_2350.field_11033) {
            nArray = new int[]{};
        } else {
            int[] nArray4 = new int[9];
            nArray4[0] = 0;
            nArray4[1] = 1;
            nArray4[2] = 2;
            nArray4[3] = 3;
            nArray4[4] = 4;
            nArray4[5] = 5;
            nArray4[6] = 6;
            nArray4[7] = 7;
            nArray = nArray4;
            nArray4[8] = 8;
        }
        return nArray;
    }

    public boolean method_5437(int index, @NotNull class_1799 stack) {
        return this.mode == Mode.SELL && this.matchesSellingItem(stack);
    }

    public boolean method_5492(int index, @NotNull class_1799 itemStack, @Nullable class_2350 direction) {
        return direction != class_2350.field_11033 && this.method_5437(index, itemStack);
    }

    public boolean method_5493(int index, @NotNull class_1799 stack, @NotNull class_2350 direction) {
        return direction == class_2350.field_11033 && this.mode == Mode.BUY;
    }

    public int method_5439() {
        return 9;
    }

    public boolean method_5442() {
        for (class_1799 stack : this.items) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public class_1799 method_5438(int slot) {
        return slot >= 0 && slot < this.items.size() ? (class_1799)this.items.get(slot) : class_1799.field_8037;
    }

    @NotNull
    public class_1799 method_5434(int slot, int amount) {
        class_1799 itemStack = class_1262.method_5430(this.items, (int)slot, (int)amount);
        if (!itemStack.method_7960()) {
            this.method_5431();
        }
        return itemStack;
    }

    @NotNull
    public class_1799 method_5441(int slot) {
        class_1799 itemStack = (class_1799)this.items.get(slot);
        if (itemStack.method_7960()) {
            return class_1799.field_8037;
        }
        this.items.set(slot, (Object)class_1799.field_8037);
        return itemStack;
    }

    public void method_5447(int slot, @NotNull class_1799 stack) {
        this.items.set(slot, (Object)stack);
        if (!stack.method_7960() && stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        this.method_5431();
    }

    public boolean method_5443(@NotNull class_1657 player) {
        return class_1263.method_49105((class_2586)this, (class_1657)player);
    }

    public void method_5448() {
        this.items.clear();
        this.method_5431();
    }

    @NotNull
    @Contract(value="_ -> new")
    private class_2487 cleanTags(@NotNull class_2487 tag) {
        tag = tag.method_10553();
        tag.method_10551("RepairCost");
        tag.method_10551("Count");
        class_2499 enchants = tag.method_10554("Enchantments", 10);
        if (!enchants.isEmpty()) {
            ArrayList tags = new ArrayList(enchants);
            tags.sort((a, b) -> {
                if (a.equals(b)) {
                    return 0;
                }
                if (a instanceof class_2487) {
                    class_2487 ca = (class_2487)a;
                    if (b instanceof class_2487) {
                        int comp;
                        class_2487 cb = (class_2487)b;
                        if (ca.method_10573("id", 8) && cb.method_10573("id", 8) && (comp = ca.method_10558("id").compareTo(cb.method_10558("id"))) != 0) {
                            return comp;
                        }
                        return ca.method_10568("lvl") - cb.method_10568("lvl");
                    }
                }
                return 0;
            });
            enchants = new class_2499();
            enchants.addAll(tags);
            tag.method_10566("Enchantments", (class_2520)enchants);
        }
        return tag;
    }

    public boolean matchesSellingItem(@NotNull class_1799 b) {
        class_1799 a = this.getSellingItem();
        if (a.method_7960() || b.method_7960()) {
            return false;
        }
        if (!class_1799.method_7984((class_1799)a, (class_1799)b)) {
            return false;
        }
        class_2487 an = a.method_7969();
        class_2487 bn = b.method_7969();
        if (an == null || bn == null) {
            return an == bn;
        }
        an = this.cleanTags(an);
        bn = this.cleanTags(bn);
        return an.equals((Object)bn);
    }

    protected void condenseItems() {
        class_2371 newItems = class_2371.method_10213((int)this.items.size(), (Object)class_1799.field_8037);
        for (int i = 0; i < this.items.size(); ++i) {
            newItems.set(i, (Object)((class_1799)this.items.get(i)));
        }
        this.items.clear();
        for (class_1799 stack : newItems) {
            ItemUtil.moveItemStackTo(stack, (class_1263)this, false);
        }
        this.notifyUpdate();
    }

    protected void correctStock() {
        for (int i = 0; i < this.items.size(); ++i) {
            class_1799 stack = (class_1799)this.items.get(i);
            if (this.matchesSellingItem(stack) || stack.method_7960() || this.field_11863 == null) continue;
            class_1264.method_5449((class_1937)this.field_11863, (double)this.method_11016().method_10263(), (double)(this.method_11016().method_10264() + 1), (double)this.method_11016().method_10260(), (class_1799)stack);
            this.items.set(i, (Object)class_1799.field_8037);
        }
        this.notifyUpdate();
    }

    public void dropContents(class_1937 level, class_2338 pos) {
        class_1264.method_5451((class_1937)level, (class_2338)pos, (class_1263)this);
        class_1264.method_5451((class_1937)level, (class_2338)pos, (class_1263)this.cardContainer);
        class_1264.method_5451((class_1937)level, (class_2338)pos, (class_1263)this.sellingContainer);
        this.inventory.dropContents(level, pos);
    }

    private boolean hasStock() {
        if (this.isCreativeVendor()) {
            return true;
        }
        for (class_1799 stack : this.items) {
            if (!this.matchesSellingItem(stack) || stack.method_7947() < this.getSellingItem().method_7947()) continue;
            return true;
        }
        return false;
    }

    private boolean hasSpace() {
        if (this.isCreativeVendor()) {
            return true;
        }
        class_1799 buying = this.getSellingItem();
        int space = 0;
        for (class_1799 stack : this.items) {
            if (stack.method_7960()) {
                space += buying.method_7914();
                continue;
            }
            if (!this.matchesSellingItem(stack) || stack.method_7947() >= stack.method_7914()) continue;
            space += stack.method_7914() - stack.method_7947();
        }
        return space >= buying.method_7947();
    }

    private boolean hasEnoughMoney() {
        if (this.isCreativeVendor()) {
            return true;
        }
        if (this.price.canPayOut()) {
            return true;
        }
        if (this.getCardId() != null) {
            BankAccount account = Numismatics.BANK.getAccount(this.getCardId());
            return account != null && account.isAuthorized(this.owner) && account.getBalance() >= this.price.getTotalPrice();
        }
        return false;
    }

    public void tryTransaction(class_1657 player, class_1268 hand) {
        switch (this.mode) {
            case SELL: {
                this.trySellTo(player, hand);
                break;
            }
            case BUY: {
                this.tryBuyFrom(player, hand);
            }
        }
    }

    private void trySellTo(class_1657 player, class_1268 hand) {
        if (this.field_11863 == null) {
            return;
        }
        class_1799 selling = this.getSellingItem();
        if (selling.method_7960()) {
            return;
        }
        this.condenseItems();
        if (this.isCreativeVendor()) {
            if (this.price.deduct(player, hand, false)) {
                class_1799 output = selling.method_7972();
                ItemUtil.givePlayerItem(player, output);
                this.giveSellingAdvancements(player);
                this.field_11863.method_8396(null, this.method_11016(), class_3417.field_15224, class_3419.field_15245, 0.5f, 1.0f);
                this.notifyUpdate();
            } else {
                player.method_7353((class_2561)Components.translatable((String)"gui.numismatics.vendor.insufficient_funds").method_27692(class_124.field_1079), true);
                this.field_11863.method_8396(null, this.method_11016(), AllSoundEvents.DENY.getMainEvent(), class_3419.field_15245, 0.5f, 1.0f);
            }
        } else {
            for (class_1799 stack : this.items) {
                if (!this.matchesSellingItem(stack) || stack.method_7947() < selling.method_7947()) continue;
                if (this.price.deduct(player, hand, true)) {
                    class_1799 output = stack.method_7971(selling.method_7947());
                    ItemUtil.givePlayerItem(player, output);
                    this.giveSellingAdvancements(player);
                    this.field_11863.method_8396(null, this.method_11016(), class_3417.field_15224, class_3419.field_15245, 0.5f, 1.0f);
                    this.notifyUpdate();
                } else {
                    player.method_7353((class_2561)Components.translatable((String)"gui.numismatics.vendor.insufficient_funds").method_27692(class_124.field_1079), true);
                    this.field_11863.method_8396(null, this.method_11016(), AllSoundEvents.DENY.getMainEvent(), class_3419.field_15245, 0.5f, 1.0f);
                }
                return;
            }
            String ownerName = UsernameUtils.INSTANCE.getName(this.owner, null);
            if (ownerName != null) {
                player.method_7353((class_2561)Components.translatable((String)"gui.numismatics.vendor.out_of_stock.named", (Object[])new Object[]{ownerName}).method_27692(class_124.field_1079), true);
                this.field_11863.method_8396(null, this.method_11016(), AllSoundEvents.DENY.getMainEvent(), class_3419.field_15245, 0.5f, 1.0f);
            } else {
                player.method_7353((class_2561)Components.translatable((String)"gui.numismatics.vendor.out_of_stock").method_27692(class_124.field_1079), true);
                this.field_11863.method_8396(null, this.method_11016(), AllSoundEvents.DENY.getMainEvent(), class_3419.field_15245, 0.5f, 1.0f);
            }
        }
    }

    private void giveSellingAdvancements(class_1657 player) {
        class_1799 selling = this.getSellingItem();
        class_1792 class_17922 = selling.method_7909();
        if (class_17922 instanceof CoinItem) {
            CoinItem coin = (CoinItem)class_17922;
            NumismaticsAdvancements.MONEY_LAUNDERING.awardTo(player);
            int soldValue = coin.coin.toSpurs(selling.method_7947());
            int paidValue = this.price.getTotalPrice();
            if (soldValue > paidValue) {
                NumismaticsAdvancements.IS_THIS_LEGAL.awardTo(player);
            } else if (soldValue < paidValue) {
                NumismaticsAdvancements.QUESTIONABLE_INVESTMENT.awardTo(player);
            }
        }
    }

    private void tryBuyFrom(class_1657 player, class_1268 hand) {
        BankAccount account;
        if (this.field_11863 == null) {
            return;
        }
        class_1799 buying = this.getSellingItem();
        if (buying.method_7960()) {
            return;
        }
        class_1799 handStack = player.method_5998(hand);
        if (handStack.method_7960()) {
            player.method_7353((class_2561)Components.translatable((String)"gui.numismatics.vendor.no_item_in_hand").method_27692(class_124.field_1079), true);
            this.field_11863.method_8396(null, this.method_11016(), AllSoundEvents.DENY.getMainEvent(), class_3419.field_15245, 0.5f, 1.0f);
            return;
        }
        if (!this.matchesSellingItem(handStack)) {
            player.method_7353((class_2561)Components.translatable((String)"gui.numismatics.vendor.incorrect_item").method_27692(class_124.field_1079), true);
            this.field_11863.method_8396(null, this.method_11016(), AllSoundEvents.DENY.getMainEvent(), class_3419.field_15245, 0.5f, 1.0f);
            return;
        }
        if (handStack.method_7947() < buying.method_7947()) {
            player.method_7353((class_2561)Components.translatable((String)"gui.numismatics.vendor.too_few_items").method_27692(class_124.field_1079), true);
            this.field_11863.method_8396(null, this.method_11016(), AllSoundEvents.DENY.getMainEvent(), class_3419.field_15245, 0.5f, 1.0f);
            return;
        }
        if (!this.hasSpace()) {
            String ownerName = UsernameUtils.INSTANCE.getName(this.owner, null);
            if (ownerName != null) {
                player.method_7353((class_2561)Components.translatable((String)"gui.numismatics.vendor.full.named", (Object[])new Object[]{ownerName}).method_27692(class_124.field_1079), true);
                this.field_11863.method_8396(null, this.method_11016(), AllSoundEvents.DENY.getMainEvent(), class_3419.field_15245, 0.5f, 1.0f);
            } else {
                player.method_7353((class_2561)Components.translatable((String)"gui.numismatics.vendor.full").method_27692(class_124.field_1079), true);
                this.field_11863.method_8396(null, this.method_11016(), AllSoundEvents.DENY.getMainEvent(), class_3419.field_15245, 0.5f, 1.0f);
            }
            return;
        }
        if (this.isCreativeVendor() || this.price.canPayOut()) {
            handStack.method_7934(buying.method_7947());
            player.method_6122(hand, handStack);
            this.addBoughtItem(buying.method_7972());
            if (!this.isCreativeVendor()) {
                this.price.deductFromSelf(false);
            }
            this.price.pay(player);
            this.field_11863.method_8396(null, this.method_11016(), class_3417.field_15224, class_3419.field_15245, 0.5f, 1.0f);
            this.notifyUpdate();
            return;
        }
        if (this.getCardId() != null && (account = Numismatics.BANK.getAccount(this.getCardId())) != null && account.isAuthorized(this.owner) && account.deduct(this.price.getTotalPrice())) {
            handStack.method_7934(buying.method_7947());
            player.method_6122(hand, handStack);
            this.addBoughtItem(buying.method_7972());
            this.price.pay(player);
            this.field_11863.method_8396(null, this.method_11016(), class_3417.field_15224, class_3419.field_15245, 0.5f, 1.0f);
            this.notifyUpdate();
            return;
        }
        String ownerName = UsernameUtils.INSTANCE.getName(this.owner, null);
        if (ownerName != null) {
            player.method_7353((class_2561)Components.translatable((String)"gui.numismatics.vendor.insufficient_funds.named", (Object[])new Object[]{ownerName}).method_27692(class_124.field_1079), true);
        } else {
            player.method_7353((class_2561)Components.translatable((String)"gui.numismatics.vendor.insufficient_funds").method_27692(class_124.field_1079), true);
        }
        this.field_11863.method_8396(null, this.method_11016(), AllSoundEvents.DENY.getMainEvent(), class_3419.field_15245, 0.5f, 1.0f);
    }

    private void addBoughtItem(class_1799 stack) {
        if (!this.matchesSellingItem(stack)) {
            return;
        }
        if (this.isCreativeVendor()) {
            return;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            class_1799 item = (class_1799)this.items.get(i);
            if (item.method_7960() || this.matchesSellingItem(item)) {
                if (item.method_7947() + stack.method_7947() <= item.method_7914()) {
                    this.items.set(i, (Object)this.getSellingItem().method_46651(item.method_7947() + stack.method_7947()));
                    return;
                }
                int diff = item.method_7914() - item.method_7947();
                this.items.set(i, (Object)this.getSellingItem().method_46651(item.method_7914()));
                stack.method_7934(diff);
            }
            if (stack.method_7960()) break;
        }
        this.notifyUpdate();
    }

    @Override
    public void openTrustListMenu(class_3222 player) {
        TrustListMenu.openMenu(this, player, this.isCreativeVendor() ? NumismaticsBlocks.CREATIVE_VENDOR.asStack() : NumismaticsBlocks.VENDOR.asStack());
    }

    @Environment(value=EnvType.CLIENT)
    public void openTrustList() {
        if (this.field_11863 == null || !this.field_11863.field_9236) {
            return;
        }
        NumismaticsPackets.PACKETS.send(new OpenTrustListPacket<VendorBlockEntity>(this));
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.method_5431();
        }
    }

    public static enum Mode {
        SELL,
        BUY;


        public static List<class_2561> getComponents() {
            return ImmutableList.copyOf(Arrays.stream(Mode.values()).map(Mode::getTranslationKey).map(Components::translatable).iterator());
        }

        public String getTranslationKey() {
            return "gui.numismatics.vendor.mode." + this.name().toLowerCase(Locale.ROOT);
        }

        public String getActionTranslationKey() {
            return this.getTranslationKey() + ".action";
        }

        public Mode getOpposite() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case SELL -> BUY;
                case BUY -> SELL;
            };
        }
    }
}

