/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.vendor;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.gui.widget.SelectionScrollInput;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import dev.ithundxr.createnumismatics.base.client.rendering.GuiBlockEntityRenderBuilder;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.backend.behaviours.SliderStylePriceConfigurationPacket;
import dev.ithundxr.createnumismatics.content.vendor.VendorBlockEntity;
import dev.ithundxr.createnumismatics.content.vendor.VendorMenu;
import dev.ithundxr.createnumismatics.registry.NumismaticsBlocks;
import dev.ithundxr.createnumismatics.registry.NumismaticsGuiTextures;
import dev.ithundxr.createnumismatics.registry.NumismaticsPackets;
import dev.ithundxr.createnumismatics.registry.packets.VendorConfigurationPacket;
import dev.ithundxr.createnumismatics.util.TextUtils;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_768;
import org.jetbrains.annotations.NotNull;

public class VendorScreen
extends AbstractSimiContainerScreen<VendorMenu> {
    private IconButton trustListButton;
    private IconButton confirmButton;
    private NumismaticsGuiTextures background;
    private final class_1799 renderedItem;
    private final int COIN_COUNT = Coin.values().length;
    private final Label[] coinLabels = new Label[this.COIN_COUNT];
    private final ScrollInput[] coinScrollInputs = new ScrollInput[this.COIN_COUNT];
    private Label modeLabel;
    private SelectionScrollInput modeScrollInput;
    private List<class_768> extraAreas = Collections.emptyList();

    public VendorScreen(VendorMenu container, class_1661 inv, class_2561 title) {
        super((class_1703)container, inv, title);
        this.renderedItem = ((VendorBlockEntity)container.contentHolder).isCreativeVendor() ? NumismaticsBlocks.CREATIVE_VENDOR.asStack() : NumismaticsBlocks.VENDOR.asStack();
        this.background = ((VendorBlockEntity)container.contentHolder).isCreativeVendor() ? NumismaticsGuiTextures.CREATIVE_VENDOR : NumismaticsGuiTextures.VENDOR;
    }

    protected void method_25426() {
        this.setWindowSize(this.background.width, this.background.height + 2 + AllGuiTextures.PLAYER_INVENTORY.height);
        this.setWindowOffset(-20, 0);
        super.method_25426();
        int x = this.field_2776;
        int y = this.field_2800;
        this.trustListButton = new IconButton(x + 7, y + 121, (ScreenElement)AllIcons.I_VIEW_SCHEDULE);
        this.trustListButton.withCallback(() -> ((VendorBlockEntity)((VendorMenu)this.field_2797).contentHolder).openTrustList());
        this.method_37063((class_364)this.trustListButton);
        this.confirmButton = new IconButton(x + this.background.width - 33, y + this.background.height - 24, (ScreenElement)AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.method_25419());
        this.method_37063((class_364)this.confirmButton);
        for (Coin coin : Coin.values()) {
            int i = coin.ordinal();
            int baseX = x + 36 + (i < 3 ? 0 : 140);
            int yIncrement = 22;
            int baseY = y + 45 + yIncrement * (i % 3);
            this.coinLabels[i] = new Label(baseX + 18, baseY + 5, Components.immutableEmpty()).withShadow();
            this.method_37063((class_364)this.coinLabels[i]);
            this.coinScrollInputs[i] = new ScrollInput(baseX, baseY, 36, 18).withRange(0, 129).writingTo(this.coinLabels[i]).titled(Components.literal((String)TextUtils.titleCaseConversion(coin.getName(0)))).calling(value -> {
                ((VendorBlockEntity)((VendorMenu)this.field_2797).contentHolder).setPrice(coin, (int)value);
                this.coinLabels[i].method_46421(baseX + 18 - this.field_22793.method_27525((class_5348)this.coinLabels[i].text) / 2);
            });
            this.method_37063((class_364)this.coinScrollInputs[i]);
            this.coinScrollInputs[i].setState(((VendorBlockEntity)((VendorMenu)this.field_2797).contentHolder).getPrice(coin));
            this.coinScrollInputs[i].onChanged();
        }
        this.modeLabel = new Label(x + 90 + 3, y + 40 + 5, Components.immutableEmpty()).withShadow();
        this.method_37063((class_364)this.modeLabel);
        this.modeScrollInput = new SelectionScrollInput(x + 90, y + 40, 46, 18);
        this.modeScrollInput.forOptions(VendorBlockEntity.Mode.getComponents());
        this.modeScrollInput.writingTo(this.modeLabel);
        this.modeScrollInput.titled(Components.translatable((String)"block.numismatics.vendor.tooltip.mode"));
        this.modeScrollInput.calling(idx -> ((VendorBlockEntity)((VendorMenu)this.field_2797).contentHolder).setMode(VendorBlockEntity.Mode.values()[idx]));
        this.method_37063((class_364)this.modeScrollInput);
        this.modeScrollInput.setState(((VendorBlockEntity)((VendorMenu)this.field_2797).contentHolder).getMode().ordinal());
        this.modeScrollInput.onChanged();
        this.extraAreas = ImmutableList.of((Object)new class_768(x + this.background.width, y + this.background.height - 68, 84, 84));
    }

    public List<class_768> getExtraAreas() {
        return this.extraAreas;
    }

    protected void method_2389(@NotNull class_332 graphics, float partialTick, int mouseX, int mouseY) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.width);
        int invY = this.field_2800 + this.background.height + 2;
        this.renderPlayerInventory(graphics, invX, invY);
        int x = this.field_2776;
        int y = this.field_2800;
        this.background.render(graphics, x, y);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((class_1799)this.renderedItem).at((float)(x + this.background.width + 6), (float)(y + this.background.height - 70), -200.0f)).scale(5.0).render(graphics);
        ((GuiGameElement.GuiRenderBuilder)GuiBlockEntityRenderBuilder.of((VendorBlockEntity)((VendorMenu)this.field_2797).contentHolder).at(x + this.background.width + 6, y + this.background.height - 90, -230.0f)).scale(5.0).render(graphics);
        graphics.method_27534(this.field_22793, this.field_22785, x + (this.background.width - 8) / 2, y + 3, 0xFFFFFF);
        Couple<Integer> cogsAndSpurs = Coin.COG.convert(((VendorBlockEntity)((VendorMenu)this.field_2797).contentHolder).getTotalPrice());
        int cogs = (Integer)cogsAndSpurs.getFirst();
        int spurs = (Integer)cogsAndSpurs.getSecond();
        class_5250 balanceLabel = Components.translatable((String)"block.numismatics.brass_depositor.tooltip.price", (Object[])new Object[]{TextUtils.formatInt(cogs), Coin.COG.getName(cogs), spurs});
        graphics.method_27534(this.field_22793, (class_2561)balanceLabel, x + (this.background.width - 8) / 2, y + 21, 0xFFFFFF);
    }

    protected void method_2380(@NotNull class_332 guiGraphics, int x, int y) {
        super.method_2380(guiGraphics, x, y);
        if (((VendorMenu)this.field_2797).method_34255().method_7960() && this.field_2787 != null && !this.field_2787.method_7681()) {
            class_5250 component = null;
            if (this.field_2787.field_7874 == VendorMenu.SELLING_SLOT_INDEX) {
                component = Components.translatable((String)"block.numismatics.vendor.tooltip.trade_item");
            } else if (VendorMenu.INV_START_INDEX <= this.field_2787.field_7874 && this.field_2787.field_7874 < VendorMenu.INV_END_INDEX) {
                component = Components.translatable((String)"block.numismatics.vendor.tooltip.stock");
            }
            if (component != null) {
                guiGraphics.method_51438(this.field_22793, (class_2561)component, x, y);
            }
        }
    }

    public void method_25432() {
        NumismaticsPackets.PACKETS.send(new SliderStylePriceConfigurationPacket((SyncedBlockEntity)((VendorMenu)this.field_2797).contentHolder));
        NumismaticsPackets.PACKETS.send(new VendorConfigurationPacket((VendorBlockEntity)((VendorMenu)this.field_2797).contentHolder));
        super.method_25432();
    }
}

