/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.registry.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.BankAccount;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.bank.blaze_banker.BankAccountBehaviour;
import dev.ithundxr.createnumismatics.registry.commands.arguments.EnumArgument;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.class_1922;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2191;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;

public class ViewCommand {
    public static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"view").requires(cs -> cs.method_9259(2))).then(class_2170.method_9247((String)"banker").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(ctx -> {
            class_2338 pos = class_2262.method_9696((CommandContext)ctx, (String)"pos");
            BankAccountBehaviour bankAct = (BankAccountBehaviour)BlockEntityBehaviour.get((class_1922)((class_2168)ctx.getSource()).method_9225(), (class_2338)pos, BankAccountBehaviour.TYPE);
            UUID id = bankAct.getAccountUUID();
            return ViewCommand.execute((CommandContext<class_2168>)ctx, id, BankAccount.Type.BLAZE_BANKER, false, "Blaze Banker at (" + pos.method_23854() + ")");
        })).then(class_2170.method_9244((String)"coin", EnumArgument.enumArgument(Coin.class)).executes(ctx -> {
            class_2338 pos = class_2262.method_9696((CommandContext)ctx, (String)"pos");
            Coin coin = (Coin)((Object)((Object)ctx.getArgument("coin", Coin.class)));
            BankAccountBehaviour bankAct = (BankAccountBehaviour)BlockEntityBehaviour.get((class_1922)((class_2168)ctx.getSource()).method_9225(), (class_2338)pos, BankAccountBehaviour.TYPE);
            UUID id = bankAct.getAccountUUID();
            return ViewCommand.execute((CommandContext<class_2168>)ctx, id, BankAccount.Type.BLAZE_BANKER, false, "Blaze Banker at (" + pos.method_23854() + ")", coin);
        }))))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).executes(ctx -> {
            Collection accounts = class_2191.method_9330((CommandContext)ctx, (String)"player");
            int sum = 0;
            for (GameProfile account : accounts) {
                sum += ViewCommand.execute((CommandContext<class_2168>)ctx, account.getId(), BankAccount.Type.PLAYER, true, account.getName());
            }
            return sum;
        })).then(class_2170.method_9244((String)"coin", EnumArgument.enumArgument(Coin.class)).executes(ctx -> {
            Collection accounts = class_2191.method_9330((CommandContext)ctx, (String)"player");
            Coin coin = (Coin)((Object)((Object)ctx.getArgument("coin", Coin.class)));
            int sum = 0;
            for (GameProfile account : accounts) {
                sum += ViewCommand.execute((CommandContext<class_2168>)ctx, account.getId(), BankAccount.Type.PLAYER, true, account.getName(), coin);
            }
            return sum;
        })));
    }

    private static int execute(CommandContext<class_2168> ctx, UUID account, BankAccount.Type type, boolean create, String name) {
        return ViewCommand.execute(ctx, account, type, create, name, Coin.SPUR);
    }

    private static int execute(CommandContext<class_2168> ctx, UUID account, BankAccount.Type type, boolean create, String name, Coin coin) {
        int balance = ViewCommand.getBalance(account, create, type);
        if (balance != -1) {
            Couple<Integer> coinAndRemainder = coin.convert(balance);
            int coinCount = (Integer)coinAndRemainder.getFirst();
            int remainder = (Integer)coinAndRemainder.getSecond();
            if (remainder == 0) {
                ((class_2168)ctx.getSource()).method_9226(() -> Components.literal((String)(name + " has " + coinCount + " " + coin.getName(coinCount) + ".")), true);
            } else {
                ((class_2168)ctx.getSource()).method_9226(() -> Components.literal((String)(name + " has " + coinCount + " " + coin.getName(coinCount) + " and " + remainder + " " + Coin.SPUR.getName(remainder) + ".")), true);
            }
            return coinCount;
        }
        ((class_2168)ctx.getSource()).method_9213((class_2561)Components.literal((String)("Could not find account for " + name + ".")));
        return -1;
    }

    private static int getBalance(UUID id, boolean create, BankAccount.Type type) {
        BankAccount account;
        BankAccount bankAccount = account = create ? Numismatics.BANK.getOrCreateAccount(id, type) : Numismatics.BANK.getAccount(id);
        if (account == null) {
            return -1;
        }
        return account.getBalance();
    }
}

