/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.tom.storagemod.Config;
import com.tom.storagemod.Content;
import com.tom.storagemod.StorageTags;
import com.tom.storagemod.block.FramedInventoryCableConnectorBlock;
import com.tom.storagemod.block.InventoryProxyBlock;
import com.tom.storagemod.block.PaintedFramedInventoryCableBlock;
import com.tom.storagemod.item.WirelessTerminal;
import com.tom.storagemod.network.NetworkHandler;
import com.tom.storagemod.platform.Platform;
import com.tom.storagemod.util.GameObject;
import com.tom.storagemod.util.IDataReceiver;
import com.tom.storagemod.util.PlayerInvUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Set;
import java.util.function.Function;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StorageMod
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String modid = "toms_storage";
    public static GameObject<PaintedFramedInventoryCableBlock> invCablePainted;
    public static GameObject<FramedInventoryCableConnectorBlock> invCableConnectorPainted;
    public static GameObject<InventoryProxyBlock> invProxyPainted;
    public static final Gson gson;
    public static ConfigHolder<Config> configHolder;
    private static Config LOADED_CONFIG;
    public static Config CONFIG;
    public static Set<class_2248> multiblockInvs;

    public static class_2960 id(String id) {
        return new class_2960(modid, id);
    }

    public void onInitialize() {
        LOGGER.info("Tom's Storage Setup starting");
        Content.init();
        invCablePainted = Platform.BLOCKS.register("ts.inventory_cable_painted", PaintedFramedInventoryCableBlock::new);
        invCableConnectorPainted = Platform.BLOCKS.register("ts.inventory_cable_connector_painted", FramedInventoryCableConnectorBlock::new);
        invProxyPainted = Platform.BLOCKS.register("ts.inventory_proxy_painted", InventoryProxyBlock::new);
        Content.paintedTile.addBlocks(invCablePainted);
        Content.invCableConnectorTile.addBlocks(invCableConnectorPainted);
        Content.invProxyTile.addBlocks(invProxyPainted);
        Platform.BLOCK_ENTITY.register();
        ServerPlayNetworking.registerGlobalReceiver((class_2960)NetworkHandler.DATA_C2S, (s, p, h, buf, rp) -> {
            class_2487 tag = Platform.readNbtTag(buf);
            s.method_20493(() -> {
                if (p.field_7512 instanceof IDataReceiver) {
                    ((IDataReceiver)p.field_7512).receive(tag);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)NetworkHandler.OPEN_TERMINAL_C2S, (s, p, h, buf, rp) -> s.method_20493(() -> {
            class_1799 t = PlayerInvUtil.findItem((class_1657)p, i -> {
                WirelessTerminal e;
                class_1792 patt3666$temp = i.method_7909();
                return patt3666$temp instanceof WirelessTerminal && (e = (WirelessTerminal)patt3666$temp).canOpen((class_1799)i);
            }, class_1799.field_8037, Function.identity());
            if (!t.method_7960()) {
                ((WirelessTerminal)t.method_7909()).open((class_1657)p, t);
            }
        }));
        ServerLoginNetworking.registerGlobalReceiver((class_2960)StorageMod.id("config"), (server, handler, understood, buf, sync, respSender) -> {});
        ServerLoginConnectionEvents.QUERY_START.register((handler, server, sender, sync) -> {
            class_2540 packet = PacketByteBufs.create();
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new ByteBufOutputStream((ByteBuf)packet));){
                gson.toJson((Object)LOADED_CONFIG, (Appendable)writer);
            }
            catch (IOException e) {
                LOGGER.warn("Error sending config sync", (Throwable)e);
            }
            sender.sendPacket(StorageMod.id("config"), packet);
        });
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            CONFIG = LOADED_CONFIG;
        });
        StorageTags.init();
        configHolder.registerSaveListener((a, b) -> {
            multiblockInvs = null;
            return class_1269.field_5811;
        });
    }

    static {
        gson = new GsonBuilder().create();
        configHolder = AutoConfig.register(Config.class, GsonConfigSerializer::new);
        LOADED_CONFIG = (Config)configHolder.getConfig();
        CONFIG = new Config();
    }
}

